/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.AccessControlTranslation;
import com.amazonaws.s3.model.EncryptionConfiguration;
import com.amazonaws.s3.model.Metrics;
import com.amazonaws.s3.model.ReplicationTime;
import com.amazonaws.s3.model.StorageClass;
import java.util.Objects;

public class Destination {
    String bucket;
    String account;
    StorageClass storageClass;
    AccessControlTranslation accessControlTranslation;
    EncryptionConfiguration encryptionConfiguration;
    ReplicationTime replicationTime;
    Metrics metrics;

    Destination() {
        this.bucket = "";
        this.account = "";
        this.storageClass = null;
        this.accessControlTranslation = null;
        this.encryptionConfiguration = null;
        this.replicationTime = null;
        this.metrics = null;
    }

    protected Destination(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.account = builder.account;
        this.storageClass = builder.storageClass;
        this.accessControlTranslation = builder.accessControlTranslation;
        this.encryptionConfiguration = builder.encryptionConfiguration;
        this.replicationTime = builder.replicationTime;
        this.metrics = builder.metrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(Destination.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof Destination;
    }

    public String bucket() {
        return this.bucket;
    }

    public String account() {
        return this.account;
    }

    public StorageClass storageClass() {
        return this.storageClass;
    }

    public AccessControlTranslation accessControlTranslation() {
        return this.accessControlTranslation;
    }

    public EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public ReplicationTime replicationTime() {
        return this.replicationTime;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String account;
        StorageClass storageClass;
        AccessControlTranslation accessControlTranslation;
        EncryptionConfiguration encryptionConfiguration;
        ReplicationTime replicationTime;
        Metrics metrics;

        protected BuilderImpl() {
        }

        private BuilderImpl(Destination model) {
            this.bucket(model.bucket);
            this.account(model.account);
            this.storageClass(model.storageClass);
            this.accessControlTranslation(model.accessControlTranslation);
            this.encryptionConfiguration(model.encryptionConfiguration);
            this.replicationTime(model.replicationTime);
            this.metrics(model.metrics);
        }

        @Override
        public Destination build() {
            return new Destination(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder accessControlTranslation(AccessControlTranslation accessControlTranslation) {
            this.accessControlTranslation = accessControlTranslation;
            return this;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public final Builder replicationTime(ReplicationTime replicationTime) {
            this.replicationTime = replicationTime;
            return this;
        }

        @Override
        public final Builder metrics(Metrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String account() {
            return this.account;
        }

        public StorageClass storageClass() {
            return this.storageClass;
        }

        public AccessControlTranslation accessControlTranslation() {
            return this.accessControlTranslation;
        }

        public EncryptionConfiguration encryptionConfiguration() {
            return this.encryptionConfiguration;
        }

        public ReplicationTime replicationTime() {
            return this.replicationTime;
        }

        public Metrics metrics() {
            return this.metrics;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder account(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder accessControlTranslation(AccessControlTranslation var1);

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        public Builder replicationTime(ReplicationTime var1);

        public Builder metrics(Metrics var1);

        public Destination build();
    }
}

