/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.Tagging;
import java.util.Objects;
import software.amazon.awssdk.crt.http.HttpHeader;

public class PutObjectTaggingRequest {
    String bucket;
    String key;
    String versionId;
    String contentMD5;
    Tagging tagging;
    String expectedBucketOwner;
    HttpHeader[] customHeaders;
    String customQueryParameters;

    PutObjectTaggingRequest() {
        this.bucket = "";
        this.key = "";
        this.versionId = "";
        this.contentMD5 = "";
        this.tagging = null;
        this.expectedBucketOwner = "";
        this.customHeaders = null;
        this.customQueryParameters = "";
    }

    protected PutObjectTaggingRequest(BuilderImpl builder) {
        this.bucket = builder.bucket;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.contentMD5 = builder.contentMD5;
        this.tagging = builder.tagging;
        this.expectedBucketOwner = builder.expectedBucketOwner;
        this.customHeaders = builder.customHeaders;
        this.customQueryParameters = builder.customQueryParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(PutObjectTaggingRequest.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof PutObjectTaggingRequest;
    }

    public String bucket() {
        return this.bucket;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public String contentMD5() {
        return this.contentMD5;
    }

    public Tagging tagging() {
        return this.tagging;
    }

    public String expectedBucketOwner() {
        return this.expectedBucketOwner;
    }

    public HttpHeader[] customHeaders() {
        return this.customHeaders;
    }

    public String customQueryParameters() {
        return this.customQueryParameters;
    }

    protected static class BuilderImpl
    implements Builder {
        String bucket;
        String key;
        String versionId;
        String contentMD5;
        Tagging tagging;
        String expectedBucketOwner;
        HttpHeader[] customHeaders;
        String customQueryParameters;

        protected BuilderImpl() {
        }

        private BuilderImpl(PutObjectTaggingRequest model) {
            this.bucket(model.bucket);
            this.key(model.key);
            this.versionId(model.versionId);
            this.contentMD5(model.contentMD5);
            this.tagging(model.tagging);
            this.expectedBucketOwner(model.expectedBucketOwner);
            this.customHeaders(model.customHeaders);
            this.customQueryParameters(model.customQueryParameters);
        }

        @Override
        public PutObjectTaggingRequest build() {
            return new PutObjectTaggingRequest(this);
        }

        @Override
        public final Builder bucket(String bucket) {
            this.bucket = bucket;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public final Builder contentMD5(String contentMD5) {
            this.contentMD5 = contentMD5;
            return this;
        }

        @Override
        public final Builder tagging(Tagging tagging) {
            this.tagging = tagging;
            return this;
        }

        @Override
        public final Builder expectedBucketOwner(String expectedBucketOwner) {
            this.expectedBucketOwner = expectedBucketOwner;
            return this;
        }

        @Override
        public final Builder customHeaders(HttpHeader[] customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        @Override
        public final Builder customQueryParameters(String customQueryParameters) {
            this.customQueryParameters = customQueryParameters;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String bucket() {
            return this.bucket;
        }

        public String key() {
            return this.key;
        }

        public String versionId() {
            return this.versionId;
        }

        public String contentMD5() {
            return this.contentMD5;
        }

        public Tagging tagging() {
            return this.tagging;
        }

        public String expectedBucketOwner() {
            return this.expectedBucketOwner;
        }

        public HttpHeader[] customHeaders() {
            return this.customHeaders;
        }

        public String customQueryParameters() {
            return this.customQueryParameters;
        }
    }

    public static interface Builder {
        public Builder bucket(String var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder contentMD5(String var1);

        public Builder tagging(Tagging var1);

        public Builder expectedBucketOwner(String var1);

        public Builder customHeaders(HttpHeader[] var1);

        public Builder customQueryParameters(String var1);

        public PutObjectTaggingRequest build();
    }
}

