/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.ObjectVersionStorageClass;
import com.amazonaws.s3.model.Owner;
import java.time.Instant;
import java.util.Objects;

public class ObjectVersion {
    String eTag;
    Integer size;
    ObjectVersionStorageClass storageClass;
    String key;
    String versionId;
    Boolean isLatest;
    Instant lastModified;
    Owner owner;

    ObjectVersion() {
        this.eTag = "";
        this.size = null;
        this.storageClass = null;
        this.key = "";
        this.versionId = "";
        this.isLatest = null;
        this.lastModified = null;
        this.owner = null;
    }

    protected ObjectVersion(BuilderImpl builder) {
        this.eTag = builder.eTag;
        this.size = builder.size;
        this.storageClass = builder.storageClass;
        this.key = builder.key;
        this.versionId = builder.versionId;
        this.isLatest = builder.isLatest;
        this.lastModified = builder.lastModified;
        this.owner = builder.owner;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(ObjectVersion.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof ObjectVersion;
    }

    public String eTag() {
        return this.eTag;
    }

    public Integer size() {
        return this.size;
    }

    public ObjectVersionStorageClass storageClass() {
        return this.storageClass;
    }

    public String key() {
        return this.key;
    }

    public String versionId() {
        return this.versionId;
    }

    public Boolean isLatest() {
        return this.isLatest;
    }

    public Instant lastModified() {
        return this.lastModified;
    }

    public Owner owner() {
        return this.owner;
    }

    protected static class BuilderImpl
    implements Builder {
        String eTag;
        Integer size;
        ObjectVersionStorageClass storageClass;
        String key;
        String versionId;
        Boolean isLatest;
        Instant lastModified;
        Owner owner;

        protected BuilderImpl() {
        }

        private BuilderImpl(ObjectVersion model) {
            this.eTag(model.eTag);
            this.size(model.size);
            this.storageClass(model.storageClass);
            this.key(model.key);
            this.versionId(model.versionId);
            this.isLatest(model.isLatest);
            this.lastModified(model.lastModified);
            this.owner(model.owner);
        }

        @Override
        public ObjectVersion build() {
            return new ObjectVersion(this);
        }

        @Override
        public final Builder eTag(String eTag) {
            this.eTag = eTag;
            return this;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        @Override
        public final Builder storageClass(ObjectVersionStorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder versionId(String versionId) {
            this.versionId = versionId;
            return this;
        }

        @Override
        public final Builder isLatest(Boolean isLatest) {
            this.isLatest = isLatest;
            return this;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        @Override
        public final Builder owner(Owner owner) {
            this.owner = owner;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public String eTag() {
            return this.eTag;
        }

        public Integer size() {
            return this.size;
        }

        public ObjectVersionStorageClass storageClass() {
            return this.storageClass;
        }

        public String key() {
            return this.key;
        }

        public String versionId() {
            return this.versionId;
        }

        public Boolean isLatest() {
            return this.isLatest;
        }

        public Instant lastModified() {
            return this.lastModified;
        }

        public Owner owner() {
            return this.owner;
        }
    }

    public static interface Builder {
        public Builder eTag(String var1);

        public Builder size(Integer var1);

        public Builder storageClass(ObjectVersionStorageClass var1);

        public Builder key(String var1);

        public Builder versionId(String var1);

        public Builder isLatest(Boolean var1);

        public Builder lastModified(Instant var1);

        public Builder owner(Owner var1);

        public ObjectVersion build();
    }
}

