/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.InventoryDestination;
import com.amazonaws.s3.model.InventoryFilter;
import com.amazonaws.s3.model.InventoryIncludedObjectVersions;
import com.amazonaws.s3.model.InventoryOptionalField;
import com.amazonaws.s3.model.InventorySchedule;
import java.util.List;
import java.util.Objects;

public class InventoryConfiguration {
    InventoryDestination destination;
    Boolean isEnabled;
    InventoryFilter filter;
    String id;
    InventoryIncludedObjectVersions includedObjectVersions;
    List<InventoryOptionalField> optionalFields;
    InventorySchedule schedule;

    InventoryConfiguration() {
        this.destination = null;
        this.isEnabled = null;
        this.filter = null;
        this.id = "";
        this.includedObjectVersions = null;
        this.optionalFields = null;
        this.schedule = null;
    }

    protected InventoryConfiguration(BuilderImpl builder) {
        this.destination = builder.destination;
        this.isEnabled = builder.isEnabled;
        this.filter = builder.filter;
        this.id = builder.id;
        this.includedObjectVersions = builder.includedObjectVersions;
        this.optionalFields = builder.optionalFields;
        this.schedule = builder.schedule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(InventoryConfiguration.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof InventoryConfiguration;
    }

    public InventoryDestination destination() {
        return this.destination;
    }

    public Boolean isEnabled() {
        return this.isEnabled;
    }

    public InventoryFilter filter() {
        return this.filter;
    }

    public String id() {
        return this.id;
    }

    public InventoryIncludedObjectVersions includedObjectVersions() {
        return this.includedObjectVersions;
    }

    public List<InventoryOptionalField> optionalFields() {
        return this.optionalFields;
    }

    public InventorySchedule schedule() {
        return this.schedule;
    }

    protected static class BuilderImpl
    implements Builder {
        InventoryDestination destination;
        Boolean isEnabled;
        InventoryFilter filter;
        String id;
        InventoryIncludedObjectVersions includedObjectVersions;
        List<InventoryOptionalField> optionalFields;
        InventorySchedule schedule;

        protected BuilderImpl() {
        }

        private BuilderImpl(InventoryConfiguration model) {
            this.destination(model.destination);
            this.isEnabled(model.isEnabled);
            this.filter(model.filter);
            this.id(model.id);
            this.includedObjectVersions(model.includedObjectVersions);
            this.optionalFields(model.optionalFields);
            this.schedule(model.schedule);
        }

        @Override
        public InventoryConfiguration build() {
            return new InventoryConfiguration(this);
        }

        @Override
        public final Builder destination(InventoryDestination destination) {
            this.destination = destination;
            return this;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Override
        public final Builder filter(InventoryFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public final Builder includedObjectVersions(InventoryIncludedObjectVersions includedObjectVersions) {
            this.includedObjectVersions = includedObjectVersions;
            return this;
        }

        @Override
        public final Builder optionalFields(List<InventoryOptionalField> optionalFields) {
            this.optionalFields = optionalFields;
            return this;
        }

        @Override
        public final Builder schedule(InventorySchedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public InventoryDestination destination() {
            return this.destination;
        }

        public Boolean isEnabled() {
            return this.isEnabled;
        }

        public InventoryFilter filter() {
            return this.filter;
        }

        public String id() {
            return this.id;
        }

        public InventoryIncludedObjectVersions includedObjectVersions() {
            return this.includedObjectVersions;
        }

        public List<InventoryOptionalField> optionalFields() {
            return this.optionalFields;
        }

        public InventorySchedule schedule() {
            return this.schedule;
        }
    }

    public static interface Builder {
        public Builder destination(InventoryDestination var1);

        public Builder isEnabled(Boolean var1);

        public Builder filter(InventoryFilter var1);

        public Builder id(String var1);

        public Builder includedObjectVersions(InventoryIncludedObjectVersions var1);

        public Builder optionalFields(List<InventoryOptionalField> var1);

        public Builder schedule(InventorySchedule var1);

        public InventoryConfiguration build();
    }
}

