/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.s3.model;

import com.amazonaws.s3.model.LambdaFunctionConfiguration;
import com.amazonaws.s3.model.QueueConfiguration;
import com.amazonaws.s3.model.TopicConfiguration;
import java.util.List;
import java.util.Objects;

public class NotificationConfiguration {
    List<TopicConfiguration> topicConfigurations;
    List<QueueConfiguration> queueConfigurations;
    List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

    NotificationConfiguration() {
        this.topicConfigurations = null;
        this.queueConfigurations = null;
        this.lambdaFunctionConfigurations = null;
    }

    protected NotificationConfiguration(BuilderImpl builder) {
        this.topicConfigurations = builder.topicConfigurations;
        this.queueConfigurations = builder.queueConfigurations;
        this.lambdaFunctionConfigurations = builder.lambdaFunctionConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public int hashCode() {
        return Objects.hash(NotificationConfiguration.class);
    }

    public boolean equals(Object rhs) {
        if (rhs == null) {
            return false;
        }
        return rhs instanceof NotificationConfiguration;
    }

    public List<TopicConfiguration> topicConfigurations() {
        return this.topicConfigurations;
    }

    public List<QueueConfiguration> queueConfigurations() {
        return this.queueConfigurations;
    }

    public List<LambdaFunctionConfiguration> lambdaFunctionConfigurations() {
        return this.lambdaFunctionConfigurations;
    }

    protected static class BuilderImpl
    implements Builder {
        List<TopicConfiguration> topicConfigurations;
        List<QueueConfiguration> queueConfigurations;
        List<LambdaFunctionConfiguration> lambdaFunctionConfigurations;

        protected BuilderImpl() {
        }

        private BuilderImpl(NotificationConfiguration model) {
            this.topicConfigurations(model.topicConfigurations);
            this.queueConfigurations(model.queueConfigurations);
            this.lambdaFunctionConfigurations(model.lambdaFunctionConfigurations);
        }

        @Override
        public NotificationConfiguration build() {
            return new NotificationConfiguration(this);
        }

        @Override
        public final Builder topicConfigurations(List<TopicConfiguration> topicConfigurations) {
            this.topicConfigurations = topicConfigurations;
            return this;
        }

        @Override
        public final Builder queueConfigurations(List<QueueConfiguration> queueConfigurations) {
            this.queueConfigurations = queueConfigurations;
            return this;
        }

        @Override
        public final Builder lambdaFunctionConfigurations(List<LambdaFunctionConfiguration> lambdaFunctionConfigurations) {
            this.lambdaFunctionConfigurations = lambdaFunctionConfigurations;
            return this;
        }

        public int hashCode() {
            return Objects.hash(BuilderImpl.class);
        }

        public boolean equals(Object rhs) {
            if (rhs == null) {
                return false;
            }
            return rhs instanceof BuilderImpl;
        }

        public List<TopicConfiguration> topicConfigurations() {
            return this.topicConfigurations;
        }

        public List<QueueConfiguration> queueConfigurations() {
            return this.queueConfigurations;
        }

        public List<LambdaFunctionConfiguration> lambdaFunctionConfigurations() {
            return this.lambdaFunctionConfigurations;
        }
    }

    public static interface Builder {
        public Builder topicConfigurations(List<TopicConfiguration> var1);

        public Builder queueConfigurations(List<QueueConfiguration> var1);

        public Builder lambdaFunctionConfigurations(List<LambdaFunctionConfiguration> var1);

        public NotificationConfiguration build();
    }
}

