/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt5;

import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.ExponentialBackoffRetryOptions;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsContext;
import software.amazon.awssdk.crt.mqtt5.Mqtt5Client;
import software.amazon.awssdk.crt.mqtt5.Mqtt5WebsocketHandshakeTransformArgs;
import software.amazon.awssdk.crt.mqtt5.OnAttemptingConnectReturn;
import software.amazon.awssdk.crt.mqtt5.OnConnectionFailureReturn;
import software.amazon.awssdk.crt.mqtt5.OnConnectionSuccessReturn;
import software.amazon.awssdk.crt.mqtt5.OnDisconnectionReturn;
import software.amazon.awssdk.crt.mqtt5.OnStoppedReturn;
import software.amazon.awssdk.crt.mqtt5.PublishReturn;
import software.amazon.awssdk.crt.mqtt5.TopicAliasingOptions;
import software.amazon.awssdk.crt.mqtt5.packets.ConnectPacket;

public class Mqtt5ClientOptions {
    private String hostName;
    private Long port;
    private ClientBootstrap bootstrap;
    private SocketOptions socketOptions;
    private TlsContext tlsContext;
    private HttpProxyOptions httpProxyOptions;
    private ConnectPacket connectOptions;
    private ClientSessionBehavior sessionBehavior = ClientSessionBehavior.DEFAULT;
    private ExtendedValidationAndFlowControlOptions extendedValidationAndFlowControlOptions = ExtendedValidationAndFlowControlOptions.NONE;
    private ClientOfflineQueueBehavior offlineQueueBehavior = ClientOfflineQueueBehavior.DEFAULT;
    private ExponentialBackoffRetryOptions.JitterMode retryJitterMode = ExponentialBackoffRetryOptions.JitterMode.Default;
    private Long minReconnectDelayMs;
    private Long maxReconnectDelayMs;
    private Long minConnectedTimeToResetReconnectDelayMs;
    private Long pingTimeoutMs;
    private Long connackTimeoutMs;
    private Long ackTimeoutSeconds;
    private LifecycleEvents lifecycleEvents;
    private Consumer<Mqtt5WebsocketHandshakeTransformArgs> websocketHandshakeTransform;
    private PublishEvents publishEvents;
    private TopicAliasingOptions topicAliasingOptions;

    public String getHostName() {
        return this.hostName;
    }

    public Long getPort() {
        return this.port;
    }

    public ClientBootstrap getBootstrap() {
        return this.bootstrap;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public TlsContext getTlsContext() {
        return this.tlsContext;
    }

    public HttpProxyOptions getHttpProxyOptions() {
        return this.httpProxyOptions;
    }

    public ConnectPacket getConnectOptions() {
        return this.connectOptions;
    }

    public ClientSessionBehavior getSessionBehavior() {
        return this.sessionBehavior;
    }

    public ExtendedValidationAndFlowControlOptions getExtendedValidationAndFlowControlOptions() {
        return this.extendedValidationAndFlowControlOptions;
    }

    public ClientOfflineQueueBehavior getOfflineQueueBehavior() {
        return this.offlineQueueBehavior;
    }

    public ExponentialBackoffRetryOptions.JitterMode getRetryJitterMode() {
        return this.retryJitterMode;
    }

    public Long getMinReconnectDelayMs() {
        return this.minReconnectDelayMs;
    }

    public Long getMaxReconnectDelayMs() {
        return this.maxReconnectDelayMs;
    }

    public Long getMinConnectedTimeToResetReconnectDelayMs() {
        return this.minConnectedTimeToResetReconnectDelayMs;
    }

    public Long getPingTimeoutMs() {
        return this.pingTimeoutMs;
    }

    public Long getConnackTimeoutMs() {
        return this.connackTimeoutMs;
    }

    public Long getAckTimeoutSeconds() {
        return this.ackTimeoutSeconds;
    }

    public LifecycleEvents getLifecycleEvents() {
        return this.lifecycleEvents;
    }

    public Consumer<Mqtt5WebsocketHandshakeTransformArgs> getWebsocketHandshakeTransform() {
        return this.websocketHandshakeTransform;
    }

    public PublishEvents getPublishEvents() {
        return this.publishEvents;
    }

    public TopicAliasingOptions getTopicAliasingOptions() {
        return this.topicAliasingOptions;
    }

    public Mqtt5ClientOptions(Mqtt5ClientOptionsBuilder builder) {
        this.hostName = builder.hostName;
        this.port = builder.port;
        this.bootstrap = builder.bootstrap;
        this.socketOptions = builder.socketOptions;
        this.tlsContext = builder.tlsContext;
        this.httpProxyOptions = builder.httpProxyOptions;
        this.connectOptions = builder.connectOptions;
        this.sessionBehavior = builder.sessionBehavior;
        this.extendedValidationAndFlowControlOptions = builder.extendedValidationAndFlowControlOptions;
        this.offlineQueueBehavior = builder.offlineQueueBehavior;
        this.retryJitterMode = builder.retryJitterMode;
        this.minReconnectDelayMs = builder.minReconnectDelayMs;
        this.maxReconnectDelayMs = builder.maxReconnectDelayMs;
        this.minConnectedTimeToResetReconnectDelayMs = builder.minConnectedTimeToResetReconnectDelayMs;
        this.pingTimeoutMs = builder.pingTimeoutMs;
        this.connackTimeoutMs = builder.connackTimeoutMs;
        this.ackTimeoutSeconds = builder.ackTimeoutSeconds;
        this.lifecycleEvents = builder.lifecycleEvents;
        this.websocketHandshakeTransform = builder.websocketHandshakeTransform;
        this.publishEvents = builder.publishEvents;
        this.topicAliasingOptions = builder.topicAliasingOptions;
    }

    public static final class Mqtt5ClientOptionsBuilder {
        private String hostName;
        private Long port;
        private ClientBootstrap bootstrap;
        private SocketOptions socketOptions;
        private TlsContext tlsContext;
        private HttpProxyOptions httpProxyOptions;
        private ConnectPacket connectOptions;
        private ClientSessionBehavior sessionBehavior = ClientSessionBehavior.DEFAULT;
        private ExtendedValidationAndFlowControlOptions extendedValidationAndFlowControlOptions = ExtendedValidationAndFlowControlOptions.NONE;
        private ClientOfflineQueueBehavior offlineQueueBehavior = ClientOfflineQueueBehavior.DEFAULT;
        private ExponentialBackoffRetryOptions.JitterMode retryJitterMode = ExponentialBackoffRetryOptions.JitterMode.Default;
        private Long minReconnectDelayMs;
        private Long maxReconnectDelayMs;
        private Long minConnectedTimeToResetReconnectDelayMs;
        private Long pingTimeoutMs;
        private Long connackTimeoutMs;
        private Long ackTimeoutSeconds;
        private LifecycleEvents lifecycleEvents;
        private Consumer<Mqtt5WebsocketHandshakeTransformArgs> websocketHandshakeTransform;
        private PublishEvents publishEvents;
        private TopicAliasingOptions topicAliasingOptions;

        public Mqtt5ClientOptionsBuilder withHostName(String hostName) {
            this.hostName = hostName;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withPort(Long port) {
            this.port = port;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withBootstrap(ClientBootstrap bootstrap) {
            this.bootstrap = bootstrap;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withSocketOptions(SocketOptions socketOptions) {
            this.socketOptions = socketOptions;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withTlsContext(TlsContext tlsContext) {
            this.tlsContext = tlsContext;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withHttpProxyOptions(HttpProxyOptions httpProxyOptions) {
            this.httpProxyOptions = httpProxyOptions;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withConnectOptions(ConnectPacket connectOptions) {
            this.connectOptions = connectOptions;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withSessionBehavior(ClientSessionBehavior sessionBehavior) {
            this.sessionBehavior = sessionBehavior;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withExtendedValidationAndFlowControlOptions(ExtendedValidationAndFlowControlOptions extendedValidationAndFlowControlOptions) {
            this.extendedValidationAndFlowControlOptions = extendedValidationAndFlowControlOptions;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withOfflineQueueBehavior(ClientOfflineQueueBehavior offlineQueueBehavior) {
            this.offlineQueueBehavior = offlineQueueBehavior;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withRetryJitterMode(ExponentialBackoffRetryOptions.JitterMode retryJitterMode) {
            this.retryJitterMode = retryJitterMode;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withMinReconnectDelayMs(Long minReconnectDelayMs) {
            this.minReconnectDelayMs = minReconnectDelayMs;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withMaxReconnectDelayMs(Long maxReconnectDelayMs) {
            this.maxReconnectDelayMs = maxReconnectDelayMs;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withMinConnectedTimeToResetReconnectDelayMs(Long minConnectedTimeToResetReconnectDelayMs) {
            this.minConnectedTimeToResetReconnectDelayMs = minConnectedTimeToResetReconnectDelayMs;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withPingTimeoutMs(Long pingTimeoutMs) {
            this.pingTimeoutMs = pingTimeoutMs;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withConnackTimeoutMs(Long connackTimeoutMs) {
            this.connackTimeoutMs = connackTimeoutMs;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withAckTimeoutSeconds(Long ackTimeoutSeconds) {
            this.ackTimeoutSeconds = ackTimeoutSeconds;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withLifecycleEvents(LifecycleEvents lifecycleEvents) {
            this.lifecycleEvents = lifecycleEvents;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withWebsocketHandshakeTransform(Consumer<Mqtt5WebsocketHandshakeTransformArgs> handshakeTransform) {
            this.websocketHandshakeTransform = handshakeTransform;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withPublishEvents(PublishEvents publishEvents) {
            this.publishEvents = publishEvents;
            return this;
        }

        public Mqtt5ClientOptionsBuilder withTopicAliasingOptions(TopicAliasingOptions options) {
            this.topicAliasingOptions = options;
            return this;
        }

        public Mqtt5ClientOptionsBuilder(String hostName, Long port) {
            this.hostName = hostName;
            this.port = port;
        }

        public Mqtt5ClientOptions build() {
            return new Mqtt5ClientOptions(this);
        }
    }

    public static enum ClientOfflineQueueBehavior {
        DEFAULT(0),
        FAIL_NON_QOS1_PUBLISH_ON_DISCONNECT(1),
        FAIL_QOS0_PUBLISH_ON_DISCONNECT(2),
        FAIL_ALL_ON_DISCONNECT(3);

        private int type;
        private static Map<Integer, ClientOfflineQueueBehavior> enumMapping;

        private ClientOfflineQueueBehavior(int code) {
            this.type = code;
        }

        public int getValue() {
            return this.type;
        }

        public static ClientOfflineQueueBehavior getEnumValueFromInteger(int value) {
            ClientOfflineQueueBehavior enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal ClientOfflineQueueBehavior");
        }

        private static Map<Integer, ClientOfflineQueueBehavior> buildEnumMapping() {
            return Stream.of(ClientOfflineQueueBehavior.values()).collect(Collectors.toMap(ClientOfflineQueueBehavior::getValue, Function.identity()));
        }

        static {
            enumMapping = ClientOfflineQueueBehavior.buildEnumMapping();
        }
    }

    public static enum ExtendedValidationAndFlowControlOptions {
        NONE(0),
        AWS_IOT_CORE_DEFAULTS(1);

        private int type;
        private static Map<Integer, ExtendedValidationAndFlowControlOptions> enumMapping;

        private ExtendedValidationAndFlowControlOptions(int code) {
            this.type = code;
        }

        public int getValue() {
            return this.type;
        }

        public static ExtendedValidationAndFlowControlOptions getEnumValueFromInteger(int value) {
            ExtendedValidationAndFlowControlOptions enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal ExtendedValidationAndFlowControlOptions");
        }

        private static Map<Integer, ExtendedValidationAndFlowControlOptions> buildEnumMapping() {
            return Stream.of(ExtendedValidationAndFlowControlOptions.values()).collect(Collectors.toMap(ExtendedValidationAndFlowControlOptions::getValue, Function.identity()));
        }

        static {
            enumMapping = ExtendedValidationAndFlowControlOptions.buildEnumMapping();
        }
    }

    public static enum ClientSessionBehavior {
        DEFAULT(0),
        CLEAN(1),
        REJOIN_POST_SUCCESS(2),
        REJOIN_ALWAYS(3);

        private int type;
        private static Map<Integer, ClientSessionBehavior> enumMapping;

        private ClientSessionBehavior(int code) {
            this.type = code;
        }

        public int getValue() {
            return this.type;
        }

        public static ClientSessionBehavior getEnumValueFromInteger(int value) {
            ClientSessionBehavior enumValue = enumMapping.get(value);
            if (enumValue != null) {
                return enumValue;
            }
            throw new RuntimeException("Illegal ClientSessionBehavior");
        }

        private static Map<Integer, ClientSessionBehavior> buildEnumMapping() {
            return Stream.of(ClientSessionBehavior.values()).collect(Collectors.toMap(ClientSessionBehavior::getValue, Function.identity()));
        }

        static {
            enumMapping = ClientSessionBehavior.buildEnumMapping();
        }
    }

    public static interface PublishEvents {
        public void onMessageReceived(Mqtt5Client var1, PublishReturn var2);
    }

    public static interface LifecycleEvents {
        public void onAttemptingConnect(Mqtt5Client var1, OnAttemptingConnectReturn var2);

        public void onConnectionSuccess(Mqtt5Client var1, OnConnectionSuccessReturn var2);

        public void onConnectionFailure(Mqtt5Client var1, OnConnectionFailureReturn var2);

        public void onDisconnection(Mqtt5Client var1, OnDisconnectionReturn var2);

        public void onStopped(Mqtt5Client var1, OnStoppedReturn var2);
    }
}

