/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.http;

import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtResource;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManagerOptions;
import software.amazon.awssdk.crt.http.HttpManagerMetrics;
import software.amazon.awssdk.crt.http.HttpMonitoringOptions;
import software.amazon.awssdk.crt.http.HttpProxyEnvironmentVariableSetting;
import software.amazon.awssdk.crt.http.HttpProxyOptions;
import software.amazon.awssdk.crt.http.HttpVersion;
import software.amazon.awssdk.crt.io.ClientBootstrap;
import software.amazon.awssdk.crt.io.SocketOptions;
import software.amazon.awssdk.crt.io.TlsConnectionOptions;
import software.amazon.awssdk.crt.io.TlsContext;

public class HttpClientConnectionManager
extends CrtResource {
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private final long windowSize;
    private final URI uri;
    private final int port;
    private final int maxConnections;
    private final CompletableFuture<Void> shutdownComplete = new CompletableFuture();
    private final HttpVersion expectedHttpVersion;

    public static HttpClientConnectionManager create(HttpClientConnectionManagerOptions options) {
        return new HttpClientConnectionManager(options);
    }

    private HttpClientConnectionManager(HttpClientConnectionManagerOptions options) {
        options.validateOptions();
        URI uri = options.getUri();
        ClientBootstrap clientBootstrap = options.getClientBootstrap();
        SocketOptions socketOptions = options.getSocketOptions();
        boolean useTls = HTTPS.equals(uri.getScheme());
        TlsContext tlsContext = options.getTlsContext();
        TlsConnectionOptions tlsConnectionOptions = options.getTlsConnectionOptions();
        long windowSize = options.getWindowSize();
        int maxConnections = options.getMaxConnections();
        int port = options.getPort();
        if (port == -1 && (port = uri.getPort()) == -1) {
            if (HTTP.equals(uri.getScheme())) {
                port = 80;
            }
            if (HTTPS.equals(uri.getScheme())) {
                port = 443;
            }
        }
        HttpProxyOptions proxyOptions = options.getProxyOptions();
        this.windowSize = windowSize;
        this.uri = uri;
        this.port = port;
        this.maxConnections = maxConnections;
        this.expectedHttpVersion = options.getExpectedHttpVersion();
        int proxyConnectionType = 0;
        String proxyHost = null;
        int proxyPort = 0;
        TlsContext proxyTlsContext = null;
        int proxyAuthorizationType = 0;
        String proxyAuthorizationUsername = null;
        String proxyAuthorizationPassword = null;
        String noProxyHosts = null;
        if (proxyOptions != null) {
            proxyConnectionType = proxyOptions.getConnectionType().getValue();
            proxyHost = proxyOptions.getHost();
            proxyPort = proxyOptions.getPort();
            proxyTlsContext = proxyOptions.getTlsContext();
            proxyAuthorizationType = proxyOptions.getAuthorizationType().getValue();
            proxyAuthorizationUsername = proxyOptions.getAuthorizationUsername();
            proxyAuthorizationPassword = proxyOptions.getAuthorizationPassword();
            noProxyHosts = proxyOptions.getNoProxyHosts();
        }
        int environmentVariableProxyConnectionType = 0;
        TlsConnectionOptions environmentVariableProxyTlsConnectionOptions = null;
        int environmentVariableType = 0;
        HttpProxyEnvironmentVariableSetting environmentVariableSetting = options.getHttpProxyEnvironmentVariableSetting();
        if (environmentVariableSetting != null) {
            environmentVariableProxyConnectionType = environmentVariableSetting.getConnectionType().getValue();
            environmentVariableProxyTlsConnectionOptions = environmentVariableSetting.getTlsConnectionOptions();
            environmentVariableType = environmentVariableSetting.getEnvironmentVariableType().getValue();
        }
        HttpMonitoringOptions monitoringOptions = options.getMonitoringOptions();
        long monitoringThroughputThresholdInBytesPerSecond = 0L;
        int monitoringFailureIntervalInSeconds = 0;
        if (monitoringOptions != null) {
            monitoringThroughputThresholdInBytesPerSecond = monitoringOptions.getMinThroughputBytesPerSecond();
            monitoringFailureIntervalInSeconds = monitoringOptions.getAllowableThroughputFailureIntervalSeconds();
        }
        this.acquireNativeHandle(HttpClientConnectionManager.httpClientConnectionManagerNew(this, clientBootstrap.getNativeHandle(), socketOptions.getNativeHandle(), useTls && tlsContext != null ? tlsContext.getNativeHandle() : 0L, useTls && tlsConnectionOptions != null ? tlsConnectionOptions.getNativeHandle() : 0L, windowSize, uri.getHost().getBytes(UTF8), port, maxConnections, proxyConnectionType, proxyHost != null ? proxyHost.getBytes(UTF8) : null, proxyPort, proxyTlsContext != null ? proxyTlsContext.getNativeHandle() : 0L, proxyAuthorizationType, proxyAuthorizationUsername != null ? proxyAuthorizationUsername.getBytes(UTF8) : null, proxyAuthorizationPassword != null ? proxyAuthorizationPassword.getBytes(UTF8) : null, noProxyHosts != null ? noProxyHosts.getBytes(UTF8) : null, environmentVariableProxyConnectionType, environmentVariableProxyTlsConnectionOptions != null ? environmentVariableProxyTlsConnectionOptions.getNativeHandle() : 0L, environmentVariableType, options.isManualWindowManagement(), options.getMaxConnectionIdleInMilliseconds(), monitoringThroughputThresholdInBytesPerSecond, monitoringFailureIntervalInSeconds, this.expectedHttpVersion.getValue(), options.getMaxPendingConnectionAcquisitions(), options.getConnectionAcquisitionTimeoutInMilliseconds(), options.getResponseFirstByteTimeoutInMilliseconds()));
        this.addReferenceTo(clientBootstrap);
        if (useTls) {
            if (tlsContext != null) {
                this.addReferenceTo(tlsContext);
            }
            if (tlsConnectionOptions != null) {
                this.addReferenceTo(tlsConnectionOptions);
            }
        }
    }

    public CompletableFuture<HttpClientConnection> acquireConnection() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnectionManager has been closed, can't acquire new connections");
        }
        CompletableFuture<HttpClientConnection> returnedFuture = new CompletableFuture<HttpClientConnection>();
        HttpClientConnectionManager.httpClientConnectionManagerAcquireConnection(this.getNativeHandle(), returnedFuture);
        return returnedFuture;
    }

    public void releaseConnection(HttpClientConnection conn) {
        conn.close();
    }

    private void onShutdownComplete() {
        this.releaseReferences();
        this.shutdownComplete.complete(null);
    }

    @Override
    protected boolean canReleaseReferencesImmediately() {
        return false;
    }

    @Override
    protected void releaseNativeHandle() {
        if (!this.isNull()) {
            HttpClientConnectionManager.httpClientConnectionManagerRelease(this.getNativeHandle());
        }
    }

    public CompletableFuture<Void> getShutdownCompleteFuture() {
        return this.shutdownComplete;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public HttpManagerMetrics getManagerMetrics() {
        if (this.isNull()) {
            throw new IllegalStateException("HttpClientConnectionManager has been closed, can't fetch metrics");
        }
        return HttpClientConnectionManager.httpConnectionManagerFetchMetrics(this.getNativeHandle());
    }

    public long getWindowSize() {
        return this.windowSize;
    }

    public URI getUri() {
        return this.uri;
    }

    private static native long httpClientConnectionManagerNew(HttpClientConnectionManager var0, long var1, long var3, long var5, long var7, long var9, byte[] var11, int var12, int var13, int var14, byte[] var15, int var16, long var17, int var19, byte[] var20, byte[] var21, byte[] var22, int var23, long var24, int var26, boolean var27, long var28, long var30, int var32, int var33, long var34, long var36, long var38) throws CrtRuntimeException;

    private static native void httpClientConnectionManagerRelease(long var0) throws CrtRuntimeException;

    private static native void httpClientConnectionManagerAcquireConnection(long var0, CompletableFuture<HttpClientConnection> var2) throws CrtRuntimeException;

    private static native HttpManagerMetrics httpConnectionManagerFetchMetrics(long var0) throws CrtRuntimeException;
}

