/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.auth.signing;

import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.crt.CrtRuntimeException;
import software.amazon.awssdk.crt.auth.signing.AwsSigningConfig;
import software.amazon.awssdk.crt.http.HttpRequest;
import software.amazon.awssdk.crt.http.HttpRequestBodyStream;

public class AwsSigner {
    public static CompletableFuture<HttpRequest> signRequest(HttpRequest request, AwsSigningConfig config) {
        CompletableFuture<HttpRequest> future = new CompletableFuture<HttpRequest>();
        try {
            AwsSigner.awsSignerSignRequest(request, request.marshalForJni(), config, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    public static CompletableFuture<String> signChunk(HttpRequestBodyStream chunkBody, String previousSignature, AwsSigningConfig config) {
        CompletableFuture<String> future = new CompletableFuture<String>();
        try {
            AwsSigner.awsSignerSignChunk(chunkBody, previousSignature, config, future);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
        }
        return future;
    }

    private static native void awsSignerSignRequest(HttpRequest var0, byte[] var1, AwsSigningConfig var2, CompletableFuture<HttpRequest> var3) throws CrtRuntimeException;

    private static native void awsSignerSignChunk(HttpRequestBodyStream var0, String var1, AwsSigningConfig var2, CompletableFuture<String> var3) throws CrtRuntimeException;
}

