/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Usage-specific statistics about the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainStats implements SdkPojo, Serializable, ToCopyableBuilder<DomainStats.Builder, DomainStats> {
    private static final SdkField<Long> PROFILE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ProfileCount").getter(getter(DomainStats::profileCount)).setter(setter(Builder::profileCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileCount").build()).build();

    private static final SdkField<Long> METERING_PROFILE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("MeteringProfileCount").getter(getter(DomainStats::meteringProfileCount))
            .setter(setter(Builder::meteringProfileCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringProfileCount").build())
            .build();

    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ObjectCount").getter(getter(DomainStats::objectCount)).setter(setter(Builder::objectCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectCount").build()).build();

    private static final SdkField<Long> TOTAL_SIZE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("TotalSize")
            .getter(getter(DomainStats::totalSize)).setter(setter(Builder::totalSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_COUNT_FIELD,
            METERING_PROFILE_COUNT_FIELD, OBJECT_COUNT_FIELD, TOTAL_SIZE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long profileCount;

    private final Long meteringProfileCount;

    private final Long objectCount;

    private final Long totalSize;

    private DomainStats(BuilderImpl builder) {
        this.profileCount = builder.profileCount;
        this.meteringProfileCount = builder.meteringProfileCount;
        this.objectCount = builder.objectCount;
        this.totalSize = builder.totalSize;
    }

    /**
     * <p>
     * The total number of profiles currently in the domain.
     * </p>
     * 
     * @return The total number of profiles currently in the domain.
     */
    public Long profileCount() {
        return profileCount;
    }

    /**
     * <p>
     * The number of profiles that you are currently paying for in the domain. If you have more than 100 objects
     * associated with a single profile, that profile counts as two profiles. If you have more than 200 objects, that
     * profile counts as three, and so on.
     * </p>
     * 
     * @return The number of profiles that you are currently paying for in the domain. If you have more than 100 objects
     *         associated with a single profile, that profile counts as two profiles. If you have more than 200 objects,
     *         that profile counts as three, and so on.
     */
    public Long meteringProfileCount() {
        return meteringProfileCount;
    }

    /**
     * <p>
     * The total number of objects in domain.
     * </p>
     * 
     * @return The total number of objects in domain.
     */
    public Long objectCount() {
        return objectCount;
    }

    /**
     * <p>
     * The total size, in bytes, of all objects in the domain.
     * </p>
     * 
     * @return The total size, in bytes, of all objects in the domain.
     */
    public Long totalSize() {
        return totalSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileCount());
        hashCode = 31 * hashCode + Objects.hashCode(meteringProfileCount());
        hashCode = 31 * hashCode + Objects.hashCode(objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalSize());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStats)) {
            return false;
        }
        DomainStats other = (DomainStats) obj;
        return Objects.equals(profileCount(), other.profileCount())
                && Objects.equals(meteringProfileCount(), other.meteringProfileCount())
                && Objects.equals(objectCount(), other.objectCount()) && Objects.equals(totalSize(), other.totalSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DomainStats").add("ProfileCount", profileCount())
                .add("MeteringProfileCount", meteringProfileCount()).add("ObjectCount", objectCount())
                .add("TotalSize", totalSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileCount":
            return Optional.ofNullable(clazz.cast(profileCount()));
        case "MeteringProfileCount":
            return Optional.ofNullable(clazz.cast(meteringProfileCount()));
        case "ObjectCount":
            return Optional.ofNullable(clazz.cast(objectCount()));
        case "TotalSize":
            return Optional.ofNullable(clazz.cast(totalSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainStats, T> g) {
        return obj -> g.apply((DomainStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainStats> {
        /**
         * <p>
         * The total number of profiles currently in the domain.
         * </p>
         * 
         * @param profileCount
         *        The total number of profiles currently in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileCount(Long profileCount);

        /**
         * <p>
         * The number of profiles that you are currently paying for in the domain. If you have more than 100 objects
         * associated with a single profile, that profile counts as two profiles. If you have more than 200 objects,
         * that profile counts as three, and so on.
         * </p>
         * 
         * @param meteringProfileCount
         *        The number of profiles that you are currently paying for in the domain. If you have more than 100
         *        objects associated with a single profile, that profile counts as two profiles. If you have more than
         *        200 objects, that profile counts as three, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder meteringProfileCount(Long meteringProfileCount);

        /**
         * <p>
         * The total number of objects in domain.
         * </p>
         * 
         * @param objectCount
         *        The total number of objects in domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectCount(Long objectCount);

        /**
         * <p>
         * The total size, in bytes, of all objects in the domain.
         * </p>
         * 
         * @param totalSize
         *        The total size, in bytes, of all objects in the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSize(Long totalSize);
    }

    static final class BuilderImpl implements Builder {
        private Long profileCount;

        private Long meteringProfileCount;

        private Long objectCount;

        private Long totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStats model) {
            profileCount(model.profileCount);
            meteringProfileCount(model.meteringProfileCount);
            objectCount(model.objectCount);
            totalSize(model.totalSize);
        }

        public final Long getProfileCount() {
            return profileCount;
        }

        @Override
        public final Builder profileCount(Long profileCount) {
            this.profileCount = profileCount;
            return this;
        }

        public final void setProfileCount(Long profileCount) {
            this.profileCount = profileCount;
        }

        public final Long getMeteringProfileCount() {
            return meteringProfileCount;
        }

        @Override
        public final Builder meteringProfileCount(Long meteringProfileCount) {
            this.meteringProfileCount = meteringProfileCount;
            return this;
        }

        public final void setMeteringProfileCount(Long meteringProfileCount) {
            this.meteringProfileCount = meteringProfileCount;
        }

        public final Long getObjectCount() {
            return objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final Long getTotalSize() {
            return totalSize;
        }

        @Override
        public final Builder totalSize(Long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public final void setTotalSize(Long totalSize) {
            this.totalSize = totalSize;
        }

        @Override
        public DomainStats build() {
            return new DomainStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
