/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProfileObjectResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<PutProfileObjectResponse.Builder, PutProfileObjectResponse> {
    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileObjectUniqueKey").getter(getter(PutProfileObjectResponse::profileObjectUniqueKey))
            .setter(setter(Builder::profileObjectUniqueKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PROFILE_OBJECT_UNIQUE_KEY_FIELD));

    private final String profileObjectUniqueKey;

    private PutProfileObjectResponse(BuilderImpl builder) {
        super(builder);
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
    }

    /**
     * <p>
     * The unique identifier of the profile object generated by the service.
     * </p>
     * 
     * @return The unique identifier of the profile object generated by the service.
     */
    public String profileObjectUniqueKey() {
        return profileObjectUniqueKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileObjectUniqueKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProfileObjectResponse)) {
            return false;
        }
        PutProfileObjectResponse other = (PutProfileObjectResponse) obj;
        return Objects.equals(profileObjectUniqueKey(), other.profileObjectUniqueKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PutProfileObjectResponse").add("ProfileObjectUniqueKey", profileObjectUniqueKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileObjectUniqueKey":
            return Optional.ofNullable(clazz.cast(profileObjectUniqueKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProfileObjectResponse, T> g) {
        return obj -> g.apply((PutProfileObjectResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProfileObjectResponse> {
        /**
         * <p>
         * The unique identifier of the profile object generated by the service.
         * </p>
         * 
         * @param profileObjectUniqueKey
         *        The unique identifier of the profile object generated by the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileObjectUniqueKey(String profileObjectUniqueKey);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String profileObjectUniqueKey;

        private BuilderImpl() {
        }

        private BuilderImpl(PutProfileObjectResponse model) {
            super(model);
            profileObjectUniqueKey(model.profileObjectUniqueKey);
        }

        public final String getProfileObjectUniqueKey() {
            return profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        @Override
        public PutProfileObjectResponse build() {
            return new PutProfileObjectResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
