/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDomainRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<UpdateDomainRequest.Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateDomainRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DefaultExpirationDays").getter(getter(UpdateDomainRequest::defaultExpirationDays))
            .setter(setter(Builder::defaultExpirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build())
            .build();

    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultEncryptionKey").getter(getter(UpdateDomainRequest::defaultEncryptionKey))
            .setter(setter(Builder::defaultEncryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build())
            .build();

    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeadLetterQueueUrl").getter(getter(UpdateDomainRequest::deadLetterQueueUrl))
            .setter(setter(Builder::deadLetterQueueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(UpdateDomainRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, TAGS_FIELD));

    private final String domainName;

    private final Integer defaultExpirationDays;

    private final String defaultEncryptionKey;

    private final String deadLetterQueueUrl;

    private final Map<String, String> tags;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name for the domain.
     * </p>
     * 
     * @return The unique name for the domain.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The default number of days until the data within the domain expires.
     * </p>
     * 
     * @return The default number of days until the data within the domain expires.
     */
    public Integer defaultExpirationDays() {
        return defaultExpirationDays;
    }

    /**
     * <p>
     * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
     * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If
     * specified as an empty string, it will clear any existing value.
     * </p>
     * 
     * @return The default encryption key, which is an AWS managed key, is used when no specific type of encryption key
     *         is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage.
     *         If specified as an empty string, it will clear any existing value.
     */
    public String defaultEncryptionKey() {
        return defaultEncryptionKey;
    }

    /**
     * <p>
     * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
     * third party applications. If specified as an empty string, it will clear any existing value. You must set up a
     * policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to send
     * messages to the DeadLetterQueue.
     * </p>
     * 
     * @return The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data
     *         from third party applications. If specified as an empty string, it will clear any existing value. You
     *         must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect
     *         Customer Profiles to send messages to the DeadLetterQueue.
     */
    public String deadLetterQueueUrl() {
        return deadLetterQueueUrl;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(defaultExpirationDays(), other.defaultExpirationDays())
                && Objects.equals(defaultEncryptionKey(), other.defaultEncryptionKey())
                && Objects.equals(deadLetterQueueUrl(), other.deadLetterQueueUrl()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDomainRequest").add("DomainName", domainName())
                .add("DefaultExpirationDays", defaultExpirationDays()).add("DefaultEncryptionKey", defaultEncryptionKey())
                .add("DeadLetterQueueUrl", deadLetterQueueUrl()).add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "DefaultExpirationDays":
            return Optional.ofNullable(clazz.cast(defaultExpirationDays()));
        case "DefaultEncryptionKey":
            return Optional.ofNullable(clazz.cast(defaultEncryptionKey()));
        case "DeadLetterQueueUrl":
            return Optional.ofNullable(clazz.cast(deadLetterQueueUrl()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDomainRequest> {
        /**
         * <p>
         * The unique name for the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The default number of days until the data within the domain expires.
         * </p>
         * 
         * @param defaultExpirationDays
         *        The default number of days until the data within the domain expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultExpirationDays(Integer defaultExpirationDays);

        /**
         * <p>
         * The default encryption key, which is an AWS managed key, is used when no specific type of encryption key is
         * specified. It is used to encrypt all data before it is placed in permanent or semi-permanent storage. If
         * specified as an empty string, it will clear any existing value.
         * </p>
         * 
         * @param defaultEncryptionKey
         *        The default encryption key, which is an AWS managed key, is used when no specific type of encryption
         *        key is specified. It is used to encrypt all data before it is placed in permanent or semi-permanent
         *        storage. If specified as an empty string, it will clear any existing value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultEncryptionKey(String defaultEncryptionKey);

        /**
         * <p>
         * The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting data from
         * third party applications. If specified as an empty string, it will clear any existing value. You must set up
         * a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect Customer Profiles to
         * send messages to the DeadLetterQueue.
         * </p>
         * 
         * @param deadLetterQueueUrl
         *        The URL of the SQS dead letter queue, which is used for reporting errors associated with ingesting
         *        data from third party applications. If specified as an empty string, it will clear any existing value.
         *        You must set up a policy on the DeadLetterQueue for the SendMessage operation to enable Amazon Connect
         *        Customer Profiles to send messages to the DeadLetterQueue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deadLetterQueueUrl(String deadLetterQueueUrl);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private Integer defaultExpirationDays;

        private String defaultEncryptionKey;

        private String deadLetterQueueUrl;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            domainName(model.domainName);
            defaultExpirationDays(model.defaultExpirationDays);
            defaultEncryptionKey(model.defaultEncryptionKey);
            deadLetterQueueUrl(model.deadLetterQueueUrl);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDefaultExpirationDays() {
            return defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        public final String getDefaultEncryptionKey() {
            return defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        public final String getDeadLetterQueueUrl() {
            return deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
