/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.FieldMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.KeyMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeField;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeKey;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutProfileObjectTypeRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, PutProfileObjectTypeRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::domainName)).setter(PutProfileObjectTypeRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::objectTypeName)).setter(PutProfileObjectTypeRequest.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::description)).setter(PutProfileObjectTypeRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::templateId)).setter(PutProfileObjectTypeRequest.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationDays").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::expirationDays)).setter(PutProfileObjectTypeRequest.setter(Builder::expirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::encryptionKey)).setter(PutProfileObjectTypeRequest.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowProfileCreation").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::allowProfileCreation)).setter(PutProfileObjectTypeRequest.setter(Builder::allowProfileCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build()}).build();
    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Fields").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::fields)).setter(PutProfileObjectTypeRequest.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Keys").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::keys)).setter(PutProfileObjectTypeRequest.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(PutProfileObjectTypeRequest.getter(PutProfileObjectTypeRequest::tags)).setter(PutProfileObjectTypeRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, EXPIRATION_DAYS_FIELD, ENCRYPTION_KEY_FIELD, ALLOW_PROFILE_CREATION_FIELD, FIELDS_FIELD, KEYS_FIELD, TAGS_FIELD));
    private final String domainName;
    private final String objectTypeName;
    private final String description;
    private final String templateId;
    private final Integer expirationDays;
    private final String encryptionKey;
    private final Boolean allowProfileCreation;
    private final Map<String, ObjectTypeField> fields;
    private final Map<String, List<ObjectTypeKey>> keys;
    private final Map<String, String> tags;

    private PutProfileObjectTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.expirationDays = builder.expirationDays;
        this.encryptionKey = builder.encryptionKey;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.fields = builder.fields;
        this.keys = builder.keys;
        this.tags = builder.tags;
    }

    public String domainName() {
        return this.domainName;
    }

    public String objectTypeName() {
        return this.objectTypeName;
    }

    public String description() {
        return this.description;
    }

    public String templateId() {
        return this.templateId;
    }

    public Integer expirationDays() {
        return this.expirationDays;
    }

    public String encryptionKey() {
        return this.encryptionKey;
    }

    public Boolean allowProfileCreation() {
        return this.allowProfileCreation;
    }

    public boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public Map<String, ObjectTypeField> fields() {
        return this.fields;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructMap);
    }

    public Map<String, List<ObjectTypeKey>> keys() {
        return this.keys;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProfileObjectTypeRequest)) {
            return false;
        }
        PutProfileObjectTypeRequest other = (PutProfileObjectTypeRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.expirationDays(), other.expirationDays()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.allowProfileCreation(), other.allowProfileCreation()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"PutProfileObjectTypeRequest").add("DomainName", (Object)this.domainName()).add("ObjectTypeName", (Object)this.objectTypeName()).add("Description", (Object)this.description()).add("TemplateId", (Object)this.templateId()).add("ExpirationDays", (Object)this.expirationDays()).add("EncryptionKey", (Object)this.encryptionKey()).add("AllowProfileCreation", (Object)this.allowProfileCreation()).add("Fields", this.hasFields() ? this.fields() : null).add("Keys", this.hasKeys() ? this.keys() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "ExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.expirationDays()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "AllowProfileCreation": {
                return Optional.ofNullable(clazz.cast(this.allowProfileCreation()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProfileObjectTypeRequest, T> g) {
        return obj -> g.apply((PutProfileObjectTypeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private String objectTypeName;
        private String description;
        private String templateId;
        private Integer expirationDays;
        private String encryptionKey;
        private Boolean allowProfileCreation;
        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProfileObjectTypeRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.objectTypeName(model.objectTypeName);
            this.description(model.description);
            this.templateId(model.templateId);
            this.expirationDays(model.expirationDays);
            this.encryptionKey(model.encryptionKey);
            this.allowProfileCreation(model.allowProfileCreation);
            this.fields(model.fields);
            this.keys(model.keys);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final Integer getExpirationDays() {
            return this.expirationDays;
        }

        @Override
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Boolean getAllowProfileCreation() {
            return this.allowProfileCreation;
        }

        @Override
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            if (this.fields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.fields != null ? CollectionUtils.mapValues(this.fields, ObjectTypeField::toBuilder) : null;
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        public final Map<String, ? extends Collection<ObjectTypeKey>> getKeys() {
            if (this.keys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keys;
        }

        @Override
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProfileObjectTypeRequest build() {
            return new PutProfileObjectTypeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutProfileObjectTypeRequest> {
        public Builder domainName(String var1);

        public Builder objectTypeName(String var1);

        public Builder description(String var1);

        public Builder templateId(String var1);

        public Builder expirationDays(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder allowProfileCreation(Boolean var1);

        public Builder fields(Map<String, ObjectTypeField> var1);

        public Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

