/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StandardIdentifier {
    PROFILE("PROFILE"),
    UNIQUE("UNIQUE"),
    SECONDARY("SECONDARY"),
    LOOKUP_ONLY("LOOKUP_ONLY"),
    NEW_ONLY("NEW_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StandardIdentifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StandardIdentifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StandardIdentifier.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StandardIdentifier> knownValues() {
        return Stream.of(StandardIdentifier.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

