/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DomainStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DomainStats> {
    private static final SdkField<Long> PROFILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProfileCount").getter(DomainStats.getter(DomainStats::profileCount)).setter(DomainStats.setter(Builder::profileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileCount").build()}).build();
    private static final SdkField<Long> METERING_PROFILE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MeteringProfileCount").getter(DomainStats.getter(DomainStats::meteringProfileCount)).setter(DomainStats.setter(Builder::meteringProfileCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeteringProfileCount").build()}).build();
    private static final SdkField<Long> OBJECT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ObjectCount").getter(DomainStats.getter(DomainStats::objectCount)).setter(DomainStats.setter(Builder::objectCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectCount").build()}).build();
    private static final SdkField<Long> TOTAL_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalSize").getter(DomainStats.getter(DomainStats::totalSize)).setter(DomainStats.setter(Builder::totalSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSize").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_COUNT_FIELD, METERING_PROFILE_COUNT_FIELD, OBJECT_COUNT_FIELD, TOTAL_SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long profileCount;
    private final Long meteringProfileCount;
    private final Long objectCount;
    private final Long totalSize;

    private DomainStats(BuilderImpl builder) {
        this.profileCount = builder.profileCount;
        this.meteringProfileCount = builder.meteringProfileCount;
        this.objectCount = builder.objectCount;
        this.totalSize = builder.totalSize;
    }

    public Long profileCount() {
        return this.profileCount;
    }

    public Long meteringProfileCount() {
        return this.meteringProfileCount;
    }

    public Long objectCount() {
        return this.objectCount;
    }

    public Long totalSize() {
        return this.totalSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.profileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.meteringProfileCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSize());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainStats)) {
            return false;
        }
        DomainStats other = (DomainStats)obj;
        return Objects.equals(this.profileCount(), other.profileCount()) && Objects.equals(this.meteringProfileCount(), other.meteringProfileCount()) && Objects.equals(this.objectCount(), other.objectCount()) && Objects.equals(this.totalSize(), other.totalSize());
    }

    public String toString() {
        return ToString.builder((String)"DomainStats").add("ProfileCount", (Object)this.profileCount()).add("MeteringProfileCount", (Object)this.meteringProfileCount()).add("ObjectCount", (Object)this.objectCount()).add("TotalSize", (Object)this.totalSize()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProfileCount": {
                return Optional.ofNullable(clazz.cast(this.profileCount()));
            }
            case "MeteringProfileCount": {
                return Optional.ofNullable(clazz.cast(this.meteringProfileCount()));
            }
            case "ObjectCount": {
                return Optional.ofNullable(clazz.cast(this.objectCount()));
            }
            case "TotalSize": {
                return Optional.ofNullable(clazz.cast(this.totalSize()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainStats, T> g) {
        return obj -> g.apply((DomainStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long profileCount;
        private Long meteringProfileCount;
        private Long objectCount;
        private Long totalSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainStats model) {
            this.profileCount(model.profileCount);
            this.meteringProfileCount(model.meteringProfileCount);
            this.objectCount(model.objectCount);
            this.totalSize(model.totalSize);
        }

        public final Long getProfileCount() {
            return this.profileCount;
        }

        @Override
        public final Builder profileCount(Long profileCount) {
            this.profileCount = profileCount;
            return this;
        }

        public final void setProfileCount(Long profileCount) {
            this.profileCount = profileCount;
        }

        public final Long getMeteringProfileCount() {
            return this.meteringProfileCount;
        }

        @Override
        public final Builder meteringProfileCount(Long meteringProfileCount) {
            this.meteringProfileCount = meteringProfileCount;
            return this;
        }

        public final void setMeteringProfileCount(Long meteringProfileCount) {
            this.meteringProfileCount = meteringProfileCount;
        }

        public final Long getObjectCount() {
            return this.objectCount;
        }

        @Override
        public final Builder objectCount(Long objectCount) {
            this.objectCount = objectCount;
            return this;
        }

        public final void setObjectCount(Long objectCount) {
            this.objectCount = objectCount;
        }

        public final Long getTotalSize() {
            return this.totalSize;
        }

        @Override
        public final Builder totalSize(Long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public final void setTotalSize(Long totalSize) {
            this.totalSize = totalSize;
        }

        public DomainStats build() {
            return new DomainStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DomainStats> {
        public Builder profileCount(Long var1);

        public Builder meteringProfileCount(Long var1);

        public Builder objectCount(Long var1);

        public Builder totalSize(Long var1);
    }
}

