/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.FieldMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.KeyMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeField;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeKey;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileObjectTypeTemplateResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetProfileObjectTypeTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::templateId)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceName").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::sourceName)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::sourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()}).build();
    private static final SdkField<String> SOURCE_OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceObject").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::sourceObject)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::sourceObject)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObject").build()}).build();
    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowProfileCreation").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::allowProfileCreation)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::allowProfileCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build()}).build();
    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Fields").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::fields)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Keys").getter(GetProfileObjectTypeTemplateResponse.getter(GetProfileObjectTypeTemplateResponse::keys)).setter(GetProfileObjectTypeTemplateResponse.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD, SOURCE_NAME_FIELD, SOURCE_OBJECT_FIELD, ALLOW_PROFILE_CREATION_FIELD, FIELDS_FIELD, KEYS_FIELD));
    private final String templateId;
    private final String sourceName;
    private final String sourceObject;
    private final Boolean allowProfileCreation;
    private final Map<String, ObjectTypeField> fields;
    private final Map<String, List<ObjectTypeKey>> keys;

    private GetProfileObjectTypeTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.sourceName = builder.sourceName;
        this.sourceObject = builder.sourceObject;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.fields = builder.fields;
        this.keys = builder.keys;
    }

    public String templateId() {
        return this.templateId;
    }

    public String sourceName() {
        return this.sourceName;
    }

    public String sourceObject() {
        return this.sourceObject;
    }

    public Boolean allowProfileCreation() {
        return this.allowProfileCreation;
    }

    public boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public Map<String, ObjectTypeField> fields() {
        return this.fields;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructMap);
    }

    public Map<String, List<ObjectTypeKey>> keys() {
        return this.keys;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceObject());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileObjectTypeTemplateResponse)) {
            return false;
        }
        GetProfileObjectTypeTemplateResponse other = (GetProfileObjectTypeTemplateResponse)((Object)obj);
        return Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.sourceName(), other.sourceName()) && Objects.equals(this.sourceObject(), other.sourceObject()) && Objects.equals(this.allowProfileCreation(), other.allowProfileCreation()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys());
    }

    public String toString() {
        return ToString.builder((String)"GetProfileObjectTypeTemplateResponse").add("TemplateId", (Object)this.templateId()).add("SourceName", (Object)this.sourceName()).add("SourceObject", (Object)this.sourceObject()).add("AllowProfileCreation", (Object)this.allowProfileCreation()).add("Fields", this.hasFields() ? this.fields() : null).add("Keys", this.hasKeys() ? this.keys() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "SourceName": {
                return Optional.ofNullable(clazz.cast(this.sourceName()));
            }
            case "SourceObject": {
                return Optional.ofNullable(clazz.cast(this.sourceObject()));
            }
            case "AllowProfileCreation": {
                return Optional.ofNullable(clazz.cast(this.allowProfileCreation()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileObjectTypeTemplateResponse, T> g) {
        return obj -> g.apply((GetProfileObjectTypeTemplateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String templateId;
        private String sourceName;
        private String sourceObject;
        private Boolean allowProfileCreation;
        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileObjectTypeTemplateResponse model) {
            super(model);
            this.templateId(model.templateId);
            this.sourceName(model.sourceName);
            this.sourceObject(model.sourceObject);
            this.allowProfileCreation(model.allowProfileCreation);
            this.fields(model.fields);
            this.keys(model.keys);
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final String getSourceName() {
            return this.sourceName;
        }

        @Override
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        public final String getSourceObject() {
            return this.sourceObject;
        }

        @Override
        public final Builder sourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
            return this;
        }

        public final void setSourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
        }

        public final Boolean getAllowProfileCreation() {
            return this.allowProfileCreation;
        }

        @Override
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            if (this.fields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.fields != null ? CollectionUtils.mapValues(this.fields, ObjectTypeField::toBuilder) : null;
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        public final Map<String, ? extends Collection<ObjectTypeKey>> getKeys() {
            if (this.keys instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.keys;
        }

        @Override
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
        }

        @Override
        public GetProfileObjectTypeTemplateResponse build() {
            return new GetProfileObjectTypeTemplateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileObjectTypeTemplateResponse> {
        public Builder templateId(String var1);

        public Builder sourceName(String var1);

        public Builder sourceObject(String var1);

        public Builder allowProfileCreation(Boolean var1);

        public Builder fields(Map<String, ObjectTypeField> var1);

        public Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> var1);
    }
}

