/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListProfileObjectsItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListProfileObjectsItem> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(ListProfileObjectsItem.getter(ListProfileObjectsItem::objectTypeName)).setter(ListProfileObjectsItem.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> PROFILE_OBJECT_UNIQUE_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProfileObjectUniqueKey").getter(ListProfileObjectsItem.getter(ListProfileObjectsItem::profileObjectUniqueKey)).setter(ListProfileObjectsItem.setter(Builder::profileObjectUniqueKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileObjectUniqueKey").build()}).build();
    private static final SdkField<String> OBJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Object").getter(ListProfileObjectsItem.getter(ListProfileObjectsItem::object)).setter(ListProfileObjectsItem.setter(Builder::object)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD, PROFILE_OBJECT_UNIQUE_KEY_FIELD, OBJECT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String objectTypeName;
    private final String profileObjectUniqueKey;
    private final String object;

    private ListProfileObjectsItem(BuilderImpl builder) {
        this.objectTypeName = builder.objectTypeName;
        this.profileObjectUniqueKey = builder.profileObjectUniqueKey;
        this.object = builder.object;
    }

    public String objectTypeName() {
        return this.objectTypeName;
    }

    public String profileObjectUniqueKey() {
        return this.profileObjectUniqueKey;
    }

    public String object() {
        return this.object;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.profileObjectUniqueKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.object());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileObjectsItem)) {
            return false;
        }
        ListProfileObjectsItem other = (ListProfileObjectsItem)obj;
        return Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.profileObjectUniqueKey(), other.profileObjectUniqueKey()) && Objects.equals(this.object(), other.object());
    }

    public String toString() {
        return ToString.builder((String)"ListProfileObjectsItem").add("ObjectTypeName", (Object)this.objectTypeName()).add("ProfileObjectUniqueKey", (Object)this.profileObjectUniqueKey()).add("Object", (Object)this.object()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "ProfileObjectUniqueKey": {
                return Optional.ofNullable(clazz.cast(this.profileObjectUniqueKey()));
            }
            case "Object": {
                return Optional.ofNullable(clazz.cast(this.object()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileObjectsItem, T> g) {
        return obj -> g.apply((ListProfileObjectsItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String objectTypeName;
        private String profileObjectUniqueKey;
        private String object;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileObjectsItem model) {
            this.objectTypeName(model.objectTypeName);
            this.profileObjectUniqueKey(model.profileObjectUniqueKey);
            this.object(model.object);
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        public final String getProfileObjectUniqueKey() {
            return this.profileObjectUniqueKey;
        }

        @Override
        public final Builder profileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
            return this;
        }

        public final void setProfileObjectUniqueKey(String profileObjectUniqueKey) {
            this.profileObjectUniqueKey = profileObjectUniqueKey;
        }

        public final String getObject() {
            return this.object;
        }

        @Override
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        public ListProfileObjectsItem build() {
            return new ListProfileObjectsItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListProfileObjectsItem> {
        public Builder objectTypeName(String var1);

        public Builder profileObjectUniqueKey(String var1);

        public Builder object(String var1);
    }
}

