/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDomainRequest
extends CustomerProfilesRequest
implements ToCopyableBuilder<Builder, UpdateDomainRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainName").getter(UpdateDomainRequest.getter(UpdateDomainRequest::domainName)).setter(UpdateDomainRequest.setter(Builder::domainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()}).build();
    private static final SdkField<Integer> DEFAULT_EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DefaultExpirationDays").getter(UpdateDomainRequest.getter(UpdateDomainRequest::defaultExpirationDays)).setter(UpdateDomainRequest.setter(Builder::defaultExpirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultExpirationDays").build()}).build();
    private static final SdkField<String> DEFAULT_ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultEncryptionKey").getter(UpdateDomainRequest.getter(UpdateDomainRequest::defaultEncryptionKey)).setter(UpdateDomainRequest.setter(Builder::defaultEncryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultEncryptionKey").build()}).build();
    private static final SdkField<String> DEAD_LETTER_QUEUE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeadLetterQueueUrl").getter(UpdateDomainRequest.getter(UpdateDomainRequest::deadLetterQueueUrl)).setter(UpdateDomainRequest.setter(Builder::deadLetterQueueUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeadLetterQueueUrl").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(UpdateDomainRequest.getter(UpdateDomainRequest::tags)).setter(UpdateDomainRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, DEFAULT_EXPIRATION_DAYS_FIELD, DEFAULT_ENCRYPTION_KEY_FIELD, DEAD_LETTER_QUEUE_URL_FIELD, TAGS_FIELD));
    private final String domainName;
    private final Integer defaultExpirationDays;
    private final String defaultEncryptionKey;
    private final String deadLetterQueueUrl;
    private final Map<String, String> tags;

    private UpdateDomainRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.defaultExpirationDays = builder.defaultExpirationDays;
        this.defaultEncryptionKey = builder.defaultEncryptionKey;
        this.deadLetterQueueUrl = builder.deadLetterQueueUrl;
        this.tags = builder.tags;
    }

    public String domainName() {
        return this.domainName;
    }

    public Integer defaultExpirationDays() {
        return this.defaultExpirationDays;
    }

    public String defaultEncryptionKey() {
        return this.defaultEncryptionKey;
    }

    public String deadLetterQueueUrl() {
        return this.deadLetterQueueUrl;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultExpirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultEncryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.deadLetterQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDomainRequest)) {
            return false;
        }
        UpdateDomainRequest other = (UpdateDomainRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.defaultExpirationDays(), other.defaultExpirationDays()) && Objects.equals(this.defaultEncryptionKey(), other.defaultEncryptionKey()) && Objects.equals(this.deadLetterQueueUrl(), other.deadLetterQueueUrl()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        return ToString.builder((String)"UpdateDomainRequest").add("DomainName", (Object)this.domainName()).add("DefaultExpirationDays", (Object)this.defaultExpirationDays()).add("DefaultEncryptionKey", (Object)this.defaultEncryptionKey()).add("DeadLetterQueueUrl", (Object)this.deadLetterQueueUrl()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.ofNullable(clazz.cast(this.domainName()));
            }
            case "DefaultExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.defaultExpirationDays()));
            }
            case "DefaultEncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.defaultEncryptionKey()));
            }
            case "DeadLetterQueueUrl": {
                return Optional.ofNullable(clazz.cast(this.deadLetterQueueUrl()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDomainRequest, T> g) {
        return obj -> g.apply((UpdateDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesRequest.BuilderImpl
    implements Builder {
        private String domainName;
        private Integer defaultExpirationDays;
        private String defaultEncryptionKey;
        private String deadLetterQueueUrl;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDomainRequest model) {
            super(model);
            this.domainName(model.domainName);
            this.defaultExpirationDays(model.defaultExpirationDays);
            this.defaultEncryptionKey(model.defaultEncryptionKey);
            this.deadLetterQueueUrl(model.deadLetterQueueUrl);
            this.tags(model.tags);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Integer getDefaultExpirationDays() {
            return this.defaultExpirationDays;
        }

        @Override
        public final Builder defaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
            return this;
        }

        public final void setDefaultExpirationDays(Integer defaultExpirationDays) {
            this.defaultExpirationDays = defaultExpirationDays;
        }

        public final String getDefaultEncryptionKey() {
            return this.defaultEncryptionKey;
        }

        @Override
        public final Builder defaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
            return this;
        }

        public final void setDefaultEncryptionKey(String defaultEncryptionKey) {
            this.defaultEncryptionKey = defaultEncryptionKey;
        }

        public final String getDeadLetterQueueUrl() {
            return this.deadLetterQueueUrl;
        }

        @Override
        public final Builder deadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
            return this;
        }

        public final void setDeadLetterQueueUrl(String deadLetterQueueUrl) {
            this.deadLetterQueueUrl = deadLetterQueueUrl;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDomainRequest build() {
            return new UpdateDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDomainRequest> {
        public Builder domainName(String var1);

        public Builder defaultExpirationDays(Integer var1);

        public Builder defaultEncryptionKey(String var1);

        public Builder deadLetterQueueUrl(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

