/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileObjectTypeResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetProfileObjectTypeResponse.Builder, GetProfileObjectTypeResponse> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(GetProfileObjectTypeResponse::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetProfileObjectTypeResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(GetProfileObjectTypeResponse::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpirationDays").getter(getter(GetProfileObjectTypeResponse::expirationDays))
            .setter(setter(Builder::expirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(GetProfileObjectTypeResponse::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowProfileCreation").getter(getter(GetProfileObjectTypeResponse::allowProfileCreation))
            .setter(setter(Builder::allowProfileCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build())
            .build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(GetProfileObjectTypeResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField
            .<Map<String, List<ObjectTypeKey>>> builder(MarshallingType.MAP)
            .memberName("Keys")
            .getter(getter(GetProfileObjectTypeResponse::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ObjectTypeKey>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ObjectTypeKey> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ObjectTypeKey::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(GetProfileObjectTypeResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetProfileObjectTypeResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(GetProfileObjectTypeResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD,
            DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, EXPIRATION_DAYS_FIELD, ENCRYPTION_KEY_FIELD, ALLOW_PROFILE_CREATION_FIELD,
            FIELDS_FIELD, KEYS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));

    private final String objectTypeName;

    private final String description;

    private final String templateId;

    private final Integer expirationDays;

    private final String encryptionKey;

    private final Boolean allowProfileCreation;

    private final Map<String, ObjectTypeField> fields;

    private final Map<String, List<ObjectTypeKey>> keys;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private GetProfileObjectTypeResponse(BuilderImpl builder) {
        super(builder);
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.expirationDays = builder.expirationDays;
        this.encryptionKey = builder.encryptionKey;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.fields = builder.fields;
        this.keys = builder.keys;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the profile object type.
     * </p>
     * 
     * @return The name of the profile object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The description of the profile object type.
     * </p>
     * 
     * @return The description of the profile object type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the object template.
     * </p>
     * 
     * @return A unique identifier for the object template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The number of days until the data in the object expires.
     * </p>
     * 
     * @return The number of days until the data in the object expires.
     */
    public final Integer expirationDays() {
        return expirationDays;
    }

    /**
     * <p>
     * The customer-provided key to encrypt the profile object that will be created in this profile object type.
     * </p>
     * 
     * @return The customer-provided key to encrypt the profile object that will be created in this profile object type.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this
     * type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the
     * service tries to fetch a standard profile and associate this object with the profile. If it is set to
     * <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
     * </p>
     * 
     * @return Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
     *         this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
     *         <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the
     *         profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new
     *         standard profile.
     */
    public final Boolean allowProfileCreation() {
        return allowProfileCreation;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the name and ObjectType field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A map of the name and ObjectType field.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * Returns true if the Keys property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of unique keys that can be used to map data to the profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unique keys that can be used to map data to the profile.
     */
    public final Map<String, List<ObjectTypeKey>> keys() {
        return keys;
    }

    /**
     * <p>
     * The timestamp of when the domain was created.
     * </p>
     * 
     * @return The timestamp of when the domain was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the domain was most recently edited.
     * </p>
     * 
     * @return The timestamp of when the domain was most recently edited.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileObjectTypeResponse)) {
            return false;
        }
        GetProfileObjectTypeResponse other = (GetProfileObjectTypeResponse) obj;
        return Objects.equals(objectTypeName(), other.objectTypeName()) && Objects.equals(description(), other.description())
                && Objects.equals(templateId(), other.templateId()) && Objects.equals(expirationDays(), other.expirationDays())
                && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(allowProfileCreation(), other.allowProfileCreation()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileObjectTypeResponse").add("ObjectTypeName", objectTypeName())
                .add("Description", description()).add("TemplateId", templateId()).add("ExpirationDays", expirationDays())
                .add("EncryptionKey", encryptionKey()).add("AllowProfileCreation", allowProfileCreation())
                .add("Fields", hasFields() ? fields() : null).add("Keys", hasKeys() ? keys() : null)
                .add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "ExpirationDays":
            return Optional.ofNullable(clazz.cast(expirationDays()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "AllowProfileCreation":
            return Optional.ofNullable(clazz.cast(allowProfileCreation()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileObjectTypeResponse, T> g) {
        return obj -> g.apply((GetProfileObjectTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileObjectTypeResponse> {
        /**
         * <p>
         * The name of the profile object type.
         * </p>
         * 
         * @param objectTypeName
         *        The name of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The description of the profile object type.
         * </p>
         * 
         * @param description
         *        The description of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the object template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The number of days until the data in the object expires.
         * </p>
         * 
         * @param expirationDays
         *        The number of days until the data in the object expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDays(Integer expirationDays);

        /**
         * <p>
         * The customer-provided key to encrypt the profile object that will be created in this profile object type.
         * </p>
         * 
         * @param encryptionKey
         *        The customer-provided key to encrypt the profile object that will be created in this profile object
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
         * this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>,
         * then the service tries to fetch a standard profile and associate this object with the profile. If it is set
         * to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
         * </p>
         * 
         * @param allowProfileCreation
         *        Indicates whether a profile should be created when data is received if one doesn’t exist for an object
         *        of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
         *        <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with
         *        the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a
         *        new standard profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowProfileCreation(Boolean allowProfileCreation);

        /**
         * <p>
         * A map of the name and ObjectType field.
         * </p>
         * 
         * @param fields
         *        A map of the name and ObjectType field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * A list of unique keys that can be used to map data to the profile.
         * </p>
         * 
         * @param keys
         *        A list of unique keys that can be used to map data to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys);

        /**
         * <p>
         * The timestamp of when the domain was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the domain was most recently edited.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the domain was most recently edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String objectTypeName;

        private String description;

        private String templateId;

        private Integer expirationDays;

        private String encryptionKey;

        private Boolean allowProfileCreation;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileObjectTypeResponse model) {
            super(model);
            objectTypeName(model.objectTypeName);
            description(model.description);
            templateId(model.templateId);
            expirationDays(model.expirationDays);
            encryptionKey(model.encryptionKey);
            allowProfileCreation(model.allowProfileCreation);
            fields(model.fields);
            keys(model.keys);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getTemplateId() {
            return templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        public final Integer getExpirationDays() {
            return expirationDays;
        }

        @Override
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public final Boolean getAllowProfileCreation() {
            return allowProfileCreation;
        }

        @Override
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            if (fields instanceof SdkAutoConstructMap) {
                return null;
            }
            return fields != null ? CollectionUtils.mapValues(fields, ObjectTypeField::toBuilder) : null;
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        public final Map<String, ? extends Collection<ObjectTypeKey>> getKeys() {
            if (keys instanceof SdkAutoConstructMap) {
                return null;
            }
            return keys;
        }

        @Override
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public GetProfileObjectTypeResponse build() {
            return new GetProfileObjectTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
