/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateProfileRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<UpdateProfileRequest.Builder, UpdateProfileRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(UpdateProfileRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(UpdateProfileRequest::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> ADDITIONAL_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInformation").getter(getter(UpdateProfileRequest::additionalInformation))
            .setter(setter(Builder::additionalInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInformation").build())
            .build();

    private static final SdkField<String> ACCOUNT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountNumber").getter(getter(UpdateProfileRequest::accountNumber))
            .setter(setter(Builder::accountNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountNumber").build()).build();

    private static final SdkField<String> PARTY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PartyType").getter(getter(UpdateProfileRequest::partyTypeAsString)).setter(setter(Builder::partyType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartyType").build()).build();

    private static final SdkField<String> BUSINESS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessName").getter(getter(UpdateProfileRequest::businessName)).setter(setter(Builder::businessName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessName").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(UpdateProfileRequest::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> MIDDLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MiddleName").getter(getter(UpdateProfileRequest::middleName)).setter(setter(Builder::middleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MiddleName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(UpdateProfileRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> BIRTH_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BirthDate").getter(getter(UpdateProfileRequest::birthDate)).setter(setter(Builder::birthDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BirthDate").build()).build();

    private static final SdkField<String> GENDER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Gender")
            .getter(getter(UpdateProfileRequest::genderAsString)).setter(setter(Builder::gender))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gender").build()).build();

    private static final SdkField<String> PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PhoneNumber").getter(getter(UpdateProfileRequest::phoneNumber)).setter(setter(Builder::phoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PhoneNumber").build()).build();

    private static final SdkField<String> MOBILE_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MobilePhoneNumber").getter(getter(UpdateProfileRequest::mobilePhoneNumber))
            .setter(setter(Builder::mobilePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MobilePhoneNumber").build()).build();

    private static final SdkField<String> HOME_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HomePhoneNumber").getter(getter(UpdateProfileRequest::homePhoneNumber))
            .setter(setter(Builder::homePhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomePhoneNumber").build()).build();

    private static final SdkField<String> BUSINESS_PHONE_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessPhoneNumber").getter(getter(UpdateProfileRequest::businessPhoneNumber))
            .setter(setter(Builder::businessPhoneNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessPhoneNumber").build())
            .build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(UpdateProfileRequest::emailAddress)).setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> PERSONAL_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PersonalEmailAddress").getter(getter(UpdateProfileRequest::personalEmailAddress))
            .setter(setter(Builder::personalEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PersonalEmailAddress").build())
            .build();

    private static final SdkField<String> BUSINESS_EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessEmailAddress").getter(getter(UpdateProfileRequest::businessEmailAddress))
            .setter(setter(Builder::businessEmailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessEmailAddress").build())
            .build();

    private static final SdkField<UpdateAddress> ADDRESS_FIELD = SdkField.<UpdateAddress> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(UpdateProfileRequest::address)).setter(setter(Builder::address))
            .constructor(UpdateAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final SdkField<UpdateAddress> SHIPPING_ADDRESS_FIELD = SdkField
            .<UpdateAddress> builder(MarshallingType.SDK_POJO).memberName("ShippingAddress")
            .getter(getter(UpdateProfileRequest::shippingAddress)).setter(setter(Builder::shippingAddress))
            .constructor(UpdateAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShippingAddress").build()).build();

    private static final SdkField<UpdateAddress> MAILING_ADDRESS_FIELD = SdkField
            .<UpdateAddress> builder(MarshallingType.SDK_POJO).memberName("MailingAddress")
            .getter(getter(UpdateProfileRequest::mailingAddress)).setter(setter(Builder::mailingAddress))
            .constructor(UpdateAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailingAddress").build()).build();

    private static final SdkField<UpdateAddress> BILLING_ADDRESS_FIELD = SdkField
            .<UpdateAddress> builder(MarshallingType.SDK_POJO).memberName("BillingAddress")
            .getter(getter(UpdateProfileRequest::billingAddress)).setter(setter(Builder::billingAddress))
            .constructor(UpdateAddress::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingAddress").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(UpdateProfileRequest::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            PROFILE_ID_FIELD, ADDITIONAL_INFORMATION_FIELD, ACCOUNT_NUMBER_FIELD, PARTY_TYPE_FIELD, BUSINESS_NAME_FIELD,
            FIRST_NAME_FIELD, MIDDLE_NAME_FIELD, LAST_NAME_FIELD, BIRTH_DATE_FIELD, GENDER_FIELD, PHONE_NUMBER_FIELD,
            MOBILE_PHONE_NUMBER_FIELD, HOME_PHONE_NUMBER_FIELD, BUSINESS_PHONE_NUMBER_FIELD, EMAIL_ADDRESS_FIELD,
            PERSONAL_EMAIL_ADDRESS_FIELD, BUSINESS_EMAIL_ADDRESS_FIELD, ADDRESS_FIELD, SHIPPING_ADDRESS_FIELD,
            MAILING_ADDRESS_FIELD, BILLING_ADDRESS_FIELD, ATTRIBUTES_FIELD));

    private final String domainName;

    private final String profileId;

    private final String additionalInformation;

    private final String accountNumber;

    private final String partyType;

    private final String businessName;

    private final String firstName;

    private final String middleName;

    private final String lastName;

    private final String birthDate;

    private final String gender;

    private final String phoneNumber;

    private final String mobilePhoneNumber;

    private final String homePhoneNumber;

    private final String businessPhoneNumber;

    private final String emailAddress;

    private final String personalEmailAddress;

    private final String businessEmailAddress;

    private final UpdateAddress address;

    private final UpdateAddress shippingAddress;

    private final UpdateAddress mailingAddress;

    private final UpdateAddress billingAddress;

    private final Map<String, String> attributes;

    private UpdateProfileRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.profileId = builder.profileId;
        this.additionalInformation = builder.additionalInformation;
        this.accountNumber = builder.accountNumber;
        this.partyType = builder.partyType;
        this.businessName = builder.businessName;
        this.firstName = builder.firstName;
        this.middleName = builder.middleName;
        this.lastName = builder.lastName;
        this.birthDate = builder.birthDate;
        this.gender = builder.gender;
        this.phoneNumber = builder.phoneNumber;
        this.mobilePhoneNumber = builder.mobilePhoneNumber;
        this.homePhoneNumber = builder.homePhoneNumber;
        this.businessPhoneNumber = builder.businessPhoneNumber;
        this.emailAddress = builder.emailAddress;
        this.personalEmailAddress = builder.personalEmailAddress;
        this.businessEmailAddress = builder.businessEmailAddress;
        this.address = builder.address;
        this.shippingAddress = builder.shippingAddress;
        this.mailingAddress = builder.mailingAddress;
        this.billingAddress = builder.billingAddress;
        this.attributes = builder.attributes;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique identifier of a customer profile.
     * </p>
     * 
     * @return The unique identifier of a customer profile.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * Any additional information relevant to the customer’s profile.
     * </p>
     * 
     * @return Any additional information relevant to the customer’s profile.
     */
    public final String additionalInformation() {
        return additionalInformation;
    }

    /**
     * <p>
     * A unique account number that you have given to the customer.
     * </p>
     * 
     * @return A unique account number that you have given to the customer.
     */
    public final String accountNumber() {
        return accountNumber;
    }

    /**
     * <p>
     * The type of profile used to describe the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partyType} will
     * return {@link PartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partyTypeAsString}.
     * </p>
     * 
     * @return The type of profile used to describe the customer.
     * @see PartyType
     */
    public final PartyType partyType() {
        return PartyType.fromValue(partyType);
    }

    /**
     * <p>
     * The type of profile used to describe the customer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partyType} will
     * return {@link PartyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partyTypeAsString}.
     * </p>
     * 
     * @return The type of profile used to describe the customer.
     * @see PartyType
     */
    public final String partyTypeAsString() {
        return partyType;
    }

    /**
     * <p>
     * The name of the customer’s business.
     * </p>
     * 
     * @return The name of the customer’s business.
     */
    public final String businessName() {
        return businessName;
    }

    /**
     * <p>
     * The customer’s first name.
     * </p>
     * 
     * @return The customer’s first name.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The customer’s middle name.
     * </p>
     * 
     * @return The customer’s middle name.
     */
    public final String middleName() {
        return middleName;
    }

    /**
     * <p>
     * The customer’s last name.
     * </p>
     * 
     * @return The customer’s last name.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The customer’s birth date.
     * </p>
     * 
     * @return The customer’s birth date.
     */
    public final String birthDate() {
        return birthDate;
    }

    /**
     * <p>
     * The gender with which the customer identifies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return The gender with which the customer identifies.
     * @see Gender
     */
    public final Gender gender() {
        return Gender.fromValue(gender);
    }

    /**
     * <p>
     * The gender with which the customer identifies.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #gender} will
     * return {@link Gender#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #genderAsString}.
     * </p>
     * 
     * @return The gender with which the customer identifies.
     * @see Gender
     */
    public final String genderAsString() {
        return gender;
    }

    /**
     * <p>
     * The customer’s phone number, which has not been specified as a mobile, home, or business number.
     * </p>
     * 
     * @return The customer’s phone number, which has not been specified as a mobile, home, or business number.
     */
    public final String phoneNumber() {
        return phoneNumber;
    }

    /**
     * <p>
     * The customer’s mobile phone number.
     * </p>
     * 
     * @return The customer’s mobile phone number.
     */
    public final String mobilePhoneNumber() {
        return mobilePhoneNumber;
    }

    /**
     * <p>
     * The customer’s home phone number.
     * </p>
     * 
     * @return The customer’s home phone number.
     */
    public final String homePhoneNumber() {
        return homePhoneNumber;
    }

    /**
     * <p>
     * The customer’s business phone number.
     * </p>
     * 
     * @return The customer’s business phone number.
     */
    public final String businessPhoneNumber() {
        return businessPhoneNumber;
    }

    /**
     * <p>
     * The customer’s email address, which has not been specified as a personal or business address.
     * </p>
     * 
     * @return The customer’s email address, which has not been specified as a personal or business address.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * The customer’s personal email address.
     * </p>
     * 
     * @return The customer’s personal email address.
     */
    public final String personalEmailAddress() {
        return personalEmailAddress;
    }

    /**
     * <p>
     * The customer’s business email address.
     * </p>
     * 
     * @return The customer’s business email address.
     */
    public final String businessEmailAddress() {
        return businessEmailAddress;
    }

    /**
     * <p>
     * A generic address associated with the customer that is not mailing, shipping, or billing.
     * </p>
     * 
     * @return A generic address associated with the customer that is not mailing, shipping, or billing.
     */
    public final UpdateAddress address() {
        return address;
    }

    /**
     * <p>
     * The customer’s shipping address.
     * </p>
     * 
     * @return The customer’s shipping address.
     */
    public final UpdateAddress shippingAddress() {
        return shippingAddress;
    }

    /**
     * <p>
     * The customer’s mailing address.
     * </p>
     * 
     * @return The customer’s mailing address.
     */
    public final UpdateAddress mailingAddress() {
        return mailingAddress;
    }

    /**
     * <p>
     * The customer’s billing address.
     * </p>
     * 
     * @return The customer’s billing address.
     */
    public final UpdateAddress billingAddress() {
        return billingAddress;
    }

    /**
     * Returns true if the Attributes property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key value pair of attributes of a customer profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key value pair of attributes of a customer profile.
     */
    public final Map<String, String> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInformation());
        hashCode = 31 * hashCode + Objects.hashCode(accountNumber());
        hashCode = 31 * hashCode + Objects.hashCode(partyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(businessName());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(middleName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(birthDate());
        hashCode = 31 * hashCode + Objects.hashCode(genderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(phoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(mobilePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(homePhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(businessPhoneNumber());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(personalEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(businessEmailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(shippingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(mailingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(billingAddress());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProfileRequest)) {
            return false;
        }
        UpdateProfileRequest other = (UpdateProfileRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(profileId(), other.profileId())
                && Objects.equals(additionalInformation(), other.additionalInformation())
                && Objects.equals(accountNumber(), other.accountNumber())
                && Objects.equals(partyTypeAsString(), other.partyTypeAsString())
                && Objects.equals(businessName(), other.businessName()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(middleName(), other.middleName()) && Objects.equals(lastName(), other.lastName())
                && Objects.equals(birthDate(), other.birthDate()) && Objects.equals(genderAsString(), other.genderAsString())
                && Objects.equals(phoneNumber(), other.phoneNumber())
                && Objects.equals(mobilePhoneNumber(), other.mobilePhoneNumber())
                && Objects.equals(homePhoneNumber(), other.homePhoneNumber())
                && Objects.equals(businessPhoneNumber(), other.businessPhoneNumber())
                && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(personalEmailAddress(), other.personalEmailAddress())
                && Objects.equals(businessEmailAddress(), other.businessEmailAddress())
                && Objects.equals(address(), other.address()) && Objects.equals(shippingAddress(), other.shippingAddress())
                && Objects.equals(mailingAddress(), other.mailingAddress())
                && Objects.equals(billingAddress(), other.billingAddress()) && hasAttributes() == other.hasAttributes()
                && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateProfileRequest").add("DomainName", domainName()).add("ProfileId", profileId())
                .add("AdditionalInformation", additionalInformation()).add("AccountNumber", accountNumber())
                .add("PartyType", partyTypeAsString()).add("BusinessName", businessName()).add("FirstName", firstName())
                .add("MiddleName", middleName()).add("LastName", lastName()).add("BirthDate", birthDate())
                .add("Gender", genderAsString()).add("PhoneNumber", phoneNumber()).add("MobilePhoneNumber", mobilePhoneNumber())
                .add("HomePhoneNumber", homePhoneNumber()).add("BusinessPhoneNumber", businessPhoneNumber())
                .add("EmailAddress", emailAddress()).add("PersonalEmailAddress", personalEmailAddress())
                .add("BusinessEmailAddress", businessEmailAddress()).add("Address", address())
                .add("ShippingAddress", shippingAddress()).add("MailingAddress", mailingAddress())
                .add("BillingAddress", billingAddress()).add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "AdditionalInformation":
            return Optional.ofNullable(clazz.cast(additionalInformation()));
        case "AccountNumber":
            return Optional.ofNullable(clazz.cast(accountNumber()));
        case "PartyType":
            return Optional.ofNullable(clazz.cast(partyTypeAsString()));
        case "BusinessName":
            return Optional.ofNullable(clazz.cast(businessName()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "MiddleName":
            return Optional.ofNullable(clazz.cast(middleName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "BirthDate":
            return Optional.ofNullable(clazz.cast(birthDate()));
        case "Gender":
            return Optional.ofNullable(clazz.cast(genderAsString()));
        case "PhoneNumber":
            return Optional.ofNullable(clazz.cast(phoneNumber()));
        case "MobilePhoneNumber":
            return Optional.ofNullable(clazz.cast(mobilePhoneNumber()));
        case "HomePhoneNumber":
            return Optional.ofNullable(clazz.cast(homePhoneNumber()));
        case "BusinessPhoneNumber":
            return Optional.ofNullable(clazz.cast(businessPhoneNumber()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "PersonalEmailAddress":
            return Optional.ofNullable(clazz.cast(personalEmailAddress()));
        case "BusinessEmailAddress":
            return Optional.ofNullable(clazz.cast(businessEmailAddress()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        case "ShippingAddress":
            return Optional.ofNullable(clazz.cast(shippingAddress()));
        case "MailingAddress":
            return Optional.ofNullable(clazz.cast(mailingAddress()));
        case "BillingAddress":
            return Optional.ofNullable(clazz.cast(billingAddress()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateProfileRequest, T> g) {
        return obj -> g.apply((UpdateProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateProfileRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique identifier of a customer profile.
         * </p>
         * 
         * @param profileId
         *        The unique identifier of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * Any additional information relevant to the customer’s profile.
         * </p>
         * 
         * @param additionalInformation
         *        Any additional information relevant to the customer’s profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInformation(String additionalInformation);

        /**
         * <p>
         * A unique account number that you have given to the customer.
         * </p>
         * 
         * @param accountNumber
         *        A unique account number that you have given to the customer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountNumber(String accountNumber);

        /**
         * <p>
         * The type of profile used to describe the customer.
         * </p>
         * 
         * @param partyType
         *        The type of profile used to describe the customer.
         * @see PartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartyType
         */
        Builder partyType(String partyType);

        /**
         * <p>
         * The type of profile used to describe the customer.
         * </p>
         * 
         * @param partyType
         *        The type of profile used to describe the customer.
         * @see PartyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartyType
         */
        Builder partyType(PartyType partyType);

        /**
         * <p>
         * The name of the customer’s business.
         * </p>
         * 
         * @param businessName
         *        The name of the customer’s business.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessName(String businessName);

        /**
         * <p>
         * The customer’s first name.
         * </p>
         * 
         * @param firstName
         *        The customer’s first name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The customer’s middle name.
         * </p>
         * 
         * @param middleName
         *        The customer’s middle name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder middleName(String middleName);

        /**
         * <p>
         * The customer’s last name.
         * </p>
         * 
         * @param lastName
         *        The customer’s last name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The customer’s birth date.
         * </p>
         * 
         * @param birthDate
         *        The customer’s birth date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder birthDate(String birthDate);

        /**
         * <p>
         * The gender with which the customer identifies.
         * </p>
         * 
         * @param gender
         *        The gender with which the customer identifies.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(String gender);

        /**
         * <p>
         * The gender with which the customer identifies.
         * </p>
         * 
         * @param gender
         *        The gender with which the customer identifies.
         * @see Gender
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Gender
         */
        Builder gender(Gender gender);

        /**
         * <p>
         * The customer’s phone number, which has not been specified as a mobile, home, or business number.
         * </p>
         * 
         * @param phoneNumber
         *        The customer’s phone number, which has not been specified as a mobile, home, or business number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phoneNumber(String phoneNumber);

        /**
         * <p>
         * The customer’s mobile phone number.
         * </p>
         * 
         * @param mobilePhoneNumber
         *        The customer’s mobile phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mobilePhoneNumber(String mobilePhoneNumber);

        /**
         * <p>
         * The customer’s home phone number.
         * </p>
         * 
         * @param homePhoneNumber
         *        The customer’s home phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder homePhoneNumber(String homePhoneNumber);

        /**
         * <p>
         * The customer’s business phone number.
         * </p>
         * 
         * @param businessPhoneNumber
         *        The customer’s business phone number.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessPhoneNumber(String businessPhoneNumber);

        /**
         * <p>
         * The customer’s email address, which has not been specified as a personal or business address.
         * </p>
         * 
         * @param emailAddress
         *        The customer’s email address, which has not been specified as a personal or business address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * The customer’s personal email address.
         * </p>
         * 
         * @param personalEmailAddress
         *        The customer’s personal email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder personalEmailAddress(String personalEmailAddress);

        /**
         * <p>
         * The customer’s business email address.
         * </p>
         * 
         * @param businessEmailAddress
         *        The customer’s business email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessEmailAddress(String businessEmailAddress);

        /**
         * <p>
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         * </p>
         * 
         * @param address
         *        A generic address associated with the customer that is not mailing, shipping, or billing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(UpdateAddress address);

        /**
         * <p>
         * A generic address associated with the customer that is not mailing, shipping, or billing.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateAddress.Builder} avoiding the need to
         * create one manually via {@link UpdateAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #address(UpdateAddress)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link UpdateAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(UpdateAddress)
         */
        default Builder address(Consumer<UpdateAddress.Builder> address) {
            return address(UpdateAddress.builder().applyMutation(address).build());
        }

        /**
         * <p>
         * The customer’s shipping address.
         * </p>
         * 
         * @param shippingAddress
         *        The customer’s shipping address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shippingAddress(UpdateAddress shippingAddress);

        /**
         * <p>
         * The customer’s shipping address.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateAddress.Builder} avoiding the need to
         * create one manually via {@link UpdateAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #shippingAddress(UpdateAddress)}.
         * 
         * @param shippingAddress
         *        a consumer that will call methods on {@link UpdateAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #shippingAddress(UpdateAddress)
         */
        default Builder shippingAddress(Consumer<UpdateAddress.Builder> shippingAddress) {
            return shippingAddress(UpdateAddress.builder().applyMutation(shippingAddress).build());
        }

        /**
         * <p>
         * The customer’s mailing address.
         * </p>
         * 
         * @param mailingAddress
         *        The customer’s mailing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mailingAddress(UpdateAddress mailingAddress);

        /**
         * <p>
         * The customer’s mailing address.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateAddress.Builder} avoiding the need to
         * create one manually via {@link UpdateAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #mailingAddress(UpdateAddress)}.
         * 
         * @param mailingAddress
         *        a consumer that will call methods on {@link UpdateAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mailingAddress(UpdateAddress)
         */
        default Builder mailingAddress(Consumer<UpdateAddress.Builder> mailingAddress) {
            return mailingAddress(UpdateAddress.builder().applyMutation(mailingAddress).build());
        }

        /**
         * <p>
         * The customer’s billing address.
         * </p>
         * 
         * @param billingAddress
         *        The customer’s billing address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingAddress(UpdateAddress billingAddress);

        /**
         * <p>
         * The customer’s billing address.
         * </p>
         * This is a convenience that creates an instance of the {@link UpdateAddress.Builder} avoiding the need to
         * create one manually via {@link UpdateAddress#builder()}.
         *
         * When the {@link Consumer} completes, {@link UpdateAddress.Builder#build()} is called immediately and its
         * result is passed to {@link #billingAddress(UpdateAddress)}.
         * 
         * @param billingAddress
         *        a consumer that will call methods on {@link UpdateAddress.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #billingAddress(UpdateAddress)
         */
        default Builder billingAddress(Consumer<UpdateAddress.Builder> billingAddress) {
            return billingAddress(UpdateAddress.builder().applyMutation(billingAddress).build());
        }

        /**
         * <p>
         * A key value pair of attributes of a customer profile.
         * </p>
         * 
         * @param attributes
         *        A key value pair of attributes of a customer profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String profileId;

        private String additionalInformation;

        private String accountNumber;

        private String partyType;

        private String businessName;

        private String firstName;

        private String middleName;

        private String lastName;

        private String birthDate;

        private String gender;

        private String phoneNumber;

        private String mobilePhoneNumber;

        private String homePhoneNumber;

        private String businessPhoneNumber;

        private String emailAddress;

        private String personalEmailAddress;

        private String businessEmailAddress;

        private UpdateAddress address;

        private UpdateAddress shippingAddress;

        private UpdateAddress mailingAddress;

        private UpdateAddress billingAddress;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProfileRequest model) {
            super(model);
            domainName(model.domainName);
            profileId(model.profileId);
            additionalInformation(model.additionalInformation);
            accountNumber(model.accountNumber);
            partyType(model.partyType);
            businessName(model.businessName);
            firstName(model.firstName);
            middleName(model.middleName);
            lastName(model.lastName);
            birthDate(model.birthDate);
            gender(model.gender);
            phoneNumber(model.phoneNumber);
            mobilePhoneNumber(model.mobilePhoneNumber);
            homePhoneNumber(model.homePhoneNumber);
            businessPhoneNumber(model.businessPhoneNumber);
            emailAddress(model.emailAddress);
            personalEmailAddress(model.personalEmailAddress);
            businessEmailAddress(model.businessEmailAddress);
            address(model.address);
            shippingAddress(model.shippingAddress);
            mailingAddress(model.mailingAddress);
            billingAddress(model.billingAddress);
            attributes(model.attributes);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getProfileId() {
            return profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        public final String getAdditionalInformation() {
            return additionalInformation;
        }

        @Override
        public final Builder additionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
            return this;
        }

        public final void setAdditionalInformation(String additionalInformation) {
            this.additionalInformation = additionalInformation;
        }

        public final String getAccountNumber() {
            return accountNumber;
        }

        @Override
        public final Builder accountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public final void setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
        }

        public final String getPartyType() {
            return partyType;
        }

        @Override
        public final Builder partyType(String partyType) {
            this.partyType = partyType;
            return this;
        }

        @Override
        public final Builder partyType(PartyType partyType) {
            this.partyType(partyType == null ? null : partyType.toString());
            return this;
        }

        public final void setPartyType(String partyType) {
            this.partyType = partyType;
        }

        public final String getBusinessName() {
            return businessName;
        }

        @Override
        public final Builder businessName(String businessName) {
            this.businessName = businessName;
            return this;
        }

        public final void setBusinessName(String businessName) {
            this.businessName = businessName;
        }

        public final String getFirstName() {
            return firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public final String getMiddleName() {
            return middleName;
        }

        @Override
        public final Builder middleName(String middleName) {
            this.middleName = middleName;
            return this;
        }

        public final void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        public final String getLastName() {
            return lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        public final String getBirthDate() {
            return birthDate;
        }

        @Override
        public final Builder birthDate(String birthDate) {
            this.birthDate = birthDate;
            return this;
        }

        public final void setBirthDate(String birthDate) {
            this.birthDate = birthDate;
        }

        public final String getGender() {
            return gender;
        }

        @Override
        public final Builder gender(String gender) {
            this.gender = gender;
            return this;
        }

        @Override
        public final Builder gender(Gender gender) {
            this.gender(gender == null ? null : gender.toString());
            return this;
        }

        public final void setGender(String gender) {
            this.gender = gender;
        }

        public final String getPhoneNumber() {
            return phoneNumber;
        }

        @Override
        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public final void setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        public final String getMobilePhoneNumber() {
            return mobilePhoneNumber;
        }

        @Override
        public final Builder mobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
            return this;
        }

        public final void setMobilePhoneNumber(String mobilePhoneNumber) {
            this.mobilePhoneNumber = mobilePhoneNumber;
        }

        public final String getHomePhoneNumber() {
            return homePhoneNumber;
        }

        @Override
        public final Builder homePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
            return this;
        }

        public final void setHomePhoneNumber(String homePhoneNumber) {
            this.homePhoneNumber = homePhoneNumber;
        }

        public final String getBusinessPhoneNumber() {
            return businessPhoneNumber;
        }

        @Override
        public final Builder businessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
            return this;
        }

        public final void setBusinessPhoneNumber(String businessPhoneNumber) {
            this.businessPhoneNumber = businessPhoneNumber;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        public final String getPersonalEmailAddress() {
            return personalEmailAddress;
        }

        @Override
        public final Builder personalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
            return this;
        }

        public final void setPersonalEmailAddress(String personalEmailAddress) {
            this.personalEmailAddress = personalEmailAddress;
        }

        public final String getBusinessEmailAddress() {
            return businessEmailAddress;
        }

        @Override
        public final Builder businessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
            return this;
        }

        public final void setBusinessEmailAddress(String businessEmailAddress) {
            this.businessEmailAddress = businessEmailAddress;
        }

        public final UpdateAddress.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        @Override
        public final Builder address(UpdateAddress address) {
            this.address = address;
            return this;
        }

        public final void setAddress(UpdateAddress.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        public final UpdateAddress.Builder getShippingAddress() {
            return shippingAddress != null ? shippingAddress.toBuilder() : null;
        }

        @Override
        public final Builder shippingAddress(UpdateAddress shippingAddress) {
            this.shippingAddress = shippingAddress;
            return this;
        }

        public final void setShippingAddress(UpdateAddress.BuilderImpl shippingAddress) {
            this.shippingAddress = shippingAddress != null ? shippingAddress.build() : null;
        }

        public final UpdateAddress.Builder getMailingAddress() {
            return mailingAddress != null ? mailingAddress.toBuilder() : null;
        }

        @Override
        public final Builder mailingAddress(UpdateAddress mailingAddress) {
            this.mailingAddress = mailingAddress;
            return this;
        }

        public final void setMailingAddress(UpdateAddress.BuilderImpl mailingAddress) {
            this.mailingAddress = mailingAddress != null ? mailingAddress.build() : null;
        }

        public final UpdateAddress.Builder getBillingAddress() {
            return billingAddress != null ? billingAddress.toBuilder() : null;
        }

        @Override
        public final Builder billingAddress(UpdateAddress billingAddress) {
            this.billingAddress = billingAddress;
            return this;
        }

        public final void setBillingAddress(UpdateAddress.BuilderImpl billingAddress) {
            this.billingAddress = billingAddress != null ? billingAddress.build() : null;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = UpdateAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = UpdateAttributesCopier.copy(attributes);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProfileRequest build() {
            return new UpdateProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
