/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Match group object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchItem implements SdkPojo, Serializable, ToCopyableBuilder<MatchItem.Builder, MatchItem> {
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchId").getter(getter(MatchItem::matchId)).setter(setter(Builder::matchId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchId").build()).build();

    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ProfileIds")
            .getter(getter(MatchItem::profileIds))
            .setter(setter(Builder::profileIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ID_FIELD,
            PROFILE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String matchId;

    private final List<String> profileIds;

    private MatchItem(BuilderImpl builder) {
        this.matchId = builder.matchId;
        this.profileIds = builder.profileIds;
    }

    /**
     * <p>
     * The unique identifiers for this group of profiles that match.
     * </p>
     * 
     * @return The unique identifiers for this group of profiles that match.
     */
    public final String matchId() {
        return matchId;
    }

    /**
     * Returns true if the ProfileIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasProfileIds() {
        return profileIds != null && !(profileIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for profiles that match.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProfileIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of identifiers for profiles that match.
     */
    public final List<String> profileIds() {
        return profileIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(matchId());
        hashCode = 31 * hashCode + Objects.hashCode(hasProfileIds() ? profileIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchItem)) {
            return false;
        }
        MatchItem other = (MatchItem) obj;
        return Objects.equals(matchId(), other.matchId()) && hasProfileIds() == other.hasProfileIds()
                && Objects.equals(profileIds(), other.profileIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchItem").add("MatchId", matchId()).add("ProfileIds", hasProfileIds() ? profileIds() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MatchId":
            return Optional.ofNullable(clazz.cast(matchId()));
        case "ProfileIds":
            return Optional.ofNullable(clazz.cast(profileIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchItem, T> g) {
        return obj -> g.apply((MatchItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchItem> {
        /**
         * <p>
         * The unique identifiers for this group of profiles that match.
         * </p>
         * 
         * @param matchId
         *        The unique identifiers for this group of profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchId(String matchId);

        /**
         * <p>
         * A list of identifiers for profiles that match.
         * </p>
         * 
         * @param profileIds
         *        A list of identifiers for profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(Collection<String> profileIds);

        /**
         * <p>
         * A list of identifiers for profiles that match.
         * </p>
         * 
         * @param profileIds
         *        A list of identifiers for profiles that match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileIds(String... profileIds);
    }

    static final class BuilderImpl implements Builder {
        private String matchId;

        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatchItem model) {
            matchId(model.matchId);
            profileIds(model.profileIds);
        }

        public final String getMatchId() {
            return matchId;
        }

        @Override
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        public final Collection<String> getProfileIds() {
            if (profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return profileIds;
        }

        @Override
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder profileIds(String... profileIds) {
            profileIds(Arrays.asList(profileIds));
            return this;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
        }

        @Override
        public MatchItem build() {
            return new MatchItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
