/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the information that is required to query a particular Amazon AppFlow connector. Customer Profiles supports
 * Salesforce, Zendesk, Marketo, ServiceNow and Amazon S3.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceConnectorProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceConnectorProperties.Builder, SourceConnectorProperties> {
    private static final SdkField<MarketoSourceProperties> MARKETO_FIELD = SdkField
            .<MarketoSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Marketo")
            .getter(getter(SourceConnectorProperties::marketo)).setter(setter(Builder::marketo))
            .constructor(MarketoSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marketo").build()).build();

    private static final SdkField<S3SourceProperties> S3_FIELD = SdkField.<S3SourceProperties> builder(MarshallingType.SDK_POJO)
            .memberName("S3").getter(getter(SourceConnectorProperties::s3)).setter(setter(Builder::s3))
            .constructor(S3SourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3").build()).build();

    private static final SdkField<SalesforceSourceProperties> SALESFORCE_FIELD = SdkField
            .<SalesforceSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Salesforce")
            .getter(getter(SourceConnectorProperties::salesforce)).setter(setter(Builder::salesforce))
            .constructor(SalesforceSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Salesforce").build()).build();

    private static final SdkField<ServiceNowSourceProperties> SERVICE_NOW_FIELD = SdkField
            .<ServiceNowSourceProperties> builder(MarshallingType.SDK_POJO).memberName("ServiceNow")
            .getter(getter(SourceConnectorProperties::serviceNow)).setter(setter(Builder::serviceNow))
            .constructor(ServiceNowSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNow").build()).build();

    private static final SdkField<ZendeskSourceProperties> ZENDESK_FIELD = SdkField
            .<ZendeskSourceProperties> builder(MarshallingType.SDK_POJO).memberName("Zendesk")
            .getter(getter(SourceConnectorProperties::zendesk)).setter(setter(Builder::zendesk))
            .constructor(ZendeskSourceProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Zendesk").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKETO_FIELD, S3_FIELD,
            SALESFORCE_FIELD, SERVICE_NOW_FIELD, ZENDESK_FIELD));

    private static final long serialVersionUID = 1L;

    private final MarketoSourceProperties marketo;

    private final S3SourceProperties s3;

    private final SalesforceSourceProperties salesforce;

    private final ServiceNowSourceProperties serviceNow;

    private final ZendeskSourceProperties zendesk;

    private SourceConnectorProperties(BuilderImpl builder) {
        this.marketo = builder.marketo;
        this.s3 = builder.s3;
        this.salesforce = builder.salesforce;
        this.serviceNow = builder.serviceNow;
        this.zendesk = builder.zendesk;
    }

    /**
     * <p>
     * The properties that are applied when Marketo is being used as a source.
     * </p>
     * 
     * @return The properties that are applied when Marketo is being used as a source.
     */
    public final MarketoSourceProperties marketo() {
        return marketo;
    }

    /**
     * <p>
     * The properties that are applied when Amazon S3 is being used as the flow source.
     * </p>
     * 
     * @return The properties that are applied when Amazon S3 is being used as the flow source.
     */
    public final S3SourceProperties s3() {
        return s3;
    }

    /**
     * <p>
     * The properties that are applied when Salesforce is being used as a source.
     * </p>
     * 
     * @return The properties that are applied when Salesforce is being used as a source.
     */
    public final SalesforceSourceProperties salesforce() {
        return salesforce;
    }

    /**
     * <p>
     * The properties that are applied when ServiceNow is being used as a source.
     * </p>
     * 
     * @return The properties that are applied when ServiceNow is being used as a source.
     */
    public final ServiceNowSourceProperties serviceNow() {
        return serviceNow;
    }

    /**
     * <p>
     * The properties that are applied when using Zendesk as a flow source.
     * </p>
     * 
     * @return The properties that are applied when using Zendesk as a flow source.
     */
    public final ZendeskSourceProperties zendesk() {
        return zendesk;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(marketo());
        hashCode = 31 * hashCode + Objects.hashCode(s3());
        hashCode = 31 * hashCode + Objects.hashCode(salesforce());
        hashCode = 31 * hashCode + Objects.hashCode(serviceNow());
        hashCode = 31 * hashCode + Objects.hashCode(zendesk());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConnectorProperties)) {
            return false;
        }
        SourceConnectorProperties other = (SourceConnectorProperties) obj;
        return Objects.equals(marketo(), other.marketo()) && Objects.equals(s3(), other.s3())
                && Objects.equals(salesforce(), other.salesforce()) && Objects.equals(serviceNow(), other.serviceNow())
                && Objects.equals(zendesk(), other.zendesk());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceConnectorProperties").add("Marketo", marketo()).add("S3", s3())
                .add("Salesforce", salesforce()).add("ServiceNow", serviceNow()).add("Zendesk", zendesk()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marketo":
            return Optional.ofNullable(clazz.cast(marketo()));
        case "S3":
            return Optional.ofNullable(clazz.cast(s3()));
        case "Salesforce":
            return Optional.ofNullable(clazz.cast(salesforce()));
        case "ServiceNow":
            return Optional.ofNullable(clazz.cast(serviceNow()));
        case "Zendesk":
            return Optional.ofNullable(clazz.cast(zendesk()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceConnectorProperties, T> g) {
        return obj -> g.apply((SourceConnectorProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceConnectorProperties> {
        /**
         * <p>
         * The properties that are applied when Marketo is being used as a source.
         * </p>
         * 
         * @param marketo
         *        The properties that are applied when Marketo is being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marketo(MarketoSourceProperties marketo);

        /**
         * <p>
         * The properties that are applied when Marketo is being used as a source.
         * </p>
         * This is a convenience that creates an instance of the {@link MarketoSourceProperties.Builder} avoiding the
         * need to create one manually via {@link MarketoSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link MarketoSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #marketo(MarketoSourceProperties)}.
         * 
         * @param marketo
         *        a consumer that will call methods on {@link MarketoSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #marketo(MarketoSourceProperties)
         */
        default Builder marketo(Consumer<MarketoSourceProperties.Builder> marketo) {
            return marketo(MarketoSourceProperties.builder().applyMutation(marketo).build());
        }

        /**
         * <p>
         * The properties that are applied when Amazon S3 is being used as the flow source.
         * </p>
         * 
         * @param s3
         *        The properties that are applied when Amazon S3 is being used as the flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3(S3SourceProperties s3);

        /**
         * <p>
         * The properties that are applied when Amazon S3 is being used as the flow source.
         * </p>
         * This is a convenience that creates an instance of the {@link S3SourceProperties.Builder} avoiding the need to
         * create one manually via {@link S3SourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link S3SourceProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #s3(S3SourceProperties)}.
         * 
         * @param s3
         *        a consumer that will call methods on {@link S3SourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3(S3SourceProperties)
         */
        default Builder s3(Consumer<S3SourceProperties.Builder> s3) {
            return s3(S3SourceProperties.builder().applyMutation(s3).build());
        }

        /**
         * <p>
         * The properties that are applied when Salesforce is being used as a source.
         * </p>
         * 
         * @param salesforce
         *        The properties that are applied when Salesforce is being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder salesforce(SalesforceSourceProperties salesforce);

        /**
         * <p>
         * The properties that are applied when Salesforce is being used as a source.
         * </p>
         * This is a convenience that creates an instance of the {@link SalesforceSourceProperties.Builder} avoiding the
         * need to create one manually via {@link SalesforceSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SalesforceSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #salesforce(SalesforceSourceProperties)}.
         * 
         * @param salesforce
         *        a consumer that will call methods on {@link SalesforceSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #salesforce(SalesforceSourceProperties)
         */
        default Builder salesforce(Consumer<SalesforceSourceProperties.Builder> salesforce) {
            return salesforce(SalesforceSourceProperties.builder().applyMutation(salesforce).build());
        }

        /**
         * <p>
         * The properties that are applied when ServiceNow is being used as a source.
         * </p>
         * 
         * @param serviceNow
         *        The properties that are applied when ServiceNow is being used as a source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNow(ServiceNowSourceProperties serviceNow);

        /**
         * <p>
         * The properties that are applied when ServiceNow is being used as a source.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceNowSourceProperties.Builder} avoiding the
         * need to create one manually via {@link ServiceNowSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceNowSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceNow(ServiceNowSourceProperties)}.
         * 
         * @param serviceNow
         *        a consumer that will call methods on {@link ServiceNowSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNow(ServiceNowSourceProperties)
         */
        default Builder serviceNow(Consumer<ServiceNowSourceProperties.Builder> serviceNow) {
            return serviceNow(ServiceNowSourceProperties.builder().applyMutation(serviceNow).build());
        }

        /**
         * <p>
         * The properties that are applied when using Zendesk as a flow source.
         * </p>
         * 
         * @param zendesk
         *        The properties that are applied when using Zendesk as a flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zendesk(ZendeskSourceProperties zendesk);

        /**
         * <p>
         * The properties that are applied when using Zendesk as a flow source.
         * </p>
         * This is a convenience that creates an instance of the {@link ZendeskSourceProperties.Builder} avoiding the
         * need to create one manually via {@link ZendeskSourceProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link ZendeskSourceProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #zendesk(ZendeskSourceProperties)}.
         * 
         * @param zendesk
         *        a consumer that will call methods on {@link ZendeskSourceProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zendesk(ZendeskSourceProperties)
         */
        default Builder zendesk(Consumer<ZendeskSourceProperties.Builder> zendesk) {
            return zendesk(ZendeskSourceProperties.builder().applyMutation(zendesk).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MarketoSourceProperties marketo;

        private S3SourceProperties s3;

        private SalesforceSourceProperties salesforce;

        private ServiceNowSourceProperties serviceNow;

        private ZendeskSourceProperties zendesk;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConnectorProperties model) {
            marketo(model.marketo);
            s3(model.s3);
            salesforce(model.salesforce);
            serviceNow(model.serviceNow);
            zendesk(model.zendesk);
        }

        public final MarketoSourceProperties.Builder getMarketo() {
            return marketo != null ? marketo.toBuilder() : null;
        }

        @Override
        public final Builder marketo(MarketoSourceProperties marketo) {
            this.marketo = marketo;
            return this;
        }

        public final void setMarketo(MarketoSourceProperties.BuilderImpl marketo) {
            this.marketo = marketo != null ? marketo.build() : null;
        }

        public final S3SourceProperties.Builder getS3() {
            return s3 != null ? s3.toBuilder() : null;
        }

        @Override
        public final Builder s3(S3SourceProperties s3) {
            this.s3 = s3;
            return this;
        }

        public final void setS3(S3SourceProperties.BuilderImpl s3) {
            this.s3 = s3 != null ? s3.build() : null;
        }

        public final SalesforceSourceProperties.Builder getSalesforce() {
            return salesforce != null ? salesforce.toBuilder() : null;
        }

        @Override
        public final Builder salesforce(SalesforceSourceProperties salesforce) {
            this.salesforce = salesforce;
            return this;
        }

        public final void setSalesforce(SalesforceSourceProperties.BuilderImpl salesforce) {
            this.salesforce = salesforce != null ? salesforce.build() : null;
        }

        public final ServiceNowSourceProperties.Builder getServiceNow() {
            return serviceNow != null ? serviceNow.toBuilder() : null;
        }

        @Override
        public final Builder serviceNow(ServiceNowSourceProperties serviceNow) {
            this.serviceNow = serviceNow;
            return this;
        }

        public final void setServiceNow(ServiceNowSourceProperties.BuilderImpl serviceNow) {
            this.serviceNow = serviceNow != null ? serviceNow.build() : null;
        }

        public final ZendeskSourceProperties.Builder getZendesk() {
            return zendesk != null ? zendesk.toBuilder() : null;
        }

        @Override
        public final Builder zendesk(ZendeskSourceProperties zendesk) {
            this.zendesk = zendesk;
            return this;
        }

        public final void setZendesk(ZendeskSourceProperties.BuilderImpl zendesk) {
            this.zendesk = zendesk != null ? zendesk.build() : null;
        }

        @Override
        public SourceConnectorProperties build() {
            return new SourceConnectorProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
