/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum SourceConnectorType {
    SALESFORCE("Salesforce"),
    MARKETO("Marketo"),
    ZENDESK("Zendesk"),
    SERVICENOW("Servicenow"),
    S3("S3"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SourceConnectorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceConnectorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SourceConnectorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceConnectorType> knownValues() {
        return Stream.of(SourceConnectorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

