/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics about the Identity Resolution Job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobStats implements SdkPojo, Serializable, ToCopyableBuilder<JobStats.Builder, JobStats> {
    private static final SdkField<Long> NUMBER_OF_PROFILES_REVIEWED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfProfilesReviewed").getter(getter(JobStats::numberOfProfilesReviewed))
            .setter(setter(Builder::numberOfProfilesReviewed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfProfilesReviewed").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_MATCHES_FOUND_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfMatchesFound").getter(getter(JobStats::numberOfMatchesFound))
            .setter(setter(Builder::numberOfMatchesFound))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchesFound").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_MERGES_DONE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfMergesDone").getter(getter(JobStats::numberOfMergesDone))
            .setter(setter(Builder::numberOfMergesDone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMergesDone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_PROFILES_REVIEWED_FIELD, NUMBER_OF_MATCHES_FOUND_FIELD, NUMBER_OF_MERGES_DONE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long numberOfProfilesReviewed;

    private final Long numberOfMatchesFound;

    private final Long numberOfMergesDone;

    private JobStats(BuilderImpl builder) {
        this.numberOfProfilesReviewed = builder.numberOfProfilesReviewed;
        this.numberOfMatchesFound = builder.numberOfMatchesFound;
        this.numberOfMergesDone = builder.numberOfMergesDone;
    }

    /**
     * <p>
     * The number of profiles reviewed.
     * </p>
     * 
     * @return The number of profiles reviewed.
     */
    public final Long numberOfProfilesReviewed() {
        return numberOfProfilesReviewed;
    }

    /**
     * <p>
     * The number of matches found.
     * </p>
     * 
     * @return The number of matches found.
     */
    public final Long numberOfMatchesFound() {
        return numberOfMatchesFound;
    }

    /**
     * <p>
     * The number of merges completed.
     * </p>
     * 
     * @return The number of merges completed.
     */
    public final Long numberOfMergesDone() {
        return numberOfMergesDone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfProfilesReviewed());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMatchesFound());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMergesDone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobStats)) {
            return false;
        }
        JobStats other = (JobStats) obj;
        return Objects.equals(numberOfProfilesReviewed(), other.numberOfProfilesReviewed())
                && Objects.equals(numberOfMatchesFound(), other.numberOfMatchesFound())
                && Objects.equals(numberOfMergesDone(), other.numberOfMergesDone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobStats").add("NumberOfProfilesReviewed", numberOfProfilesReviewed())
                .add("NumberOfMatchesFound", numberOfMatchesFound()).add("NumberOfMergesDone", numberOfMergesDone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfProfilesReviewed":
            return Optional.ofNullable(clazz.cast(numberOfProfilesReviewed()));
        case "NumberOfMatchesFound":
            return Optional.ofNullable(clazz.cast(numberOfMatchesFound()));
        case "NumberOfMergesDone":
            return Optional.ofNullable(clazz.cast(numberOfMergesDone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobStats, T> g) {
        return obj -> g.apply((JobStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobStats> {
        /**
         * <p>
         * The number of profiles reviewed.
         * </p>
         * 
         * @param numberOfProfilesReviewed
         *        The number of profiles reviewed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfProfilesReviewed(Long numberOfProfilesReviewed);

        /**
         * <p>
         * The number of matches found.
         * </p>
         * 
         * @param numberOfMatchesFound
         *        The number of matches found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMatchesFound(Long numberOfMatchesFound);

        /**
         * <p>
         * The number of merges completed.
         * </p>
         * 
         * @param numberOfMergesDone
         *        The number of merges completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMergesDone(Long numberOfMergesDone);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfProfilesReviewed;

        private Long numberOfMatchesFound;

        private Long numberOfMergesDone;

        private BuilderImpl() {
        }

        private BuilderImpl(JobStats model) {
            numberOfProfilesReviewed(model.numberOfProfilesReviewed);
            numberOfMatchesFound(model.numberOfMatchesFound);
            numberOfMergesDone(model.numberOfMergesDone);
        }

        public final Long getNumberOfProfilesReviewed() {
            return numberOfProfilesReviewed;
        }

        public final void setNumberOfProfilesReviewed(Long numberOfProfilesReviewed) {
            this.numberOfProfilesReviewed = numberOfProfilesReviewed;
        }

        @Override
        @Transient
        public final Builder numberOfProfilesReviewed(Long numberOfProfilesReviewed) {
            this.numberOfProfilesReviewed = numberOfProfilesReviewed;
            return this;
        }

        public final Long getNumberOfMatchesFound() {
            return numberOfMatchesFound;
        }

        public final void setNumberOfMatchesFound(Long numberOfMatchesFound) {
            this.numberOfMatchesFound = numberOfMatchesFound;
        }

        @Override
        @Transient
        public final Builder numberOfMatchesFound(Long numberOfMatchesFound) {
            this.numberOfMatchesFound = numberOfMatchesFound;
            return this;
        }

        public final Long getNumberOfMergesDone() {
            return numberOfMergesDone;
        }

        public final void setNumberOfMergesDone(Long numberOfMergesDone) {
            this.numberOfMergesDone = numberOfMergesDone;
        }

        @Override
        @Transient
        public final Builder numberOfMergesDone(Long numberOfMergesDone) {
            this.numberOfMergesDone = numberOfMergesDone;
            return this;
        }

        @Override
        public JobStats build() {
            return new JobStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
