/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListIdentityResolutionJobsResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<ListIdentityResolutionJobsResponse.Builder, ListIdentityResolutionJobsResponse> {
    private static final SdkField<List<IdentityResolutionJob>> IDENTITY_RESOLUTION_JOBS_LIST_FIELD = SdkField
            .<List<IdentityResolutionJob>> builder(MarshallingType.LIST)
            .memberName("IdentityResolutionJobsList")
            .getter(getter(ListIdentityResolutionJobsResponse::identityResolutionJobsList))
            .setter(setter(Builder::identityResolutionJobsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityResolutionJobsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IdentityResolutionJob> builder(MarshallingType.SDK_POJO)
                                            .constructor(IdentityResolutionJob::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListIdentityResolutionJobsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            IDENTITY_RESOLUTION_JOBS_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<IdentityResolutionJob> identityResolutionJobsList;

    private final String nextToken;

    private ListIdentityResolutionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.identityResolutionJobsList = builder.identityResolutionJobsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the IdentityResolutionJobsList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasIdentityResolutionJobsList() {
        return identityResolutionJobsList != null && !(identityResolutionJobsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Identity Resolution Jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentityResolutionJobsList} method.
     * </p>
     * 
     * @return A list of Identity Resolution Jobs.
     */
    public final List<IdentityResolutionJob> identityResolutionJobsList() {
        return identityResolutionJobsList;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentityResolutionJobsList() ? identityResolutionJobsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIdentityResolutionJobsResponse)) {
            return false;
        }
        ListIdentityResolutionJobsResponse other = (ListIdentityResolutionJobsResponse) obj;
        return hasIdentityResolutionJobsList() == other.hasIdentityResolutionJobsList()
                && Objects.equals(identityResolutionJobsList(), other.identityResolutionJobsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListIdentityResolutionJobsResponse")
                .add("IdentityResolutionJobsList", hasIdentityResolutionJobsList() ? identityResolutionJobsList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IdentityResolutionJobsList":
            return Optional.ofNullable(clazz.cast(identityResolutionJobsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListIdentityResolutionJobsResponse, T> g) {
        return obj -> g.apply((ListIdentityResolutionJobsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListIdentityResolutionJobsResponse> {
        /**
         * <p>
         * A list of Identity Resolution Jobs.
         * </p>
         * 
         * @param identityResolutionJobsList
         *        A list of Identity Resolution Jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityResolutionJobsList(Collection<IdentityResolutionJob> identityResolutionJobsList);

        /**
         * <p>
         * A list of Identity Resolution Jobs.
         * </p>
         * 
         * @param identityResolutionJobsList
         *        A list of Identity Resolution Jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityResolutionJobsList(IdentityResolutionJob... identityResolutionJobsList);

        /**
         * <p>
         * A list of Identity Resolution Jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<IdentityResolutionJob>.Builder} avoiding
         * the need to create one manually via {@link List<IdentityResolutionJob>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<IdentityResolutionJob>.Builder#build()} is called
         * immediately and its result is passed to {@link #identityResolutionJobsList(List<IdentityResolutionJob>)}.
         * 
         * @param identityResolutionJobsList
         *        a consumer that will call methods on {@link List<IdentityResolutionJob>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identityResolutionJobsList(List<IdentityResolutionJob>)
         */
        Builder identityResolutionJobsList(Consumer<IdentityResolutionJob.Builder>... identityResolutionJobsList);

        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private List<IdentityResolutionJob> identityResolutionJobsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIdentityResolutionJobsResponse model) {
            super(model);
            identityResolutionJobsList(model.identityResolutionJobsList);
            nextToken(model.nextToken);
        }

        public final List<IdentityResolutionJob.Builder> getIdentityResolutionJobsList() {
            List<IdentityResolutionJob.Builder> result = IdentityResolutionJobsListCopier
                    .copyToBuilder(this.identityResolutionJobsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIdentityResolutionJobsList(Collection<IdentityResolutionJob.BuilderImpl> identityResolutionJobsList) {
            this.identityResolutionJobsList = IdentityResolutionJobsListCopier.copyFromBuilder(identityResolutionJobsList);
        }

        @Override
        @Transient
        public final Builder identityResolutionJobsList(Collection<IdentityResolutionJob> identityResolutionJobsList) {
            this.identityResolutionJobsList = IdentityResolutionJobsListCopier.copy(identityResolutionJobsList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityResolutionJobsList(IdentityResolutionJob... identityResolutionJobsList) {
            identityResolutionJobsList(Arrays.asList(identityResolutionJobsList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder identityResolutionJobsList(Consumer<IdentityResolutionJob.Builder>... identityResolutionJobsList) {
            identityResolutionJobsList(Stream.of(identityResolutionJobsList)
                    .map(c -> IdentityResolutionJob.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListIdentityResolutionJobsResponse build() {
            return new ListIdentityResolutionJobsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
