/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The flag that enables the matching process of duplicate profiles.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MatchingResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<MatchingResponse.Builder, MatchingResponse> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(MatchingResponse::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<JobSchedule> JOB_SCHEDULE_FIELD = SdkField.<JobSchedule> builder(MarshallingType.SDK_POJO)
            .memberName("JobSchedule").getter(getter(MatchingResponse::jobSchedule)).setter(setter(Builder::jobSchedule))
            .constructor(JobSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobSchedule").build()).build();

    private static final SdkField<AutoMerging> AUTO_MERGING_FIELD = SdkField.<AutoMerging> builder(MarshallingType.SDK_POJO)
            .memberName("AutoMerging").getter(getter(MatchingResponse::autoMerging)).setter(setter(Builder::autoMerging))
            .constructor(AutoMerging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMerging").build()).build();

    private static final SdkField<ExportingConfig> EXPORTING_CONFIG_FIELD = SdkField
            .<ExportingConfig> builder(MarshallingType.SDK_POJO).memberName("ExportingConfig")
            .getter(getter(MatchingResponse::exportingConfig)).setter(setter(Builder::exportingConfig))
            .constructor(ExportingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            JOB_SCHEDULE_FIELD, AUTO_MERGING_FIELD, EXPORTING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final JobSchedule jobSchedule;

    private final AutoMerging autoMerging;

    private final ExportingConfig exportingConfig;

    private MatchingResponse(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.jobSchedule = builder.jobSchedule;
        this.autoMerging = builder.autoMerging;
        this.exportingConfig = builder.exportingConfig;
    }

    /**
     * <p>
     * The flag that enables the matching process of duplicate profiles.
     * </p>
     * 
     * @return The flag that enables the matching process of duplicate profiles.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The day and time when do you want to start the Identity Resolution Job every week.
     * </p>
     * 
     * @return The day and time when do you want to start the Identity Resolution Job every week.
     */
    public final JobSchedule jobSchedule() {
        return jobSchedule;
    }

    /**
     * <p>
     * Configuration information about the auto-merging process.
     * </p>
     * 
     * @return Configuration information about the auto-merging process.
     */
    public final AutoMerging autoMerging() {
        return autoMerging;
    }

    /**
     * <p>
     * Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
     * </p>
     * 
     * @return Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
     */
    public final ExportingConfig exportingConfig() {
        return exportingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(jobSchedule());
        hashCode = 31 * hashCode + Objects.hashCode(autoMerging());
        hashCode = 31 * hashCode + Objects.hashCode(exportingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchingResponse)) {
            return false;
        }
        MatchingResponse other = (MatchingResponse) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(jobSchedule(), other.jobSchedule())
                && Objects.equals(autoMerging(), other.autoMerging())
                && Objects.equals(exportingConfig(), other.exportingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MatchingResponse").add("Enabled", enabled()).add("JobSchedule", jobSchedule())
                .add("AutoMerging", autoMerging()).add("ExportingConfig", exportingConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "JobSchedule":
            return Optional.ofNullable(clazz.cast(jobSchedule()));
        case "AutoMerging":
            return Optional.ofNullable(clazz.cast(autoMerging()));
        case "ExportingConfig":
            return Optional.ofNullable(clazz.cast(exportingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchingResponse, T> g) {
        return obj -> g.apply((MatchingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MatchingResponse> {
        /**
         * <p>
         * The flag that enables the matching process of duplicate profiles.
         * </p>
         * 
         * @param enabled
         *        The flag that enables the matching process of duplicate profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The day and time when do you want to start the Identity Resolution Job every week.
         * </p>
         * 
         * @param jobSchedule
         *        The day and time when do you want to start the Identity Resolution Job every week.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobSchedule(JobSchedule jobSchedule);

        /**
         * <p>
         * The day and time when do you want to start the Identity Resolution Job every week.
         * </p>
         * This is a convenience that creates an instance of the {@link JobSchedule.Builder} avoiding the need to create
         * one manually via {@link JobSchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link JobSchedule.Builder#build()} is called immediately and its result
         * is passed to {@link #jobSchedule(JobSchedule)}.
         * 
         * @param jobSchedule
         *        a consumer that will call methods on {@link JobSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobSchedule(JobSchedule)
         */
        default Builder jobSchedule(Consumer<JobSchedule.Builder> jobSchedule) {
            return jobSchedule(JobSchedule.builder().applyMutation(jobSchedule).build());
        }

        /**
         * <p>
         * Configuration information about the auto-merging process.
         * </p>
         * 
         * @param autoMerging
         *        Configuration information about the auto-merging process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMerging(AutoMerging autoMerging);

        /**
         * <p>
         * Configuration information about the auto-merging process.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoMerging.Builder} avoiding the need to create
         * one manually via {@link AutoMerging#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoMerging.Builder#build()} is called immediately and its result
         * is passed to {@link #autoMerging(AutoMerging)}.
         * 
         * @param autoMerging
         *        a consumer that will call methods on {@link AutoMerging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMerging(AutoMerging)
         */
        default Builder autoMerging(Consumer<AutoMerging.Builder> autoMerging) {
            return autoMerging(AutoMerging.builder().applyMutation(autoMerging).build());
        }

        /**
         * <p>
         * Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
         * </p>
         * 
         * @param exportingConfig
         *        Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingConfig(ExportingConfig exportingConfig);

        /**
         * <p>
         * Configuration information for exporting Identity Resolution results, for example, to an S3 bucket.
         * </p>
         * This is a convenience that creates an instance of the {@link ExportingConfig.Builder} avoiding the need to
         * create one manually via {@link ExportingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link ExportingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #exportingConfig(ExportingConfig)}.
         * 
         * @param exportingConfig
         *        a consumer that will call methods on {@link ExportingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportingConfig(ExportingConfig)
         */
        default Builder exportingConfig(Consumer<ExportingConfig.Builder> exportingConfig) {
            return exportingConfig(ExportingConfig.builder().applyMutation(exportingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private JobSchedule jobSchedule;

        private AutoMerging autoMerging;

        private ExportingConfig exportingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(MatchingResponse model) {
            enabled(model.enabled);
            jobSchedule(model.jobSchedule);
            autoMerging(model.autoMerging);
            exportingConfig(model.exportingConfig);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        @Transient
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final JobSchedule.Builder getJobSchedule() {
            return jobSchedule != null ? jobSchedule.toBuilder() : null;
        }

        public final void setJobSchedule(JobSchedule.BuilderImpl jobSchedule) {
            this.jobSchedule = jobSchedule != null ? jobSchedule.build() : null;
        }

        @Override
        @Transient
        public final Builder jobSchedule(JobSchedule jobSchedule) {
            this.jobSchedule = jobSchedule;
            return this;
        }

        public final AutoMerging.Builder getAutoMerging() {
            return autoMerging != null ? autoMerging.toBuilder() : null;
        }

        public final void setAutoMerging(AutoMerging.BuilderImpl autoMerging) {
            this.autoMerging = autoMerging != null ? autoMerging.build() : null;
        }

        @Override
        @Transient
        public final Builder autoMerging(AutoMerging autoMerging) {
            this.autoMerging = autoMerging;
            return this;
        }

        public final ExportingConfig.Builder getExportingConfig() {
            return exportingConfig != null ? exportingConfig.toBuilder() : null;
        }

        public final void setExportingConfig(ExportingConfig.BuilderImpl exportingConfig) {
            this.exportingConfig = exportingConfig != null ? exportingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder exportingConfig(ExportingConfig exportingConfig) {
            this.exportingConfig = exportingConfig;
            return this;
        }

        @Override
        public MatchingResponse build() {
            return new MatchingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
