/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobStats
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobStats> {
    private static final SdkField<Long> NUMBER_OF_PROFILES_REVIEWED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfProfilesReviewed").getter(JobStats.getter(JobStats::numberOfProfilesReviewed)).setter(JobStats.setter(Builder::numberOfProfilesReviewed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfProfilesReviewed").build()}).build();
    private static final SdkField<Long> NUMBER_OF_MATCHES_FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfMatchesFound").getter(JobStats.getter(JobStats::numberOfMatchesFound)).setter(JobStats.setter(Builder::numberOfMatchesFound)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchesFound").build()}).build();
    private static final SdkField<Long> NUMBER_OF_MERGES_DONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("NumberOfMergesDone").getter(JobStats.getter(JobStats::numberOfMergesDone)).setter(JobStats.setter(Builder::numberOfMergesDone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMergesDone").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_PROFILES_REVIEWED_FIELD, NUMBER_OF_MATCHES_FOUND_FIELD, NUMBER_OF_MERGES_DONE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long numberOfProfilesReviewed;
    private final Long numberOfMatchesFound;
    private final Long numberOfMergesDone;

    private JobStats(BuilderImpl builder) {
        this.numberOfProfilesReviewed = builder.numberOfProfilesReviewed;
        this.numberOfMatchesFound = builder.numberOfMatchesFound;
        this.numberOfMergesDone = builder.numberOfMergesDone;
    }

    public final Long numberOfProfilesReviewed() {
        return this.numberOfProfilesReviewed;
    }

    public final Long numberOfMatchesFound() {
        return this.numberOfMatchesFound;
    }

    public final Long numberOfMergesDone() {
        return this.numberOfMergesDone;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfProfilesReviewed());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMatchesFound());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfMergesDone());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobStats)) {
            return false;
        }
        JobStats other = (JobStats)obj;
        return Objects.equals(this.numberOfProfilesReviewed(), other.numberOfProfilesReviewed()) && Objects.equals(this.numberOfMatchesFound(), other.numberOfMatchesFound()) && Objects.equals(this.numberOfMergesDone(), other.numberOfMergesDone());
    }

    public final String toString() {
        return ToString.builder((String)"JobStats").add("NumberOfProfilesReviewed", (Object)this.numberOfProfilesReviewed()).add("NumberOfMatchesFound", (Object)this.numberOfMatchesFound()).add("NumberOfMergesDone", (Object)this.numberOfMergesDone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NumberOfProfilesReviewed": {
                return Optional.ofNullable(clazz.cast(this.numberOfProfilesReviewed()));
            }
            case "NumberOfMatchesFound": {
                return Optional.ofNullable(clazz.cast(this.numberOfMatchesFound()));
            }
            case "NumberOfMergesDone": {
                return Optional.ofNullable(clazz.cast(this.numberOfMergesDone()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobStats, T> g) {
        return obj -> g.apply((JobStats)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long numberOfProfilesReviewed;
        private Long numberOfMatchesFound;
        private Long numberOfMergesDone;

        private BuilderImpl() {
        }

        private BuilderImpl(JobStats model) {
            this.numberOfProfilesReviewed(model.numberOfProfilesReviewed);
            this.numberOfMatchesFound(model.numberOfMatchesFound);
            this.numberOfMergesDone(model.numberOfMergesDone);
        }

        public final Long getNumberOfProfilesReviewed() {
            return this.numberOfProfilesReviewed;
        }

        public final void setNumberOfProfilesReviewed(Long numberOfProfilesReviewed) {
            this.numberOfProfilesReviewed = numberOfProfilesReviewed;
        }

        @Override
        @Transient
        public final Builder numberOfProfilesReviewed(Long numberOfProfilesReviewed) {
            this.numberOfProfilesReviewed = numberOfProfilesReviewed;
            return this;
        }

        public final Long getNumberOfMatchesFound() {
            return this.numberOfMatchesFound;
        }

        public final void setNumberOfMatchesFound(Long numberOfMatchesFound) {
            this.numberOfMatchesFound = numberOfMatchesFound;
        }

        @Override
        @Transient
        public final Builder numberOfMatchesFound(Long numberOfMatchesFound) {
            this.numberOfMatchesFound = numberOfMatchesFound;
            return this;
        }

        public final Long getNumberOfMergesDone() {
            return this.numberOfMergesDone;
        }

        public final void setNumberOfMergesDone(Long numberOfMergesDone) {
            this.numberOfMergesDone = numberOfMergesDone;
        }

        @Override
        @Transient
        public final Builder numberOfMergesDone(Long numberOfMergesDone) {
            this.numberOfMergesDone = numberOfMergesDone;
            return this;
        }

        public JobStats build() {
            return new JobStats(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobStats> {
        public Builder numberOfProfilesReviewed(Long var1);

        public Builder numberOfMatchesFound(Long var1);

        public Builder numberOfMergesDone(Long var1);
    }
}

