/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.customerprofiles.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppflowIntegrationWorkflowStep
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppflowIntegrationWorkflowStep> {
    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FlowName").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::flowName)).setter(AppflowIntegrationWorkflowStep.setter(Builder::flowName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::statusAsString)).setter(AppflowIntegrationWorkflowStep.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> EXECUTION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionMessage").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::executionMessage)).setter(AppflowIntegrationWorkflowStep.setter(Builder::executionMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionMessage").build()}).build();
    private static final SdkField<Long> RECORDS_PROCESSED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RecordsProcessed").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::recordsProcessed)).setter(AppflowIntegrationWorkflowStep.setter(Builder::recordsProcessed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordsProcessed").build()}).build();
    private static final SdkField<String> BATCH_RECORDS_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchRecordsStartTime").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::batchRecordsStartTime)).setter(AppflowIntegrationWorkflowStep.setter(Builder::batchRecordsStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchRecordsStartTime").build()}).build();
    private static final SdkField<String> BATCH_RECORDS_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BatchRecordsEndTime").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::batchRecordsEndTime)).setter(AppflowIntegrationWorkflowStep.setter(Builder::batchRecordsEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchRecordsEndTime").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::createdAt)).setter(AppflowIntegrationWorkflowStep.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(AppflowIntegrationWorkflowStep.getter(AppflowIntegrationWorkflowStep::lastUpdatedAt)).setter(AppflowIntegrationWorkflowStep.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_NAME_FIELD, STATUS_FIELD, EXECUTION_MESSAGE_FIELD, RECORDS_PROCESSED_FIELD, BATCH_RECORDS_START_TIME_FIELD, BATCH_RECORDS_END_TIME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String flowName;
    private final String status;
    private final String executionMessage;
    private final Long recordsProcessed;
    private final String batchRecordsStartTime;
    private final String batchRecordsEndTime;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;

    private AppflowIntegrationWorkflowStep(BuilderImpl builder) {
        this.flowName = builder.flowName;
        this.status = builder.status;
        this.executionMessage = builder.executionMessage;
        this.recordsProcessed = builder.recordsProcessed;
        this.batchRecordsStartTime = builder.batchRecordsStartTime;
        this.batchRecordsEndTime = builder.batchRecordsEndTime;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
    }

    public final String flowName() {
        return this.flowName;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String executionMessage() {
        return this.executionMessage;
    }

    public final Long recordsProcessed() {
        return this.recordsProcessed;
    }

    public final String batchRecordsStartTime() {
        return this.batchRecordsStartTime;
    }

    public final String batchRecordsEndTime() {
        return this.batchRecordsEndTime;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.flowName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.recordsProcessed());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchRecordsStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchRecordsEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppflowIntegrationWorkflowStep)) {
            return false;
        }
        AppflowIntegrationWorkflowStep other = (AppflowIntegrationWorkflowStep)obj;
        return Objects.equals(this.flowName(), other.flowName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionMessage(), other.executionMessage()) && Objects.equals(this.recordsProcessed(), other.recordsProcessed()) && Objects.equals(this.batchRecordsStartTime(), other.batchRecordsStartTime()) && Objects.equals(this.batchRecordsEndTime(), other.batchRecordsEndTime()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AppflowIntegrationWorkflowStep").add("FlowName", (Object)this.flowName()).add("Status", (Object)this.statusAsString()).add("ExecutionMessage", (Object)this.executionMessage()).add("RecordsProcessed", (Object)this.recordsProcessed()).add("BatchRecordsStartTime", (Object)this.batchRecordsStartTime()).add("BatchRecordsEndTime", (Object)this.batchRecordsEndTime()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FlowName": {
                return Optional.ofNullable(clazz.cast(this.flowName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ExecutionMessage": {
                return Optional.ofNullable(clazz.cast(this.executionMessage()));
            }
            case "RecordsProcessed": {
                return Optional.ofNullable(clazz.cast(this.recordsProcessed()));
            }
            case "BatchRecordsStartTime": {
                return Optional.ofNullable(clazz.cast(this.batchRecordsStartTime()));
            }
            case "BatchRecordsEndTime": {
                return Optional.ofNullable(clazz.cast(this.batchRecordsEndTime()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AppflowIntegrationWorkflowStep, T> g) {
        return obj -> g.apply((AppflowIntegrationWorkflowStep)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String flowName;
        private String status;
        private String executionMessage;
        private Long recordsProcessed;
        private String batchRecordsStartTime;
        private String batchRecordsEndTime;
        private Instant createdAt;
        private Instant lastUpdatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AppflowIntegrationWorkflowStep model) {
            this.flowName(model.flowName);
            this.status(model.status);
            this.executionMessage(model.executionMessage);
            this.recordsProcessed(model.recordsProcessed);
            this.batchRecordsStartTime(model.batchRecordsStartTime);
            this.batchRecordsEndTime(model.batchRecordsEndTime);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
        }

        public final String getFlowName() {
            return this.flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        @Transient
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionMessage() {
            return this.executionMessage;
        }

        public final void setExecutionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
        }

        @Override
        @Transient
        public final Builder executionMessage(String executionMessage) {
            this.executionMessage = executionMessage;
            return this;
        }

        public final Long getRecordsProcessed() {
            return this.recordsProcessed;
        }

        public final void setRecordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
        }

        @Override
        @Transient
        public final Builder recordsProcessed(Long recordsProcessed) {
            this.recordsProcessed = recordsProcessed;
            return this;
        }

        public final String getBatchRecordsStartTime() {
            return this.batchRecordsStartTime;
        }

        public final void setBatchRecordsStartTime(String batchRecordsStartTime) {
            this.batchRecordsStartTime = batchRecordsStartTime;
        }

        @Override
        @Transient
        public final Builder batchRecordsStartTime(String batchRecordsStartTime) {
            this.batchRecordsStartTime = batchRecordsStartTime;
            return this;
        }

        public final String getBatchRecordsEndTime() {
            return this.batchRecordsEndTime;
        }

        public final void setBatchRecordsEndTime(String batchRecordsEndTime) {
            this.batchRecordsEndTime = batchRecordsEndTime;
        }

        @Override
        @Transient
        public final Builder batchRecordsEndTime(String batchRecordsEndTime) {
            this.batchRecordsEndTime = batchRecordsEndTime;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public AppflowIntegrationWorkflowStep build() {
            return new AppflowIntegrationWorkflowStep(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppflowIntegrationWorkflowStep> {
        public Builder flowName(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);

        public Builder executionMessage(String var1);

        public Builder recordsProcessed(Long var1);

        public Builder batchRecordsStartTime(String var1);

        public Builder batchRecordsEndTime(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);
    }
}

