/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutProfileObjectTypeRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<PutProfileObjectTypeRequest.Builder, PutProfileObjectTypeRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(PutProfileObjectTypeRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(PutProfileObjectTypeRequest::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("ObjectTypeName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PutProfileObjectTypeRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(PutProfileObjectTypeRequest::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ExpirationDays").getter(getter(PutProfileObjectTypeRequest::expirationDays))
            .setter(setter(Builder::expirationDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()).build();

    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptionKey").getter(getter(PutProfileObjectTypeRequest::encryptionKey))
            .setter(setter(Builder::encryptionKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()).build();

    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowProfileCreation").getter(getter(PutProfileObjectTypeRequest::allowProfileCreation))
            .setter(setter(Builder::allowProfileCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build())
            .build();

    private static final SdkField<String> SOURCE_LAST_UPDATED_TIMESTAMP_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SourceLastUpdatedTimestampFormat")
            .getter(getter(PutProfileObjectTypeRequest::sourceLastUpdatedTimestampFormat))
            .setter(setter(Builder::sourceLastUpdatedTimestampFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceLastUpdatedTimestampFormat")
                    .build()).build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(PutProfileObjectTypeRequest::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField
            .<Map<String, List<ObjectTypeKey>>> builder(MarshallingType.MAP)
            .memberName("Keys")
            .getter(getter(PutProfileObjectTypeRequest::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ObjectTypeKey>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ObjectTypeKey> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ObjectTypeKey::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PutProfileObjectTypeRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, EXPIRATION_DAYS_FIELD, ENCRYPTION_KEY_FIELD,
            ALLOW_PROFILE_CREATION_FIELD, SOURCE_LAST_UPDATED_TIMESTAMP_FORMAT_FIELD, FIELDS_FIELD, KEYS_FIELD, TAGS_FIELD));

    private final String domainName;

    private final String objectTypeName;

    private final String description;

    private final String templateId;

    private final Integer expirationDays;

    private final String encryptionKey;

    private final Boolean allowProfileCreation;

    private final String sourceLastUpdatedTimestampFormat;

    private final Map<String, ObjectTypeField> fields;

    private final Map<String, List<ObjectTypeKey>> keys;

    private final Map<String, String> tags;

    private PutProfileObjectTypeRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.expirationDays = builder.expirationDays;
        this.encryptionKey = builder.encryptionKey;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.sourceLastUpdatedTimestampFormat = builder.sourceLastUpdatedTimestampFormat;
        this.fields = builder.fields;
        this.keys = builder.keys;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the profile object type.
     * </p>
     * 
     * @return The name of the profile object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * Description of the profile object type.
     * </p>
     * 
     * @return Description of the profile object type.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A unique identifier for the object template.
     * </p>
     * 
     * @return A unique identifier for the object template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The number of days until the data in the object expires.
     * </p>
     * 
     * @return The number of days until the data in the object expires.
     */
    public final Integer expirationDays() {
        return expirationDays;
    }

    /**
     * <p>
     * The customer-provided key to encrypt the profile object that will be created in this profile object type.
     * </p>
     * 
     * @return The customer-provided key to encrypt the profile object that will be created in this profile object type.
     */
    public final String encryptionKey() {
        return encryptionKey;
    }

    /**
     * <p>
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this
     * type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the
     * service tries to fetch a standard profile and associate this object with the profile. If it is set to
     * <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
     * </p>
     * 
     * @return Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
     *         this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
     *         <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the
     *         profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new
     *         standard profile.
     */
    public final Boolean allowProfileCreation() {
        return allowProfileCreation;
    }

    /**
     * <p>
     * The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.
     * </p>
     * 
     * @return The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.
     */
    public final String sourceLastUpdatedTimestampFormat() {
        return sourceLastUpdatedTimestampFormat;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the name and ObjectType field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A map of the name and ObjectType field.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of unique keys that can be used to map data to the profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return A list of unique keys that can be used to map data to the profile.
     */
    public final Map<String, List<ObjectTypeKey>> keys() {
        return keys;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceLastUpdatedTimestampFormat());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutProfileObjectTypeRequest)) {
            return false;
        }
        PutProfileObjectTypeRequest other = (PutProfileObjectTypeRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(objectTypeName(), other.objectTypeName())
                && Objects.equals(description(), other.description()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(expirationDays(), other.expirationDays())
                && Objects.equals(encryptionKey(), other.encryptionKey())
                && Objects.equals(allowProfileCreation(), other.allowProfileCreation())
                && Objects.equals(sourceLastUpdatedTimestampFormat(), other.sourceLastUpdatedTimestampFormat())
                && hasFields() == other.hasFields() && Objects.equals(fields(), other.fields()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutProfileObjectTypeRequest").add("DomainName", domainName())
                .add("ObjectTypeName", objectTypeName()).add("Description", description()).add("TemplateId", templateId())
                .add("ExpirationDays", expirationDays()).add("EncryptionKey", encryptionKey())
                .add("AllowProfileCreation", allowProfileCreation())
                .add("SourceLastUpdatedTimestampFormat", sourceLastUpdatedTimestampFormat())
                .add("Fields", hasFields() ? fields() : null).add("Keys", hasKeys() ? keys() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "ExpirationDays":
            return Optional.ofNullable(clazz.cast(expirationDays()));
        case "EncryptionKey":
            return Optional.ofNullable(clazz.cast(encryptionKey()));
        case "AllowProfileCreation":
            return Optional.ofNullable(clazz.cast(allowProfileCreation()));
        case "SourceLastUpdatedTimestampFormat":
            return Optional.ofNullable(clazz.cast(sourceLastUpdatedTimestampFormat()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutProfileObjectTypeRequest, T> g) {
        return obj -> g.apply((PutProfileObjectTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutProfileObjectTypeRequest> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the profile object type.
         * </p>
         * 
         * @param objectTypeName
         *        The name of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * Description of the profile object type.
         * </p>
         * 
         * @param description
         *        Description of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A unique identifier for the object template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The number of days until the data in the object expires.
         * </p>
         * 
         * @param expirationDays
         *        The number of days until the data in the object expires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDays(Integer expirationDays);

        /**
         * <p>
         * The customer-provided key to encrypt the profile object that will be created in this profile object type.
         * </p>
         * 
         * @param encryptionKey
         *        The customer-provided key to encrypt the profile object that will be created in this profile object
         *        type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionKey(String encryptionKey);

        /**
         * <p>
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
         * this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>,
         * then the service tries to fetch a standard profile and associate this object with the profile. If it is set
         * to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
         * </p>
         * 
         * @param allowProfileCreation
         *        Indicates whether a profile should be created when data is received if one doesn’t exist for an object
         *        of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
         *        <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with
         *        the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a
         *        new standard profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowProfileCreation(Boolean allowProfileCreation);

        /**
         * <p>
         * The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.
         * </p>
         * 
         * @param sourceLastUpdatedTimestampFormat
         *        The format of your <code>sourceLastUpdatedTimestamp</code> that was previously set up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat);

        /**
         * <p>
         * A map of the name and ObjectType field.
         * </p>
         * 
         * @param fields
         *        A map of the name and ObjectType field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * A list of unique keys that can be used to map data to the profile.
         * </p>
         * 
         * @param keys
         *        A list of unique keys that can be used to map data to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String domainName;

        private String objectTypeName;

        private String description;

        private String templateId;

        private Integer expirationDays;

        private String encryptionKey;

        private Boolean allowProfileCreation;

        private String sourceLastUpdatedTimestampFormat;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutProfileObjectTypeRequest model) {
            super(model);
            domainName(model.domainName);
            objectTypeName(model.objectTypeName);
            description(model.description);
            templateId(model.templateId);
            expirationDays(model.expirationDays);
            encryptionKey(model.encryptionKey);
            allowProfileCreation(model.allowProfileCreation);
            sourceLastUpdatedTimestampFormat(model.sourceLastUpdatedTimestampFormat);
            fields(model.fields);
            keys(model.keys);
            tags(model.tags);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Integer getExpirationDays() {
            return expirationDays;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        @Override
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final String getEncryptionKey() {
            return encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Boolean getAllowProfileCreation() {
            return allowProfileCreation;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        @Override
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final String getSourceLastUpdatedTimestampFormat() {
            return sourceLastUpdatedTimestampFormat;
        }

        public final void setSourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat) {
            this.sourceLastUpdatedTimestampFormat = sourceLastUpdatedTimestampFormat;
        }

        @Override
        public final Builder sourceLastUpdatedTimestampFormat(String sourceLastUpdatedTimestampFormat) {
            this.sourceLastUpdatedTimestampFormat = sourceLastUpdatedTimestampFormat;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final Map<String, List<ObjectTypeKey.Builder>> getKeys() {
            Map<String, List<ObjectTypeKey.Builder>> result = KeyMapCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey.BuilderImpl>> keys) {
            this.keys = KeyMapCopier.copyFromBuilder(keys);
        }

        @Override
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutProfileObjectTypeRequest build() {
            return new PutProfileObjectTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
