/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List containing steps in workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkflowStepItem implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkflowStepItem.Builder, WorkflowStepItem> {
    private static final SdkField<AppflowIntegrationWorkflowStep> APPFLOW_INTEGRATION_FIELD = SdkField
            .<AppflowIntegrationWorkflowStep> builder(MarshallingType.SDK_POJO).memberName("AppflowIntegration")
            .getter(getter(WorkflowStepItem::appflowIntegration)).setter(setter(Builder::appflowIntegration))
            .constructor(AppflowIntegrationWorkflowStep::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppflowIntegration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPFLOW_INTEGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AppflowIntegrationWorkflowStep appflowIntegration;

    private WorkflowStepItem(BuilderImpl builder) {
        this.appflowIntegration = builder.appflowIntegration;
    }

    /**
     * <p>
     * Workflow step information specific to <code>APPFLOW_INTEGRATION</code> workflow.
     * </p>
     * 
     * @return Workflow step information specific to <code>APPFLOW_INTEGRATION</code> workflow.
     */
    public final AppflowIntegrationWorkflowStep appflowIntegration() {
        return appflowIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appflowIntegration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowStepItem)) {
            return false;
        }
        WorkflowStepItem other = (WorkflowStepItem) obj;
        return Objects.equals(appflowIntegration(), other.appflowIntegration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkflowStepItem").add("AppflowIntegration", appflowIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppflowIntegration":
            return Optional.ofNullable(clazz.cast(appflowIntegration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowStepItem, T> g) {
        return obj -> g.apply((WorkflowStepItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkflowStepItem> {
        /**
         * <p>
         * Workflow step information specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * 
         * @param appflowIntegration
         *        Workflow step information specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appflowIntegration(AppflowIntegrationWorkflowStep appflowIntegration);

        /**
         * <p>
         * Workflow step information specific to <code>APPFLOW_INTEGRATION</code> workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppflowIntegrationWorkflowStep.Builder}
         * avoiding the need to create one manually via {@link AppflowIntegrationWorkflowStep#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppflowIntegrationWorkflowStep.Builder#build()} is called
         * immediately and its result is passed to {@link #appflowIntegration(AppflowIntegrationWorkflowStep)}.
         * 
         * @param appflowIntegration
         *        a consumer that will call methods on {@link AppflowIntegrationWorkflowStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appflowIntegration(AppflowIntegrationWorkflowStep)
         */
        default Builder appflowIntegration(Consumer<AppflowIntegrationWorkflowStep.Builder> appflowIntegration) {
            return appflowIntegration(AppflowIntegrationWorkflowStep.builder().applyMutation(appflowIntegration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AppflowIntegrationWorkflowStep appflowIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowStepItem model) {
            appflowIntegration(model.appflowIntegration);
        }

        public final AppflowIntegrationWorkflowStep.Builder getAppflowIntegration() {
            return appflowIntegration != null ? appflowIntegration.toBuilder() : null;
        }

        public final void setAppflowIntegration(AppflowIntegrationWorkflowStep.BuilderImpl appflowIntegration) {
            this.appflowIntegration = appflowIntegration != null ? appflowIntegration.build() : null;
        }

        @Override
        public final Builder appflowIntegration(AppflowIntegrationWorkflowStep appflowIntegration) {
            this.appflowIntegration = appflowIntegration;
            return this;
        }

        @Override
        public WorkflowStepItem build() {
            return new WorkflowStepItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
