/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configurations that control how Customer Profiles retrieves data from the source, Amazon AppFlow. Customer
 * Profiles uses this information to create an AppFlow flow on behalf of customers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowDefinition implements SdkPojo, Serializable, ToCopyableBuilder<FlowDefinition.Builder, FlowDefinition> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(FlowDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FLOW_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowName").getter(getter(FlowDefinition::flowName)).setter(setter(Builder::flowName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FlowName").build()).build();

    private static final SdkField<String> KMS_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("KmsArn")
            .getter(getter(FlowDefinition::kmsArn)).setter(setter(Builder::kmsArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsArn").build()).build();

    private static final SdkField<SourceFlowConfig> SOURCE_FLOW_CONFIG_FIELD = SdkField
            .<SourceFlowConfig> builder(MarshallingType.SDK_POJO).memberName("SourceFlowConfig")
            .getter(getter(FlowDefinition::sourceFlowConfig)).setter(setter(Builder::sourceFlowConfig))
            .constructor(SourceFlowConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFlowConfig").build()).build();

    private static final SdkField<List<Task>> TASKS_FIELD = SdkField
            .<List<Task>> builder(MarshallingType.LIST)
            .memberName("Tasks")
            .getter(getter(FlowDefinition::tasks))
            .setter(setter(Builder::tasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tasks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Task> builder(MarshallingType.SDK_POJO)
                                            .constructor(Task::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TriggerConfig> TRIGGER_CONFIG_FIELD = SdkField
            .<TriggerConfig> builder(MarshallingType.SDK_POJO).memberName("TriggerConfig")
            .getter(getter(FlowDefinition::triggerConfig)).setter(setter(Builder::triggerConfig))
            .constructor(TriggerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TriggerConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            FLOW_NAME_FIELD, KMS_ARN_FIELD, SOURCE_FLOW_CONFIG_FIELD, TASKS_FIELD, TRIGGER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String flowName;

    private final String kmsArn;

    private final SourceFlowConfig sourceFlowConfig;

    private final List<Task> tasks;

    private final TriggerConfig triggerConfig;

    private FlowDefinition(BuilderImpl builder) {
        this.description = builder.description;
        this.flowName = builder.flowName;
        this.kmsArn = builder.kmsArn;
        this.sourceFlowConfig = builder.sourceFlowConfig;
        this.tasks = builder.tasks;
        this.triggerConfig = builder.triggerConfig;
    }

    /**
     * <p>
     * A description of the flow you want to create.
     * </p>
     * 
     * @return A description of the flow you want to create.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
     * </p>
     * 
     * @return The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
     */
    public final String flowName() {
        return flowName;
    }

    /**
     * <p>
     * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
     * </p>
     * 
     * @return The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
     */
    public final String kmsArn() {
        return kmsArn;
    }

    /**
     * <p>
     * The configuration that controls how Customer Profiles retrieves data from the source.
     * </p>
     * 
     * @return The configuration that controls how Customer Profiles retrieves data from the source.
     */
    public final SourceFlowConfig sourceFlowConfig() {
        return sourceFlowConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tasks property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTasks() {
        return tasks != null && !(tasks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTasks} method.
     * </p>
     * 
     * @return A list of tasks that Customer Profiles performs while transferring the data in the flow run.
     */
    public final List<Task> tasks() {
        return tasks;
    }

    /**
     * <p>
     * The trigger settings that determine how and when the flow runs.
     * </p>
     * 
     * @return The trigger settings that determine how and when the flow runs.
     */
    public final TriggerConfig triggerConfig() {
        return triggerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(flowName());
        hashCode = 31 * hashCode + Objects.hashCode(kmsArn());
        hashCode = 31 * hashCode + Objects.hashCode(sourceFlowConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTasks() ? tasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(triggerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowDefinition)) {
            return false;
        }
        FlowDefinition other = (FlowDefinition) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(flowName(), other.flowName())
                && Objects.equals(kmsArn(), other.kmsArn()) && Objects.equals(sourceFlowConfig(), other.sourceFlowConfig())
                && hasTasks() == other.hasTasks() && Objects.equals(tasks(), other.tasks())
                && Objects.equals(triggerConfig(), other.triggerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowDefinition").add("Description", description()).add("FlowName", flowName())
                .add("KmsArn", kmsArn()).add("SourceFlowConfig", sourceFlowConfig()).add("Tasks", hasTasks() ? tasks() : null)
                .add("TriggerConfig", triggerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FlowName":
            return Optional.ofNullable(clazz.cast(flowName()));
        case "KmsArn":
            return Optional.ofNullable(clazz.cast(kmsArn()));
        case "SourceFlowConfig":
            return Optional.ofNullable(clazz.cast(sourceFlowConfig()));
        case "Tasks":
            return Optional.ofNullable(clazz.cast(tasks()));
        case "TriggerConfig":
            return Optional.ofNullable(clazz.cast(triggerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowDefinition, T> g) {
        return obj -> g.apply((FlowDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowDefinition> {
        /**
         * <p>
         * A description of the flow you want to create.
         * </p>
         * 
         * @param description
         *        A description of the flow you want to create.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
         * </p>
         * 
         * @param flowName
         *        The specified name of the flow. Use underscores (_) or hyphens (-) only. Spaces are not allowed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowName(String flowName);

        /**
         * <p>
         * The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
         * </p>
         * 
         * @param kmsArn
         *        The Amazon Resource Name of the AWS Key Management Service (KMS) key you provide for encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsArn(String kmsArn);

        /**
         * <p>
         * The configuration that controls how Customer Profiles retrieves data from the source.
         * </p>
         * 
         * @param sourceFlowConfig
         *        The configuration that controls how Customer Profiles retrieves data from the source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig);

        /**
         * <p>
         * The configuration that controls how Customer Profiles retrieves data from the source.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceFlowConfig.Builder} avoiding the
         * need to create one manually via {@link SourceFlowConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceFlowConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceFlowConfig(SourceFlowConfig)}.
         * 
         * @param sourceFlowConfig
         *        a consumer that will call methods on {@link SourceFlowConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceFlowConfig(SourceFlowConfig)
         */
        default Builder sourceFlowConfig(Consumer<SourceFlowConfig.Builder> sourceFlowConfig) {
            return sourceFlowConfig(SourceFlowConfig.builder().applyMutation(sourceFlowConfig).build());
        }

        /**
         * <p>
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Collection<Task> tasks);

        /**
         * <p>
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * </p>
         * 
         * @param tasks
         *        A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tasks(Task... tasks);

        /**
         * <p>
         * A list of tasks that Customer Profiles performs while transferring the data in the flow run.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Task>.Builder} avoiding the need to
         * create one manually via {@link List<Task>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Task>.Builder#build()} is called immediately and its result
         * is passed to {@link #tasks(List<Task>)}.
         * 
         * @param tasks
         *        a consumer that will call methods on {@link List<Task>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tasks(List<Task>)
         */
        Builder tasks(Consumer<Task.Builder>... tasks);

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * 
         * @param triggerConfig
         *        The trigger settings that determine how and when the flow runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggerConfig(TriggerConfig triggerConfig);

        /**
         * <p>
         * The trigger settings that determine how and when the flow runs.
         * </p>
         * This is a convenience method that creates an instance of the {@link TriggerConfig.Builder} avoiding the need
         * to create one manually via {@link TriggerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link TriggerConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #triggerConfig(TriggerConfig)}.
         * 
         * @param triggerConfig
         *        a consumer that will call methods on {@link TriggerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggerConfig(TriggerConfig)
         */
        default Builder triggerConfig(Consumer<TriggerConfig.Builder> triggerConfig) {
            return triggerConfig(TriggerConfig.builder().applyMutation(triggerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String flowName;

        private String kmsArn;

        private SourceFlowConfig sourceFlowConfig;

        private List<Task> tasks = DefaultSdkAutoConstructList.getInstance();

        private TriggerConfig triggerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowDefinition model) {
            description(model.description);
            flowName(model.flowName);
            kmsArn(model.kmsArn);
            sourceFlowConfig(model.sourceFlowConfig);
            tasks(model.tasks);
            triggerConfig(model.triggerConfig);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFlowName() {
            return flowName;
        }

        public final void setFlowName(String flowName) {
            this.flowName = flowName;
        }

        @Override
        public final Builder flowName(String flowName) {
            this.flowName = flowName;
            return this;
        }

        public final String getKmsArn() {
            return kmsArn;
        }

        public final void setKmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
        }

        @Override
        public final Builder kmsArn(String kmsArn) {
            this.kmsArn = kmsArn;
            return this;
        }

        public final SourceFlowConfig.Builder getSourceFlowConfig() {
            return sourceFlowConfig != null ? sourceFlowConfig.toBuilder() : null;
        }

        public final void setSourceFlowConfig(SourceFlowConfig.BuilderImpl sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig != null ? sourceFlowConfig.build() : null;
        }

        @Override
        public final Builder sourceFlowConfig(SourceFlowConfig sourceFlowConfig) {
            this.sourceFlowConfig = sourceFlowConfig;
            return this;
        }

        public final List<Task.Builder> getTasks() {
            List<Task.Builder> result = TasksCopier.copyToBuilder(this.tasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTasks(Collection<Task.BuilderImpl> tasks) {
            this.tasks = TasksCopier.copyFromBuilder(tasks);
        }

        @Override
        public final Builder tasks(Collection<Task> tasks) {
            this.tasks = TasksCopier.copy(tasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Task... tasks) {
            tasks(Arrays.asList(tasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tasks(Consumer<Task.Builder>... tasks) {
            tasks(Stream.of(tasks).map(c -> Task.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TriggerConfig.Builder getTriggerConfig() {
            return triggerConfig != null ? triggerConfig.toBuilder() : null;
        }

        public final void setTriggerConfig(TriggerConfig.BuilderImpl triggerConfig) {
            this.triggerConfig = triggerConfig != null ? triggerConfig.build() : null;
        }

        @Override
        public final Builder triggerConfig(TriggerConfig triggerConfig) {
            this.triggerConfig = triggerConfig;
            return this;
        }

        @Override
        public FlowDefinition build() {
            return new FlowDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
