/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration data for integration workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IntegrationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<IntegrationConfig.Builder, IntegrationConfig> {
    private static final SdkField<AppflowIntegration> APPFLOW_INTEGRATION_FIELD = SdkField
            .<AppflowIntegration> builder(MarshallingType.SDK_POJO).memberName("AppflowIntegration")
            .getter(getter(IntegrationConfig::appflowIntegration)).setter(setter(Builder::appflowIntegration))
            .constructor(AppflowIntegration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppflowIntegration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPFLOW_INTEGRATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final AppflowIntegration appflowIntegration;

    private IntegrationConfig(BuilderImpl builder) {
        this.appflowIntegration = builder.appflowIntegration;
    }

    /**
     * <p>
     * Configuration data for <code>APPFLOW_INTEGRATION</code> workflow type.
     * </p>
     * 
     * @return Configuration data for <code>APPFLOW_INTEGRATION</code> workflow type.
     */
    public final AppflowIntegration appflowIntegration() {
        return appflowIntegration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appflowIntegration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegrationConfig)) {
            return false;
        }
        IntegrationConfig other = (IntegrationConfig) obj;
        return Objects.equals(appflowIntegration(), other.appflowIntegration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IntegrationConfig").add("AppflowIntegration", appflowIntegration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppflowIntegration":
            return Optional.ofNullable(clazz.cast(appflowIntegration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IntegrationConfig, T> g) {
        return obj -> g.apply((IntegrationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IntegrationConfig> {
        /**
         * <p>
         * Configuration data for <code>APPFLOW_INTEGRATION</code> workflow type.
         * </p>
         * 
         * @param appflowIntegration
         *        Configuration data for <code>APPFLOW_INTEGRATION</code> workflow type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appflowIntegration(AppflowIntegration appflowIntegration);

        /**
         * <p>
         * Configuration data for <code>APPFLOW_INTEGRATION</code> workflow type.
         * </p>
         * This is a convenience method that creates an instance of the {@link AppflowIntegration.Builder} avoiding the
         * need to create one manually via {@link AppflowIntegration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AppflowIntegration.Builder#build()} is called immediately and its
         * result is passed to {@link #appflowIntegration(AppflowIntegration)}.
         * 
         * @param appflowIntegration
         *        a consumer that will call methods on {@link AppflowIntegration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appflowIntegration(AppflowIntegration)
         */
        default Builder appflowIntegration(Consumer<AppflowIntegration.Builder> appflowIntegration) {
            return appflowIntegration(AppflowIntegration.builder().applyMutation(appflowIntegration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AppflowIntegration appflowIntegration;

        private BuilderImpl() {
        }

        private BuilderImpl(IntegrationConfig model) {
            appflowIntegration(model.appflowIntegration);
        }

        public final AppflowIntegration.Builder getAppflowIntegration() {
            return appflowIntegration != null ? appflowIntegration.toBuilder() : null;
        }

        public final void setAppflowIntegration(AppflowIntegration.BuilderImpl appflowIntegration) {
            this.appflowIntegration = appflowIntegration != null ? appflowIntegration.build() : null;
        }

        @Override
        public final Builder appflowIntegration(AppflowIntegration appflowIntegration) {
            this.appflowIntegration = appflowIntegration;
            return this;
        }

        @Override
        public IntegrationConfig build() {
            return new IntegrationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
