/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A ProfileObjectTypeTemplate in a list of ProfileObjectTypeTemplates.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProfileObjectTypeTemplateItem implements SdkPojo, Serializable,
        ToCopyableBuilder<ListProfileObjectTypeTemplateItem.Builder, ListProfileObjectTypeTemplateItem> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(ListProfileObjectTypeTemplateItem::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(ListProfileObjectTypeTemplateItem::sourceName))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()).build();

    private static final SdkField<String> SOURCE_OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceObject").getter(getter(ListProfileObjectTypeTemplateItem::sourceObject))
            .setter(setter(Builder::sourceObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObject").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD,
            SOURCE_NAME_FIELD, SOURCE_OBJECT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String templateId;

    private final String sourceName;

    private final String sourceObject;

    private ListProfileObjectTypeTemplateItem(BuilderImpl builder) {
        this.templateId = builder.templateId;
        this.sourceName = builder.sourceName;
        this.sourceObject = builder.sourceObject;
    }

    /**
     * <p>
     * A unique identifier for the object template.
     * </p>
     * 
     * @return A unique identifier for the object template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the source of the object template.
     * </p>
     * 
     * @return The name of the source of the object template.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The source of the object template.
     * </p>
     * 
     * @return The source of the object template.
     */
    public final String sourceObject() {
        return sourceObject;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceObject());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProfileObjectTypeTemplateItem)) {
            return false;
        }
        ListProfileObjectTypeTemplateItem other = (ListProfileObjectTypeTemplateItem) obj;
        return Objects.equals(templateId(), other.templateId()) && Objects.equals(sourceName(), other.sourceName())
                && Objects.equals(sourceObject(), other.sourceObject());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListProfileObjectTypeTemplateItem").add("TemplateId", templateId())
                .add("SourceName", sourceName()).add("SourceObject", sourceObject()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "SourceObject":
            return Optional.ofNullable(clazz.cast(sourceObject()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProfileObjectTypeTemplateItem, T> g) {
        return obj -> g.apply((ListProfileObjectTypeTemplateItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListProfileObjectTypeTemplateItem> {
        /**
         * <p>
         * A unique identifier for the object template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the source of the object template.
         * </p>
         * 
         * @param sourceName
         *        The name of the source of the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The source of the object template.
         * </p>
         * 
         * @param sourceObject
         *        The source of the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceObject(String sourceObject);
    }

    static final class BuilderImpl implements Builder {
        private String templateId;

        private String sourceName;

        private String sourceObject;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProfileObjectTypeTemplateItem model) {
            templateId(model.templateId);
            sourceName(model.sourceName);
            sourceObject(model.sourceObject);
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        @Transient
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        @Transient
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceObject() {
            return sourceObject;
        }

        public final void setSourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
        }

        @Override
        @Transient
        public final Builder sourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
            return this;
        }

        @Override
        public ListProfileObjectTypeTemplateItem build() {
            return new ListProfileObjectTypeTemplateItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
