/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines the Key element of a ProfileObject. A Key is a special element that can be used to search for
 * a customer profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ObjectTypeKey implements SdkPojo, Serializable, ToCopyableBuilder<ObjectTypeKey.Builder, ObjectTypeKey> {
    private static final SdkField<List<String>> STANDARD_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("StandardIdentifiers")
            .getter(getter(ObjectTypeKey::standardIdentifiersAsStrings))
            .setter(setter(Builder::standardIdentifiersWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardIdentifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FIELD_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("FieldNames")
            .getter(getter(ObjectTypeKey::fieldNames))
            .setter(setter(Builder::fieldNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STANDARD_IDENTIFIERS_FIELD,
            FIELD_NAMES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> standardIdentifiers;

    private final List<String> fieldNames;

    private ObjectTypeKey(BuilderImpl builder) {
        this.standardIdentifiers = builder.standardIdentifiers;
        this.fieldNames = builder.fieldNames;
    }

    /**
     * <p>
     * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
     * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or CASE
     * respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY,
     * it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only
     * used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used
     * if the profile does not already exist before the object is ingested, otherwise it is only used for matching
     * objects to profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardIdentifiers} method.
     * </p>
     * 
     * @return The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
     *         multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
     *         PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If
     *         a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have
     *         been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for
     *         searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the
     *         object is ingested, otherwise it is only used for matching objects to profiles.
     */
    public final List<StandardIdentifier> standardIdentifiers() {
        return StandardIdentifierListCopier.copyStringToEnum(standardIdentifiers);
    }

    /**
     * For responses, this returns true if the service returned a value for the StandardIdentifiers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStandardIdentifiers() {
        return standardIdentifiers != null && !(standardIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
     * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or CASE
     * respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as SECONDARY,
     * it will be used to search for profiles after all other PROFILE keys have been searched. A LOOKUP_ONLY key is only
     * used to match a profile but is not persisted to be used for searching of the profile. A NEW_ONLY key is only used
     * if the profile does not already exist before the object is ingested, otherwise it is only used for matching
     * objects to profiles.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStandardIdentifiers} method.
     * </p>
     * 
     * @return The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
     *         multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
     *         PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If
     *         a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys have
     *         been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for
     *         searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before the
     *         object is ingested, otherwise it is only used for matching objects to profiles.
     */
    public final List<String> standardIdentifiersAsStrings() {
        return standardIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldNames property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldNames() {
        return fieldNames != null && !(fieldNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reference for the key name of the fields map.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldNames} method.
     * </p>
     * 
     * @return The reference for the key name of the fields map.
     */
    public final List<String> fieldNames() {
        return fieldNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasStandardIdentifiers() ? standardIdentifiersAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldNames() ? fieldNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ObjectTypeKey)) {
            return false;
        }
        ObjectTypeKey other = (ObjectTypeKey) obj;
        return hasStandardIdentifiers() == other.hasStandardIdentifiers()
                && Objects.equals(standardIdentifiersAsStrings(), other.standardIdentifiersAsStrings())
                && hasFieldNames() == other.hasFieldNames() && Objects.equals(fieldNames(), other.fieldNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ObjectTypeKey")
                .add("StandardIdentifiers", hasStandardIdentifiers() ? standardIdentifiersAsStrings() : null)
                .add("FieldNames", hasFieldNames() ? fieldNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StandardIdentifiers":
            return Optional.ofNullable(clazz.cast(standardIdentifiersAsStrings()));
        case "FieldNames":
            return Optional.ofNullable(clazz.cast(fieldNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ObjectTypeKey, T> g) {
        return obj -> g.apply((ObjectTypeKey) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ObjectTypeKey> {
        /**
         * <p>
         * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
         * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or
         * CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as
         * SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A
         * LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile.
         * A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it
         * is only used for matching objects to profiles.
         * </p>
         * 
         * @param standardIdentifiers
         *        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
         *        multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
         *        PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
         *        If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys
         *        have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used
         *        for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before
         *        the object is ingested, otherwise it is only used for matching objects to profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardIdentifiersWithStrings(Collection<String> standardIdentifiers);

        /**
         * <p>
         * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
         * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or
         * CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as
         * SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A
         * LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile.
         * A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it
         * is only used for matching objects to profiles.
         * </p>
         * 
         * @param standardIdentifiers
         *        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
         *        multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
         *        PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
         *        If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys
         *        have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used
         *        for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before
         *        the object is ingested, otherwise it is only used for matching objects to profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardIdentifiersWithStrings(String... standardIdentifiers);

        /**
         * <p>
         * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
         * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or
         * CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as
         * SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A
         * LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile.
         * A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it
         * is only used for matching objects to profiles.
         * </p>
         * 
         * @param standardIdentifiers
         *        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
         *        multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
         *        PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
         *        If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys
         *        have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used
         *        for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before
         *        the object is ingested, otherwise it is only used for matching objects to profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardIdentifiers(Collection<StandardIdentifier> standardIdentifiers);

        /**
         * <p>
         * The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but multiple
         * PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a PROFILE, ASSET or
         * CASE respectively. UNIQUE means that it can be used to uniquely identify an object. If a key a is marked as
         * SECONDARY, it will be used to search for profiles after all other PROFILE keys have been searched. A
         * LOOKUP_ONLY key is only used to match a profile but is not persisted to be used for searching of the profile.
         * A NEW_ONLY key is only used if the profile does not already exist before the object is ingested, otherwise it
         * is only used for matching objects to profiles.
         * </p>
         * 
         * @param standardIdentifiers
         *        The types of keys that a ProfileObject can have. Each ProfileObject can have only 1 UNIQUE key but
         *        multiple PROFILE keys. PROFILE, ASSET or CASE means that this key can be used to tie an object to a
         *        PROFILE, ASSET or CASE respectively. UNIQUE means that it can be used to uniquely identify an object.
         *        If a key a is marked as SECONDARY, it will be used to search for profiles after all other PROFILE keys
         *        have been searched. A LOOKUP_ONLY key is only used to match a profile but is not persisted to be used
         *        for searching of the profile. A NEW_ONLY key is only used if the profile does not already exist before
         *        the object is ingested, otherwise it is only used for matching objects to profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardIdentifiers(StandardIdentifier... standardIdentifiers);

        /**
         * <p>
         * The reference for the key name of the fields map.
         * </p>
         * 
         * @param fieldNames
         *        The reference for the key name of the fields map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(Collection<String> fieldNames);

        /**
         * <p>
         * The reference for the key name of the fields map.
         * </p>
         * 
         * @param fieldNames
         *        The reference for the key name of the fields map.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldNames(String... fieldNames);
    }

    static final class BuilderImpl implements Builder {
        private List<String> standardIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> fieldNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ObjectTypeKey model) {
            standardIdentifiersWithStrings(model.standardIdentifiers);
            fieldNames(model.fieldNames);
        }

        public final Collection<String> getStandardIdentifiers() {
            if (standardIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return standardIdentifiers;
        }

        public final void setStandardIdentifiers(Collection<String> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copy(standardIdentifiers);
        }

        @Override
        @Transient
        public final Builder standardIdentifiersWithStrings(Collection<String> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copy(standardIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder standardIdentifiersWithStrings(String... standardIdentifiers) {
            standardIdentifiersWithStrings(Arrays.asList(standardIdentifiers));
            return this;
        }

        @Override
        @Transient
        public final Builder standardIdentifiers(Collection<StandardIdentifier> standardIdentifiers) {
            this.standardIdentifiers = StandardIdentifierListCopier.copyEnumToString(standardIdentifiers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder standardIdentifiers(StandardIdentifier... standardIdentifiers) {
            standardIdentifiers(Arrays.asList(standardIdentifiers));
            return this;
        }

        public final Collection<String> getFieldNames() {
            if (fieldNames instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldNames;
        }

        public final void setFieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
        }

        @Override
        @Transient
        public final Builder fieldNames(Collection<String> fieldNames) {
            this.fieldNames = FieldNameListCopier.copy(fieldNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder fieldNames(String... fieldNames) {
            fieldNames(Arrays.asList(fieldNames));
            return this;
        }

        @Override
        public ObjectTypeKey build() {
            return new ObjectTypeKey(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
