/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMatchesResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetMatchesResponse.Builder, GetMatchesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetMatchesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Instant> MATCH_GENERATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("MatchGenerationDate").getter(getter(GetMatchesResponse::matchGenerationDate))
            .setter(setter(Builder::matchGenerationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchGenerationDate").build())
            .build();

    private static final SdkField<Integer> POTENTIAL_MATCHES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PotentialMatches").getter(getter(GetMatchesResponse::potentialMatches))
            .setter(setter(Builder::potentialMatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PotentialMatches").build()).build();

    private static final SdkField<List<MatchItem>> MATCHES_FIELD = SdkField
            .<List<MatchItem>> builder(MarshallingType.LIST)
            .memberName("Matches")
            .getter(getter(GetMatchesResponse::matches))
            .setter(setter(Builder::matches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Matches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MatchItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(MatchItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MATCH_GENERATION_DATE_FIELD, POTENTIAL_MATCHES_FIELD, MATCHES_FIELD));

    private final String nextToken;

    private final Instant matchGenerationDate;

    private final Integer potentialMatches;

    private final List<MatchItem> matches;

    private GetMatchesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.matchGenerationDate = builder.matchGenerationDate;
        this.potentialMatches = builder.potentialMatches;
        this.matches = builder.matches;
    }

    /**
     * <p>
     * If there are additional results, this is the token for the next set of results.
     * </p>
     * 
     * @return If there are additional results, this is the token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The timestamp this version of Match Result generated.
     * </p>
     * 
     * @return The timestamp this version of Match Result generated.
     */
    public final Instant matchGenerationDate() {
        return matchGenerationDate;
    }

    /**
     * <p>
     * The number of potential matches found.
     * </p>
     * 
     * @return The number of potential matches found.
     */
    public final Integer potentialMatches() {
        return potentialMatches;
    }

    /**
     * For responses, this returns true if the service returned a value for the Matches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMatches() {
        return matches != null && !(matches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of matched profiles for this instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMatches} method.
     * </p>
     * 
     * @return The list of matched profiles for this instance.
     */
    public final List<MatchItem> matches() {
        return matches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(matchGenerationDate());
        hashCode = 31 * hashCode + Objects.hashCode(potentialMatches());
        hashCode = 31 * hashCode + Objects.hashCode(hasMatches() ? matches() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMatchesResponse)) {
            return false;
        }
        GetMatchesResponse other = (GetMatchesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(matchGenerationDate(), other.matchGenerationDate())
                && Objects.equals(potentialMatches(), other.potentialMatches()) && hasMatches() == other.hasMatches()
                && Objects.equals(matches(), other.matches());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetMatchesResponse").add("NextToken", nextToken())
                .add("MatchGenerationDate", matchGenerationDate()).add("PotentialMatches", potentialMatches())
                .add("Matches", hasMatches() ? matches() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MatchGenerationDate":
            return Optional.ofNullable(clazz.cast(matchGenerationDate()));
        case "PotentialMatches":
            return Optional.ofNullable(clazz.cast(potentialMatches()));
        case "Matches":
            return Optional.ofNullable(clazz.cast(matches()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMatchesResponse, T> g) {
        return obj -> g.apply((GetMatchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMatchesResponse> {
        /**
         * <p>
         * If there are additional results, this is the token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If there are additional results, this is the token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The timestamp this version of Match Result generated.
         * </p>
         * 
         * @param matchGenerationDate
         *        The timestamp this version of Match Result generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matchGenerationDate(Instant matchGenerationDate);

        /**
         * <p>
         * The number of potential matches found.
         * </p>
         * 
         * @param potentialMatches
         *        The number of potential matches found.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder potentialMatches(Integer potentialMatches);

        /**
         * <p>
         * The list of matched profiles for this instance.
         * </p>
         * 
         * @param matches
         *        The list of matched profiles for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(Collection<MatchItem> matches);

        /**
         * <p>
         * The list of matched profiles for this instance.
         * </p>
         * 
         * @param matches
         *        The list of matched profiles for this instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder matches(MatchItem... matches);

        /**
         * <p>
         * The list of matched profiles for this instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MatchItem>.Builder} avoiding the need to
         * create one manually via {@link List<MatchItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MatchItem>.Builder#build()} is called immediately and its
         * result is passed to {@link #matches(List<MatchItem>)}.
         * 
         * @param matches
         *        a consumer that will call methods on {@link List<MatchItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #matches(List<MatchItem>)
         */
        Builder matches(Consumer<MatchItem.Builder>... matches);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String nextToken;

        private Instant matchGenerationDate;

        private Integer potentialMatches;

        private List<MatchItem> matches = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetMatchesResponse model) {
            super(model);
            nextToken(model.nextToken);
            matchGenerationDate(model.matchGenerationDate);
            potentialMatches(model.potentialMatches);
            matches(model.matches);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getMatchGenerationDate() {
            return matchGenerationDate;
        }

        public final void setMatchGenerationDate(Instant matchGenerationDate) {
            this.matchGenerationDate = matchGenerationDate;
        }

        @Override
        @Transient
        public final Builder matchGenerationDate(Instant matchGenerationDate) {
            this.matchGenerationDate = matchGenerationDate;
            return this;
        }

        public final Integer getPotentialMatches() {
            return potentialMatches;
        }

        public final void setPotentialMatches(Integer potentialMatches) {
            this.potentialMatches = potentialMatches;
        }

        @Override
        @Transient
        public final Builder potentialMatches(Integer potentialMatches) {
            this.potentialMatches = potentialMatches;
            return this;
        }

        public final List<MatchItem.Builder> getMatches() {
            List<MatchItem.Builder> result = MatchesListCopier.copyToBuilder(this.matches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMatches(Collection<MatchItem.BuilderImpl> matches) {
            this.matches = MatchesListCopier.copyFromBuilder(matches);
        }

        @Override
        @Transient
        public final Builder matches(Collection<MatchItem> matches) {
            this.matches = MatchesListCopier.copy(matches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder matches(MatchItem... matches) {
            matches(Arrays.asList(matches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder matches(Consumer<MatchItem.Builder>... matches) {
            matches(Stream.of(matches).map(c -> MatchItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetMatchesResponse build() {
            return new GetMatchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
