/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileObjectTypeTemplateResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetProfileObjectTypeTemplateResponse.Builder, GetProfileObjectTypeTemplateResponse> {
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(GetProfileObjectTypeTemplateResponse::templateId))
            .setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<String> SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceName").getter(getter(GetProfileObjectTypeTemplateResponse::sourceName))
            .setter(setter(Builder::sourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceName").build()).build();

    private static final SdkField<String> SOURCE_OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceObject").getter(getter(GetProfileObjectTypeTemplateResponse::sourceObject))
            .setter(setter(Builder::sourceObject))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceObject").build()).build();

    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowProfileCreation").getter(getter(GetProfileObjectTypeTemplateResponse::allowProfileCreation))
            .setter(setter(Builder::allowProfileCreation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build())
            .build();

    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField
            .<Map<String, ObjectTypeField>> builder(MarshallingType.MAP)
            .memberName("Fields")
            .getter(getter(GetProfileObjectTypeTemplateResponse::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ObjectTypeField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ObjectTypeField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField
            .<Map<String, List<ObjectTypeKey>>> builder(MarshallingType.MAP)
            .memberName("Keys")
            .getter(getter(GetProfileObjectTypeTemplateResponse::keys))
            .setter(setter(Builder::keys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ObjectTypeKey>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ObjectTypeKey> builder(MarshallingType.SDK_POJO)
                                                                            .constructor(ObjectTypeKey::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_ID_FIELD,
            SOURCE_NAME_FIELD, SOURCE_OBJECT_FIELD, ALLOW_PROFILE_CREATION_FIELD, FIELDS_FIELD, KEYS_FIELD));

    private final String templateId;

    private final String sourceName;

    private final String sourceObject;

    private final Boolean allowProfileCreation;

    private final Map<String, ObjectTypeField> fields;

    private final Map<String, List<ObjectTypeKey>> keys;

    private GetProfileObjectTypeTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateId = builder.templateId;
        this.sourceName = builder.sourceName;
        this.sourceObject = builder.sourceObject;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.fields = builder.fields;
        this.keys = builder.keys;
    }

    /**
     * <p>
     * A unique identifier for the object template.
     * </p>
     * 
     * @return A unique identifier for the object template.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * The name of the source of the object template.
     * </p>
     * 
     * @return The name of the source of the object template.
     */
    public final String sourceName() {
        return sourceName;
    }

    /**
     * <p>
     * The source of the object template.
     * </p>
     * 
     * @return The source of the object template.
     */
    public final String sourceObject() {
        return sourceObject;
    }

    /**
     * <p>
     * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of this
     * type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>, then the
     * service tries to fetch a standard profile and associate this object with the profile. If it is set to
     * <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
     * </p>
     * 
     * @return Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
     *         this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
     *         <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with the
     *         profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a new
     *         standard profile.
     */
    public final Boolean allowProfileCreation() {
        return allowProfileCreation;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fields property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map of the name and ObjectType field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFields} method.
     * </p>
     * 
     * @return A map of the name and ObjectType field.
     */
    public final Map<String, ObjectTypeField> fields() {
        return fields;
    }

    /**
     * For responses, this returns true if the service returned a value for the Keys property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasKeys() {
        return keys != null && !(keys instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of unique keys that can be used to map data to the profile.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasKeys} method.
     * </p>
     * 
     * @return A list of unique keys that can be used to map data to the profile.
     */
    public final Map<String, List<ObjectTypeKey>> keys() {
        return keys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceObject());
        hashCode = 31 * hashCode + Objects.hashCode(allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(hasFields() ? fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeys() ? keys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileObjectTypeTemplateResponse)) {
            return false;
        }
        GetProfileObjectTypeTemplateResponse other = (GetProfileObjectTypeTemplateResponse) obj;
        return Objects.equals(templateId(), other.templateId()) && Objects.equals(sourceName(), other.sourceName())
                && Objects.equals(sourceObject(), other.sourceObject())
                && Objects.equals(allowProfileCreation(), other.allowProfileCreation()) && hasFields() == other.hasFields()
                && Objects.equals(fields(), other.fields()) && hasKeys() == other.hasKeys()
                && Objects.equals(keys(), other.keys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileObjectTypeTemplateResponse").add("TemplateId", templateId())
                .add("SourceName", sourceName()).add("SourceObject", sourceObject())
                .add("AllowProfileCreation", allowProfileCreation()).add("Fields", hasFields() ? fields() : null)
                .add("Keys", hasKeys() ? keys() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "SourceName":
            return Optional.ofNullable(clazz.cast(sourceName()));
        case "SourceObject":
            return Optional.ofNullable(clazz.cast(sourceObject()));
        case "AllowProfileCreation":
            return Optional.ofNullable(clazz.cast(allowProfileCreation()));
        case "Fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "Keys":
            return Optional.ofNullable(clazz.cast(keys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileObjectTypeTemplateResponse, T> g) {
        return obj -> g.apply((GetProfileObjectTypeTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetProfileObjectTypeTemplateResponse> {
        /**
         * <p>
         * A unique identifier for the object template.
         * </p>
         * 
         * @param templateId
         *        A unique identifier for the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * The name of the source of the object template.
         * </p>
         * 
         * @param sourceName
         *        The name of the source of the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceName(String sourceName);

        /**
         * <p>
         * The source of the object template.
         * </p>
         * 
         * @param sourceObject
         *        The source of the object template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceObject(String sourceObject);

        /**
         * <p>
         * Indicates whether a profile should be created when data is received if one doesn’t exist for an object of
         * this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to <code>FALSE</code>,
         * then the service tries to fetch a standard profile and associate this object with the profile. If it is set
         * to <code>TRUE</code>, and if no match is found, then the service creates a new standard profile.
         * </p>
         * 
         * @param allowProfileCreation
         *        Indicates whether a profile should be created when data is received if one doesn’t exist for an object
         *        of this type. The default is <code>FALSE</code>. If the AllowProfileCreation flag is set to
         *        <code>FALSE</code>, then the service tries to fetch a standard profile and associate this object with
         *        the profile. If it is set to <code>TRUE</code>, and if no match is found, then the service creates a
         *        new standard profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowProfileCreation(Boolean allowProfileCreation);

        /**
         * <p>
         * A map of the name and ObjectType field.
         * </p>
         * 
         * @param fields
         *        A map of the name and ObjectType field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ObjectTypeField> fields);

        /**
         * <p>
         * A list of unique keys that can be used to map data to the profile.
         * </p>
         * 
         * @param keys
         *        A list of unique keys that can be used to map data to the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String templateId;

        private String sourceName;

        private String sourceObject;

        private Boolean allowProfileCreation;

        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileObjectTypeTemplateResponse model) {
            super(model);
            templateId(model.templateId);
            sourceName(model.sourceName);
            sourceObject(model.sourceObject);
            allowProfileCreation(model.allowProfileCreation);
            fields(model.fields);
            keys(model.keys);
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        @Transient
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getSourceName() {
            return sourceName;
        }

        public final void setSourceName(String sourceName) {
            this.sourceName = sourceName;
        }

        @Override
        @Transient
        public final Builder sourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public final String getSourceObject() {
            return sourceObject;
        }

        public final void setSourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
        }

        @Override
        @Transient
        public final Builder sourceObject(String sourceObject) {
            this.sourceObject = sourceObject;
            return this;
        }

        public final Boolean getAllowProfileCreation() {
            return allowProfileCreation;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        @Override
        @Transient
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        @Transient
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final Map<String, List<ObjectTypeKey.Builder>> getKeys() {
            Map<String, List<ObjectTypeKey.Builder>> result = KeyMapCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey.BuilderImpl>> keys) {
            this.keys = KeyMapCopier.copyFromBuilder(keys);
        }

        @Override
        @Transient
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        @Override
        public GetProfileObjectTypeTemplateResponse build() {
            return new GetProfileObjectTypeTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
