/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of the source connector used in the flow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceFlowConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceFlowConfig.Builder, SourceFlowConfig> {
    private static final SdkField<String> CONNECTOR_PROFILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorProfileName").getter(getter(SourceFlowConfig::connectorProfileName))
            .setter(setter(Builder::connectorProfileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorProfileName").build())
            .build();

    private static final SdkField<String> CONNECTOR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConnectorType").getter(getter(SourceFlowConfig::connectorTypeAsString))
            .setter(setter(Builder::connectorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorType").build()).build();

    private static final SdkField<IncrementalPullConfig> INCREMENTAL_PULL_CONFIG_FIELD = SdkField
            .<IncrementalPullConfig> builder(MarshallingType.SDK_POJO).memberName("IncrementalPullConfig")
            .getter(getter(SourceFlowConfig::incrementalPullConfig)).setter(setter(Builder::incrementalPullConfig))
            .constructor(IncrementalPullConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncrementalPullConfig").build())
            .build();

    private static final SdkField<SourceConnectorProperties> SOURCE_CONNECTOR_PROPERTIES_FIELD = SdkField
            .<SourceConnectorProperties> builder(MarshallingType.SDK_POJO).memberName("SourceConnectorProperties")
            .getter(getter(SourceFlowConfig::sourceConnectorProperties)).setter(setter(Builder::sourceConnectorProperties))
            .constructor(SourceConnectorProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceConnectorProperties").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_PROFILE_NAME_FIELD,
            CONNECTOR_TYPE_FIELD, INCREMENTAL_PULL_CONFIG_FIELD, SOURCE_CONNECTOR_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String connectorProfileName;

    private final String connectorType;

    private final IncrementalPullConfig incrementalPullConfig;

    private final SourceConnectorProperties sourceConnectorProperties;

    private SourceFlowConfig(BuilderImpl builder) {
        this.connectorProfileName = builder.connectorProfileName;
        this.connectorType = builder.connectorType;
        this.incrementalPullConfig = builder.incrementalPullConfig;
        this.sourceConnectorProperties = builder.sourceConnectorProperties;
    }

    /**
     * <p>
     * The name of the AppFlow connector profile. This name must be unique for each connector profile in the AWS
     * account.
     * </p>
     * 
     * @return The name of the AppFlow connector profile. This name must be unique for each connector profile in the AWS
     *         account.
     */
    public final String connectorProfileName() {
        return connectorProfileName;
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Marketo, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link SourceConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Marketo, and so on.
     * @see SourceConnectorType
     */
    public final SourceConnectorType connectorType() {
        return SourceConnectorType.fromValue(connectorType);
    }

    /**
     * <p>
     * The type of connector, such as Salesforce, Marketo, and so on.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectorType}
     * will return {@link SourceConnectorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectorTypeAsString}.
     * </p>
     * 
     * @return The type of connector, such as Salesforce, Marketo, and so on.
     * @see SourceConnectorType
     */
    public final String connectorTypeAsString() {
        return connectorType;
    }

    /**
     * <p>
     * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the fields
     * specified in the configuration are used when querying for the incremental data pull.
     * </p>
     * 
     * @return Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided,
     *         the fields specified in the configuration are used when querying for the incremental data pull.
     */
    public final IncrementalPullConfig incrementalPullConfig() {
        return incrementalPullConfig;
    }

    /**
     * <p>
     * Specifies the information that is required to query a particular source connector.
     * </p>
     * 
     * @return Specifies the information that is required to query a particular source connector.
     */
    public final SourceConnectorProperties sourceConnectorProperties() {
        return sourceConnectorProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(connectorTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(incrementalPullConfig());
        hashCode = 31 * hashCode + Objects.hashCode(sourceConnectorProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFlowConfig)) {
            return false;
        }
        SourceFlowConfig other = (SourceFlowConfig) obj;
        return Objects.equals(connectorProfileName(), other.connectorProfileName())
                && Objects.equals(connectorTypeAsString(), other.connectorTypeAsString())
                && Objects.equals(incrementalPullConfig(), other.incrementalPullConfig())
                && Objects.equals(sourceConnectorProperties(), other.sourceConnectorProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceFlowConfig").add("ConnectorProfileName", connectorProfileName())
                .add("ConnectorType", connectorTypeAsString()).add("IncrementalPullConfig", incrementalPullConfig())
                .add("SourceConnectorProperties", sourceConnectorProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorProfileName":
            return Optional.ofNullable(clazz.cast(connectorProfileName()));
        case "ConnectorType":
            return Optional.ofNullable(clazz.cast(connectorTypeAsString()));
        case "IncrementalPullConfig":
            return Optional.ofNullable(clazz.cast(incrementalPullConfig()));
        case "SourceConnectorProperties":
            return Optional.ofNullable(clazz.cast(sourceConnectorProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceFlowConfig, T> g) {
        return obj -> g.apply((SourceFlowConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceFlowConfig> {
        /**
         * <p>
         * The name of the AppFlow connector profile. This name must be unique for each connector profile in the AWS
         * account.
         * </p>
         * 
         * @param connectorProfileName
         *        The name of the AppFlow connector profile. This name must be unique for each connector profile in the
         *        AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorProfileName(String connectorProfileName);

        /**
         * <p>
         * The type of connector, such as Salesforce, Marketo, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Marketo, and so on.
         * @see SourceConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceConnectorType
         */
        Builder connectorType(String connectorType);

        /**
         * <p>
         * The type of connector, such as Salesforce, Marketo, and so on.
         * </p>
         * 
         * @param connectorType
         *        The type of connector, such as Salesforce, Marketo, and so on.
         * @see SourceConnectorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceConnectorType
         */
        Builder connectorType(SourceConnectorType connectorType);

        /**
         * <p>
         * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the
         * fields specified in the configuration are used when querying for the incremental data pull.
         * </p>
         * 
         * @param incrementalPullConfig
         *        Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided,
         *        the fields specified in the configuration are used when querying for the incremental data pull.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig);

        /**
         * <p>
         * Defines the configuration for a scheduled incremental data pull. If a valid configuration is provided, the
         * fields specified in the configuration are used when querying for the incremental data pull.
         * </p>
         * This is a convenience that creates an instance of the {@link IncrementalPullConfig.Builder} avoiding the need
         * to create one manually via {@link IncrementalPullConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link IncrementalPullConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #incrementalPullConfig(IncrementalPullConfig)}.
         * 
         * @param incrementalPullConfig
         *        a consumer that will call methods on {@link IncrementalPullConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incrementalPullConfig(IncrementalPullConfig)
         */
        default Builder incrementalPullConfig(Consumer<IncrementalPullConfig.Builder> incrementalPullConfig) {
            return incrementalPullConfig(IncrementalPullConfig.builder().applyMutation(incrementalPullConfig).build());
        }

        /**
         * <p>
         * Specifies the information that is required to query a particular source connector.
         * </p>
         * 
         * @param sourceConnectorProperties
         *        Specifies the information that is required to query a particular source connector.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties);

        /**
         * <p>
         * Specifies the information that is required to query a particular source connector.
         * </p>
         * This is a convenience that creates an instance of the {@link SourceConnectorProperties.Builder} avoiding the
         * need to create one manually via {@link SourceConnectorProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SourceConnectorProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceConnectorProperties(SourceConnectorProperties)}.
         * 
         * @param sourceConnectorProperties
         *        a consumer that will call methods on {@link SourceConnectorProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceConnectorProperties(SourceConnectorProperties)
         */
        default Builder sourceConnectorProperties(Consumer<SourceConnectorProperties.Builder> sourceConnectorProperties) {
            return sourceConnectorProperties(SourceConnectorProperties.builder().applyMutation(sourceConnectorProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String connectorProfileName;

        private String connectorType;

        private IncrementalPullConfig incrementalPullConfig;

        private SourceConnectorProperties sourceConnectorProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFlowConfig model) {
            connectorProfileName(model.connectorProfileName);
            connectorType(model.connectorType);
            incrementalPullConfig(model.incrementalPullConfig);
            sourceConnectorProperties(model.sourceConnectorProperties);
        }

        public final String getConnectorProfileName() {
            return connectorProfileName;
        }

        public final void setConnectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
        }

        @Override
        @Transient
        public final Builder connectorProfileName(String connectorProfileName) {
            this.connectorProfileName = connectorProfileName;
            return this;
        }

        public final String getConnectorType() {
            return connectorType;
        }

        public final void setConnectorType(String connectorType) {
            this.connectorType = connectorType;
        }

        @Override
        @Transient
        public final Builder connectorType(String connectorType) {
            this.connectorType = connectorType;
            return this;
        }

        @Override
        @Transient
        public final Builder connectorType(SourceConnectorType connectorType) {
            this.connectorType(connectorType == null ? null : connectorType.toString());
            return this;
        }

        public final IncrementalPullConfig.Builder getIncrementalPullConfig() {
            return incrementalPullConfig != null ? incrementalPullConfig.toBuilder() : null;
        }

        public final void setIncrementalPullConfig(IncrementalPullConfig.BuilderImpl incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig != null ? incrementalPullConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder incrementalPullConfig(IncrementalPullConfig incrementalPullConfig) {
            this.incrementalPullConfig = incrementalPullConfig;
            return this;
        }

        public final SourceConnectorProperties.Builder getSourceConnectorProperties() {
            return sourceConnectorProperties != null ? sourceConnectorProperties.toBuilder() : null;
        }

        public final void setSourceConnectorProperties(SourceConnectorProperties.BuilderImpl sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties != null ? sourceConnectorProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceConnectorProperties(SourceConnectorProperties sourceConnectorProperties) {
            this.sourceConnectorProperties = sourceConnectorProperties;
            return this;
        }

        @Override
        public SourceFlowConfig build() {
            return new SourceFlowConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
