/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A class for modeling different type of tasks. Task implementation varies based on the TaskType.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Task implements SdkPojo, Serializable, ToCopyableBuilder<Task.Builder, Task> {
    private static final SdkField<ConnectorOperator> CONNECTOR_OPERATOR_FIELD = SdkField
            .<ConnectorOperator> builder(MarshallingType.SDK_POJO).memberName("ConnectorOperator")
            .getter(getter(Task::connectorOperator)).setter(setter(Builder::connectorOperator))
            .constructor(ConnectorOperator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectorOperator").build()).build();

    private static final SdkField<String> DESTINATION_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationField").getter(getter(Task::destinationField)).setter(setter(Builder::destinationField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationField").build()).build();

    private static final SdkField<List<String>> SOURCE_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceFields")
            .getter(getter(Task::sourceFields))
            .setter(setter(Builder::sourceFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TASK_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TaskProperties")
            .getter(getter(Task::taskPropertiesAsStrings))
            .setter(setter(Builder::taskPropertiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskType").getter(getter(Task::taskTypeAsString)).setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_OPERATOR_FIELD,
            DESTINATION_FIELD_FIELD, SOURCE_FIELDS_FIELD, TASK_PROPERTIES_FIELD, TASK_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ConnectorOperator connectorOperator;

    private final String destinationField;

    private final List<String> sourceFields;

    private final Map<String, String> taskProperties;

    private final String taskType;

    private Task(BuilderImpl builder) {
        this.connectorOperator = builder.connectorOperator;
        this.destinationField = builder.destinationField;
        this.sourceFields = builder.sourceFields;
        this.taskProperties = builder.taskProperties;
        this.taskType = builder.taskType;
    }

    /**
     * <p>
     * The operation to be performed on the provided source fields.
     * </p>
     * 
     * @return The operation to be performed on the provided source fields.
     */
    public final ConnectorOperator connectorOperator() {
        return connectorOperator;
    }

    /**
     * <p>
     * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
     * </p>
     * 
     * @return A field in a destination connector, or a field value against which Amazon AppFlow validates a source
     *         field.
     */
    public final String destinationField() {
        return destinationField;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceFields() {
        return sourceFields != null && !(sourceFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The source fields to which a particular task is applied.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceFields} method.
     * </p>
     * 
     * @return The source fields to which a particular task is applied.
     */
    public final List<String> sourceFields() {
        return sourceFields;
    }

    /**
     * <p>
     * A map used to store task-related information. The service looks for particular information based on the TaskType.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskProperties} method.
     * </p>
     * 
     * @return A map used to store task-related information. The service looks for particular information based on the
     *         TaskType.
     */
    public final Map<OperatorPropertiesKeys, String> taskProperties() {
        return TaskPropertiesMapCopier.copyStringToEnum(taskProperties);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskProperties() {
        return taskProperties != null && !(taskProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map used to store task-related information. The service looks for particular information based on the TaskType.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskProperties} method.
     * </p>
     * 
     * @return A map used to store task-related information. The service looks for particular information based on the
     *         TaskType.
     */
    public final Map<String, String> taskPropertiesAsStrings() {
        return taskProperties;
    }

    /**
     * <p>
     * Specifies the particular task implementation that Amazon AppFlow performs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return Specifies the particular task implementation that Amazon AppFlow performs.
     * @see TaskType
     */
    public final TaskType taskType() {
        return TaskType.fromValue(taskType);
    }

    /**
     * <p>
     * Specifies the particular task implementation that Amazon AppFlow performs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link TaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskTypeAsString}.
     * </p>
     * 
     * @return Specifies the particular task implementation that Amazon AppFlow performs.
     * @see TaskType
     */
    public final String taskTypeAsString() {
        return taskType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectorOperator());
        hashCode = 31 * hashCode + Objects.hashCode(destinationField());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceFields() ? sourceFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskProperties() ? taskPropertiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task) obj;
        return Objects.equals(connectorOperator(), other.connectorOperator())
                && Objects.equals(destinationField(), other.destinationField()) && hasSourceFields() == other.hasSourceFields()
                && Objects.equals(sourceFields(), other.sourceFields()) && hasTaskProperties() == other.hasTaskProperties()
                && Objects.equals(taskPropertiesAsStrings(), other.taskPropertiesAsStrings())
                && Objects.equals(taskTypeAsString(), other.taskTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Task").add("ConnectorOperator", connectorOperator()).add("DestinationField", destinationField())
                .add("SourceFields", hasSourceFields() ? sourceFields() : null)
                .add("TaskProperties", hasTaskProperties() ? taskPropertiesAsStrings() : null)
                .add("TaskType", taskTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ConnectorOperator":
            return Optional.ofNullable(clazz.cast(connectorOperator()));
        case "DestinationField":
            return Optional.ofNullable(clazz.cast(destinationField()));
        case "SourceFields":
            return Optional.ofNullable(clazz.cast(sourceFields()));
        case "TaskProperties":
            return Optional.ofNullable(clazz.cast(taskPropertiesAsStrings()));
        case "TaskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Task, T> g) {
        return obj -> g.apply((Task) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Task> {
        /**
         * <p>
         * The operation to be performed on the provided source fields.
         * </p>
         * 
         * @param connectorOperator
         *        The operation to be performed on the provided source fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectorOperator(ConnectorOperator connectorOperator);

        /**
         * <p>
         * The operation to be performed on the provided source fields.
         * </p>
         * This is a convenience that creates an instance of the {@link ConnectorOperator.Builder} avoiding the need to
         * create one manually via {@link ConnectorOperator#builder()}.
         *
         * When the {@link Consumer} completes, {@link ConnectorOperator.Builder#build()} is called immediately and its
         * result is passed to {@link #connectorOperator(ConnectorOperator)}.
         * 
         * @param connectorOperator
         *        a consumer that will call methods on {@link ConnectorOperator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #connectorOperator(ConnectorOperator)
         */
        default Builder connectorOperator(Consumer<ConnectorOperator.Builder> connectorOperator) {
            return connectorOperator(ConnectorOperator.builder().applyMutation(connectorOperator).build());
        }

        /**
         * <p>
         * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
         * </p>
         * 
         * @param destinationField
         *        A field in a destination connector, or a field value against which Amazon AppFlow validates a source
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationField(String destinationField);

        /**
         * <p>
         * The source fields to which a particular task is applied.
         * </p>
         * 
         * @param sourceFields
         *        The source fields to which a particular task is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFields(Collection<String> sourceFields);

        /**
         * <p>
         * The source fields to which a particular task is applied.
         * </p>
         * 
         * @param sourceFields
         *        The source fields to which a particular task is applied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceFields(String... sourceFields);

        /**
         * <p>
         * A map used to store task-related information. The service looks for particular information based on the
         * TaskType.
         * </p>
         * 
         * @param taskProperties
         *        A map used to store task-related information. The service looks for particular information based on
         *        the TaskType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskPropertiesWithStrings(Map<String, String> taskProperties);

        /**
         * <p>
         * A map used to store task-related information. The service looks for particular information based on the
         * TaskType.
         * </p>
         * 
         * @param taskProperties
         *        A map used to store task-related information. The service looks for particular information based on
         *        the TaskType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskProperties(Map<OperatorPropertiesKeys, String> taskProperties);

        /**
         * <p>
         * Specifies the particular task implementation that Amazon AppFlow performs.
         * </p>
         * 
         * @param taskType
         *        Specifies the particular task implementation that Amazon AppFlow performs.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * Specifies the particular task implementation that Amazon AppFlow performs.
         * </p>
         * 
         * @param taskType
         *        Specifies the particular task implementation that Amazon AppFlow performs.
         * @see TaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskType
         */
        Builder taskType(TaskType taskType);
    }

    static final class BuilderImpl implements Builder {
        private ConnectorOperator connectorOperator;

        private String destinationField;

        private List<String> sourceFields = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> taskProperties = DefaultSdkAutoConstructMap.getInstance();

        private String taskType;

        private BuilderImpl() {
        }

        private BuilderImpl(Task model) {
            connectorOperator(model.connectorOperator);
            destinationField(model.destinationField);
            sourceFields(model.sourceFields);
            taskPropertiesWithStrings(model.taskProperties);
            taskType(model.taskType);
        }

        public final ConnectorOperator.Builder getConnectorOperator() {
            return connectorOperator != null ? connectorOperator.toBuilder() : null;
        }

        public final void setConnectorOperator(ConnectorOperator.BuilderImpl connectorOperator) {
            this.connectorOperator = connectorOperator != null ? connectorOperator.build() : null;
        }

        @Override
        @Transient
        public final Builder connectorOperator(ConnectorOperator connectorOperator) {
            this.connectorOperator = connectorOperator;
            return this;
        }

        public final String getDestinationField() {
            return destinationField;
        }

        public final void setDestinationField(String destinationField) {
            this.destinationField = destinationField;
        }

        @Override
        @Transient
        public final Builder destinationField(String destinationField) {
            this.destinationField = destinationField;
            return this;
        }

        public final Collection<String> getSourceFields() {
            if (sourceFields instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceFields;
        }

        public final void setSourceFields(Collection<String> sourceFields) {
            this.sourceFields = SourceFieldsCopier.copy(sourceFields);
        }

        @Override
        @Transient
        public final Builder sourceFields(Collection<String> sourceFields) {
            this.sourceFields = SourceFieldsCopier.copy(sourceFields);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sourceFields(String... sourceFields) {
            sourceFields(Arrays.asList(sourceFields));
            return this;
        }

        public final Map<String, String> getTaskProperties() {
            if (taskProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskProperties;
        }

        public final void setTaskProperties(Map<String, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copy(taskProperties);
        }

        @Override
        @Transient
        public final Builder taskPropertiesWithStrings(Map<String, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copy(taskProperties);
            return this;
        }

        @Override
        @Transient
        public final Builder taskProperties(Map<OperatorPropertiesKeys, String> taskProperties) {
            this.taskProperties = TaskPropertiesMapCopier.copyEnumToString(taskProperties);
            return this;
        }

        public final String getTaskType() {
            return taskType;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        @Override
        @Transient
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        @Transient
        public final Builder taskType(TaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        @Override
        public Task build() {
            return new Task(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
