/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Updates associated with the address properties of a customer profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAddress implements SdkPojo, Serializable, ToCopyableBuilder<UpdateAddress.Builder, UpdateAddress> {
    private static final SdkField<String> ADDRESS1_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Address1").getter(getter(UpdateAddress::address1)).setter(setter(Builder::address1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address1").build()).build();

    private static final SdkField<String> ADDRESS2_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Address2").getter(getter(UpdateAddress::address2)).setter(setter(Builder::address2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address2").build()).build();

    private static final SdkField<String> ADDRESS3_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Address3").getter(getter(UpdateAddress::address3)).setter(setter(Builder::address3))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address3").build()).build();

    private static final SdkField<String> ADDRESS4_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Address4").getter(getter(UpdateAddress::address4)).setter(setter(Builder::address4))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address4").build()).build();

    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(UpdateAddress::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> COUNTY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("County")
            .getter(getter(UpdateAddress::county)).setter(setter(Builder::county))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("County").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateAddress::state)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> PROVINCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Province").getter(getter(UpdateAddress::province)).setter(setter(Builder::province))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Province").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(UpdateAddress::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(UpdateAddress::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS1_FIELD,
            ADDRESS2_FIELD, ADDRESS3_FIELD, ADDRESS4_FIELD, CITY_FIELD, COUNTY_FIELD, STATE_FIELD, PROVINCE_FIELD, COUNTRY_FIELD,
            POSTAL_CODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String address1;

    private final String address2;

    private final String address3;

    private final String address4;

    private final String city;

    private final String county;

    private final String state;

    private final String province;

    private final String country;

    private final String postalCode;

    private UpdateAddress(BuilderImpl builder) {
        this.address1 = builder.address1;
        this.address2 = builder.address2;
        this.address3 = builder.address3;
        this.address4 = builder.address4;
        this.city = builder.city;
        this.county = builder.county;
        this.state = builder.state;
        this.province = builder.province;
        this.country = builder.country;
        this.postalCode = builder.postalCode;
    }

    /**
     * <p>
     * The first line of a customer address.
     * </p>
     * 
     * @return The first line of a customer address.
     */
    public final String address1() {
        return address1;
    }

    /**
     * <p>
     * The second line of a customer address.
     * </p>
     * 
     * @return The second line of a customer address.
     */
    public final String address2() {
        return address2;
    }

    /**
     * <p>
     * The third line of a customer address.
     * </p>
     * 
     * @return The third line of a customer address.
     */
    public final String address3() {
        return address3;
    }

    /**
     * <p>
     * The fourth line of a customer address.
     * </p>
     * 
     * @return The fourth line of a customer address.
     */
    public final String address4() {
        return address4;
    }

    /**
     * <p>
     * The city in which a customer lives.
     * </p>
     * 
     * @return The city in which a customer lives.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * The county in which a customer lives.
     * </p>
     * 
     * @return The county in which a customer lives.
     */
    public final String county() {
        return county;
    }

    /**
     * <p>
     * The state in which a customer lives.
     * </p>
     * 
     * @return The state in which a customer lives.
     */
    public final String state() {
        return state;
    }

    /**
     * <p>
     * The province in which a customer lives.
     * </p>
     * 
     * @return The province in which a customer lives.
     */
    public final String province() {
        return province;
    }

    /**
     * <p>
     * The country in which a customer lives.
     * </p>
     * 
     * @return The country in which a customer lives.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * The postal code of a customer address.
     * </p>
     * 
     * @return The postal code of a customer address.
     */
    public final String postalCode() {
        return postalCode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(address1());
        hashCode = 31 * hashCode + Objects.hashCode(address2());
        hashCode = 31 * hashCode + Objects.hashCode(address3());
        hashCode = 31 * hashCode + Objects.hashCode(address4());
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(county());
        hashCode = 31 * hashCode + Objects.hashCode(state());
        hashCode = 31 * hashCode + Objects.hashCode(province());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAddress)) {
            return false;
        }
        UpdateAddress other = (UpdateAddress) obj;
        return Objects.equals(address1(), other.address1()) && Objects.equals(address2(), other.address2())
                && Objects.equals(address3(), other.address3()) && Objects.equals(address4(), other.address4())
                && Objects.equals(city(), other.city()) && Objects.equals(county(), other.county())
                && Objects.equals(state(), other.state()) && Objects.equals(province(), other.province())
                && Objects.equals(country(), other.country()) && Objects.equals(postalCode(), other.postalCode());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAddress").add("Address1", address1()).add("Address2", address2())
                .add("Address3", address3()).add("Address4", address4()).add("City", city()).add("County", county())
                .add("State", state()).add("Province", province()).add("Country", country()).add("PostalCode", postalCode())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Address1":
            return Optional.ofNullable(clazz.cast(address1()));
        case "Address2":
            return Optional.ofNullable(clazz.cast(address2()));
        case "Address3":
            return Optional.ofNullable(clazz.cast(address3()));
        case "Address4":
            return Optional.ofNullable(clazz.cast(address4()));
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "County":
            return Optional.ofNullable(clazz.cast(county()));
        case "State":
            return Optional.ofNullable(clazz.cast(state()));
        case "Province":
            return Optional.ofNullable(clazz.cast(province()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAddress, T> g) {
        return obj -> g.apply((UpdateAddress) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateAddress> {
        /**
         * <p>
         * The first line of a customer address.
         * </p>
         * 
         * @param address1
         *        The first line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address1(String address1);

        /**
         * <p>
         * The second line of a customer address.
         * </p>
         * 
         * @param address2
         *        The second line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address2(String address2);

        /**
         * <p>
         * The third line of a customer address.
         * </p>
         * 
         * @param address3
         *        The third line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address3(String address3);

        /**
         * <p>
         * The fourth line of a customer address.
         * </p>
         * 
         * @param address4
         *        The fourth line of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address4(String address4);

        /**
         * <p>
         * The city in which a customer lives.
         * </p>
         * 
         * @param city
         *        The city in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * The county in which a customer lives.
         * </p>
         * 
         * @param county
         *        The county in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder county(String county);

        /**
         * <p>
         * The state in which a customer lives.
         * </p>
         * 
         * @param state
         *        The state in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(String state);

        /**
         * <p>
         * The province in which a customer lives.
         * </p>
         * 
         * @param province
         *        The province in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder province(String province);

        /**
         * <p>
         * The country in which a customer lives.
         * </p>
         * 
         * @param country
         *        The country in which a customer lives.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * The postal code of a customer address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of a customer address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);
    }

    static final class BuilderImpl implements Builder {
        private String address1;

        private String address2;

        private String address3;

        private String address4;

        private String city;

        private String county;

        private String state;

        private String province;

        private String country;

        private String postalCode;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAddress model) {
            address1(model.address1);
            address2(model.address2);
            address3(model.address3);
            address4(model.address4);
            city(model.city);
            county(model.county);
            state(model.state);
            province(model.province);
            country(model.country);
            postalCode(model.postalCode);
        }

        public final String getAddress1() {
            return address1;
        }

        public final void setAddress1(String address1) {
            this.address1 = address1;
        }

        @Override
        @Transient
        public final Builder address1(String address1) {
            this.address1 = address1;
            return this;
        }

        public final String getAddress2() {
            return address2;
        }

        public final void setAddress2(String address2) {
            this.address2 = address2;
        }

        @Override
        @Transient
        public final Builder address2(String address2) {
            this.address2 = address2;
            return this;
        }

        public final String getAddress3() {
            return address3;
        }

        public final void setAddress3(String address3) {
            this.address3 = address3;
        }

        @Override
        @Transient
        public final Builder address3(String address3) {
            this.address3 = address3;
            return this;
        }

        public final String getAddress4() {
            return address4;
        }

        public final void setAddress4(String address4) {
            this.address4 = address4;
        }

        @Override
        @Transient
        public final Builder address4(String address4) {
            this.address4 = address4;
            return this;
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        @Transient
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getCounty() {
            return county;
        }

        public final void setCounty(String county) {
            this.county = county;
        }

        @Override
        @Transient
        public final Builder county(String county) {
            this.county = county;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getProvince() {
            return province;
        }

        public final void setProvince(String province) {
            this.province = province;
        }

        @Override
        @Transient
        public final Builder province(String province) {
            this.province = province;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        @Transient
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        @Transient
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        @Override
        public UpdateAddress build() {
            return new UpdateAddress(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
