/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.FieldMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.KeyMapCopier;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeField;
import software.amazon.awssdk.services.customerprofiles.model.ObjectTypeKey;
import software.amazon.awssdk.services.customerprofiles.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProfileObjectTypeResponse
extends CustomerProfilesResponse
implements ToCopyableBuilder<Builder, GetProfileObjectTypeResponse> {
    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectTypeName").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::objectTypeName)).setter(GetProfileObjectTypeResponse.setter(Builder::objectTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::description)).setter(GetProfileObjectTypeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TemplateId").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::templateId)).setter(GetProfileObjectTypeResponse.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()}).build();
    private static final SdkField<Integer> EXPIRATION_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ExpirationDays").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::expirationDays)).setter(GetProfileObjectTypeResponse.setter(Builder::expirationDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDays").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKey").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::encryptionKey)).setter(GetProfileObjectTypeResponse.setter(Builder::encryptionKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKey").build()}).build();
    private static final SdkField<Boolean> ALLOW_PROFILE_CREATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowProfileCreation").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::allowProfileCreation)).setter(GetProfileObjectTypeResponse.setter(Builder::allowProfileCreation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowProfileCreation").build()}).build();
    private static final SdkField<Map<String, ObjectTypeField>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Fields").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::fields)).setter(GetProfileObjectTypeResponse.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<ObjectTypeKey>>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Keys").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::keys)).setter(GetProfileObjectTypeResponse.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ObjectTypeKey::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::createdAt)).setter(GetProfileObjectTypeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdatedAt").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::lastUpdatedAt)).setter(GetProfileObjectTypeResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(GetProfileObjectTypeResponse.getter(GetProfileObjectTypeResponse::tags)).setter(GetProfileObjectTypeResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_TYPE_NAME_FIELD, DESCRIPTION_FIELD, TEMPLATE_ID_FIELD, EXPIRATION_DAYS_FIELD, ENCRYPTION_KEY_FIELD, ALLOW_PROFILE_CREATION_FIELD, FIELDS_FIELD, KEYS_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD));
    private final String objectTypeName;
    private final String description;
    private final String templateId;
    private final Integer expirationDays;
    private final String encryptionKey;
    private final Boolean allowProfileCreation;
    private final Map<String, ObjectTypeField> fields;
    private final Map<String, List<ObjectTypeKey>> keys;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final Map<String, String> tags;

    private GetProfileObjectTypeResponse(BuilderImpl builder) {
        super(builder);
        this.objectTypeName = builder.objectTypeName;
        this.description = builder.description;
        this.templateId = builder.templateId;
        this.expirationDays = builder.expirationDays;
        this.encryptionKey = builder.encryptionKey;
        this.allowProfileCreation = builder.allowProfileCreation;
        this.fields = builder.fields;
        this.keys = builder.keys;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
    }

    public final String objectTypeName() {
        return this.objectTypeName;
    }

    public final String description() {
        return this.description;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final Integer expirationDays() {
        return this.expirationDays;
    }

    public final String encryptionKey() {
        return this.encryptionKey;
    }

    public final Boolean allowProfileCreation() {
        return this.allowProfileCreation;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, ObjectTypeField> fields() {
        return this.fields;
    }

    public final boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<ObjectTypeKey>> keys() {
        return this.keys;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowProfileCreation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileObjectTypeResponse)) {
            return false;
        }
        GetProfileObjectTypeResponse other = (GetProfileObjectTypeResponse)((Object)obj);
        return Objects.equals(this.objectTypeName(), other.objectTypeName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.expirationDays(), other.expirationDays()) && Objects.equals(this.encryptionKey(), other.encryptionKey()) && Objects.equals(this.allowProfileCreation(), other.allowProfileCreation()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"GetProfileObjectTypeResponse").add("ObjectTypeName", (Object)this.objectTypeName()).add("Description", (Object)this.description()).add("TemplateId", (Object)this.templateId()).add("ExpirationDays", (Object)this.expirationDays()).add("EncryptionKey", (Object)this.encryptionKey()).add("AllowProfileCreation", (Object)this.allowProfileCreation()).add("Fields", this.hasFields() ? this.fields() : null).add("Keys", this.hasKeys() ? this.keys() : null).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectTypeName": {
                return Optional.ofNullable(clazz.cast(this.objectTypeName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "TemplateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "ExpirationDays": {
                return Optional.ofNullable(clazz.cast(this.expirationDays()));
            }
            case "EncryptionKey": {
                return Optional.ofNullable(clazz.cast(this.encryptionKey()));
            }
            case "AllowProfileCreation": {
                return Optional.ofNullable(clazz.cast(this.allowProfileCreation()));
            }
            case "Fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "LastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileObjectTypeResponse, T> g) {
        return obj -> g.apply((GetProfileObjectTypeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CustomerProfilesResponse.BuilderImpl
    implements Builder {
        private String objectTypeName;
        private String description;
        private String templateId;
        private Integer expirationDays;
        private String encryptionKey;
        private Boolean allowProfileCreation;
        private Map<String, ObjectTypeField> fields = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<ObjectTypeKey>> keys = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileObjectTypeResponse model) {
            super(model);
            this.objectTypeName(model.objectTypeName);
            this.description(model.description);
            this.templateId(model.templateId);
            this.expirationDays(model.expirationDays);
            this.encryptionKey(model.encryptionKey);
            this.allowProfileCreation(model.allowProfileCreation);
            this.fields(model.fields);
            this.keys(model.keys);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.tags(model.tags);
        }

        public final String getObjectTypeName() {
            return this.objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        @Transient
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        @Transient
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Integer getExpirationDays() {
            return this.expirationDays;
        }

        public final void setExpirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
        }

        @Override
        @Transient
        public final Builder expirationDays(Integer expirationDays) {
            this.expirationDays = expirationDays;
            return this;
        }

        public final String getEncryptionKey() {
            return this.encryptionKey;
        }

        public final void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        @Override
        @Transient
        public final Builder encryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public final Boolean getAllowProfileCreation() {
            return this.allowProfileCreation;
        }

        public final void setAllowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
        }

        @Override
        @Transient
        public final Builder allowProfileCreation(Boolean allowProfileCreation) {
            this.allowProfileCreation = allowProfileCreation;
            return this;
        }

        public final Map<String, ObjectTypeField.Builder> getFields() {
            Map<String, ObjectTypeField.Builder> result = FieldMapCopier.copyToBuilder(this.fields);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setFields(Map<String, ObjectTypeField.BuilderImpl> fields) {
            this.fields = FieldMapCopier.copyFromBuilder(fields);
        }

        @Override
        @Transient
        public final Builder fields(Map<String, ObjectTypeField> fields) {
            this.fields = FieldMapCopier.copy(fields);
            return this;
        }

        public final Map<String, List<ObjectTypeKey.Builder>> getKeys() {
            Map<String, List<ObjectTypeKey.Builder>> result = KeyMapCopier.copyToBuilder(this.keys);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setKeys(Map<String, ? extends Collection<ObjectTypeKey.BuilderImpl>> keys) {
            this.keys = KeyMapCopier.copyFromBuilder(keys);
        }

        @Override
        @Transient
        public final Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> keys) {
            this.keys = KeyMapCopier.copy(keys);
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        @Transient
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        @Transient
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetProfileObjectTypeResponse build() {
            return new GetProfileObjectTypeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CustomerProfilesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProfileObjectTypeResponse> {
        public Builder objectTypeName(String var1);

        public Builder description(String var1);

        public Builder templateId(String var1);

        public Builder expirationDays(Integer var1);

        public Builder encryptionKey(String var1);

        public Builder allowProfileCreation(Boolean var1);

        public Builder fields(Map<String, ObjectTypeField> var1);

        public Builder keys(Map<String, ? extends Collection<ObjectTypeKey>> var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder tags(Map<String, String> var1);
    }
}

