/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.customerprofiles.model.ProfileIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MatchItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MatchItem> {
    private static final SdkField<String> MATCH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MatchId").getter(MatchItem.getter(MatchItem::matchId)).setter(MatchItem.setter(Builder::matchId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchId").build()}).build();
    private static final SdkField<List<String>> PROFILE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProfileIds").getter(MatchItem.getter(MatchItem::profileIds)).setter(MatchItem.setter(Builder::profileIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MATCH_ID_FIELD, PROFILE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String matchId;
    private final List<String> profileIds;

    private MatchItem(BuilderImpl builder) {
        this.matchId = builder.matchId;
        this.profileIds = builder.profileIds;
    }

    public final String matchId() {
        return this.matchId;
    }

    public final boolean hasProfileIds() {
        return this.profileIds != null && !(this.profileIds instanceof SdkAutoConstructList);
    }

    public final List<String> profileIds() {
        return this.profileIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.matchId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProfileIds() ? this.profileIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MatchItem)) {
            return false;
        }
        MatchItem other = (MatchItem)obj;
        return Objects.equals(this.matchId(), other.matchId()) && this.hasProfileIds() == other.hasProfileIds() && Objects.equals(this.profileIds(), other.profileIds());
    }

    public final String toString() {
        return ToString.builder((String)"MatchItem").add("MatchId", (Object)this.matchId()).add("ProfileIds", this.hasProfileIds() ? this.profileIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MatchId": {
                return Optional.ofNullable(clazz.cast(this.matchId()));
            }
            case "ProfileIds": {
                return Optional.ofNullable(clazz.cast(this.profileIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MatchItem, T> g) {
        return obj -> g.apply((MatchItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String matchId;
        private List<String> profileIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MatchItem model) {
            this.matchId(model.matchId);
            this.profileIds(model.profileIds);
        }

        public final String getMatchId() {
            return this.matchId;
        }

        public final void setMatchId(String matchId) {
            this.matchId = matchId;
        }

        @Override
        @Transient
        public final Builder matchId(String matchId) {
            this.matchId = matchId;
            return this;
        }

        public final Collection<String> getProfileIds() {
            if (this.profileIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.profileIds;
        }

        public final void setProfileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
        }

        @Override
        @Transient
        public final Builder profileIds(Collection<String> profileIds) {
            this.profileIds = ProfileIdListCopier.copy(profileIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder profileIds(String ... profileIds) {
            this.profileIds(Arrays.asList(profileIds));
            return this;
        }

        public MatchItem build() {
            return new MatchItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MatchItem> {
        public Builder matchId(String var1);

        public Builder profileIds(Collection<String> var1);

        public Builder profileIds(String ... var1);
    }
}

