/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The properties that are applied when Salesforce is being used as a source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SalesforceSourceProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<SalesforceSourceProperties.Builder, SalesforceSourceProperties> {
    private static final SdkField<String> OBJECT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Object")
            .getter(getter(SalesforceSourceProperties::object)).setter(setter(Builder::object))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Object").build()).build();

    private static final SdkField<Boolean> ENABLE_DYNAMIC_FIELD_UPDATE_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("EnableDynamicFieldUpdate")
            .getter(getter(SalesforceSourceProperties::enableDynamicFieldUpdate))
            .setter(setter(Builder::enableDynamicFieldUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDynamicFieldUpdate").build())
            .build();

    private static final SdkField<Boolean> INCLUDE_DELETED_RECORDS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IncludeDeletedRecords").getter(getter(SalesforceSourceProperties::includeDeletedRecords))
            .setter(setter(Builder::includeDeletedRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeDeletedRecords").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_FIELD,
            ENABLE_DYNAMIC_FIELD_UPDATE_FIELD, INCLUDE_DELETED_RECORDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String object;

    private final Boolean enableDynamicFieldUpdate;

    private final Boolean includeDeletedRecords;

    private SalesforceSourceProperties(BuilderImpl builder) {
        this.object = builder.object;
        this.enableDynamicFieldUpdate = builder.enableDynamicFieldUpdate;
        this.includeDeletedRecords = builder.includeDeletedRecords;
    }

    /**
     * <p>
     * The object specified in the Salesforce flow source.
     * </p>
     * 
     * @return The object specified in the Salesforce flow source.
     */
    public final String object() {
        return object;
    }

    /**
     * <p>
     * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a
     * flow.
     * </p>
     * 
     * @return The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while
     *         running a flow.
     */
    public final Boolean enableDynamicFieldUpdate() {
        return enableDynamicFieldUpdate;
    }

    /**
     * <p>
     * Indicates whether Amazon AppFlow includes deleted files in the flow run.
     * </p>
     * 
     * @return Indicates whether Amazon AppFlow includes deleted files in the flow run.
     */
    public final Boolean includeDeletedRecords() {
        return includeDeletedRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(object());
        hashCode = 31 * hashCode + Objects.hashCode(enableDynamicFieldUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(includeDeletedRecords());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceSourceProperties)) {
            return false;
        }
        SalesforceSourceProperties other = (SalesforceSourceProperties) obj;
        return Objects.equals(object(), other.object())
                && Objects.equals(enableDynamicFieldUpdate(), other.enableDynamicFieldUpdate())
                && Objects.equals(includeDeletedRecords(), other.includeDeletedRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SalesforceSourceProperties").add("Object", object())
                .add("EnableDynamicFieldUpdate", enableDynamicFieldUpdate())
                .add("IncludeDeletedRecords", includeDeletedRecords()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Object":
            return Optional.ofNullable(clazz.cast(object()));
        case "EnableDynamicFieldUpdate":
            return Optional.ofNullable(clazz.cast(enableDynamicFieldUpdate()));
        case "IncludeDeletedRecords":
            return Optional.ofNullable(clazz.cast(includeDeletedRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceSourceProperties, T> g) {
        return obj -> g.apply((SalesforceSourceProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SalesforceSourceProperties> {
        /**
         * <p>
         * The object specified in the Salesforce flow source.
         * </p>
         * 
         * @param object
         *        The object specified in the Salesforce flow source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder object(String object);

        /**
         * <p>
         * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running
         * a flow.
         * </p>
         * 
         * @param enableDynamicFieldUpdate
         *        The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while
         *        running a flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDynamicFieldUpdate(Boolean enableDynamicFieldUpdate);

        /**
         * <p>
         * Indicates whether Amazon AppFlow includes deleted files in the flow run.
         * </p>
         * 
         * @param includeDeletedRecords
         *        Indicates whether Amazon AppFlow includes deleted files in the flow run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeDeletedRecords(Boolean includeDeletedRecords);
    }

    static final class BuilderImpl implements Builder {
        private String object;

        private Boolean enableDynamicFieldUpdate;

        private Boolean includeDeletedRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceSourceProperties model) {
            object(model.object);
            enableDynamicFieldUpdate(model.enableDynamicFieldUpdate);
            includeDeletedRecords(model.includeDeletedRecords);
        }

        public final String getObject() {
            return object;
        }

        public final void setObject(String object) {
            this.object = object;
        }

        @Override
        @Transient
        public final Builder object(String object) {
            this.object = object;
            return this;
        }

        public final Boolean getEnableDynamicFieldUpdate() {
            return enableDynamicFieldUpdate;
        }

        public final void setEnableDynamicFieldUpdate(Boolean enableDynamicFieldUpdate) {
            this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
        }

        @Override
        @Transient
        public final Builder enableDynamicFieldUpdate(Boolean enableDynamicFieldUpdate) {
            this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
            return this;
        }

        public final Boolean getIncludeDeletedRecords() {
            return includeDeletedRecords;
        }

        public final void setIncludeDeletedRecords(Boolean includeDeletedRecords) {
            this.includeDeletedRecords = includeDeletedRecords;
        }

        @Override
        @Transient
        public final Builder includeDeletedRecords(Boolean includeDeletedRecords) {
            this.includeDeletedRecords = includeDeletedRecords;
            return this;
        }

        @Override
        public SalesforceSourceProperties build() {
            return new SalesforceSourceProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
