/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StandardIdentifier {
    PROFILE("PROFILE"),
    ASSET("ASSET"),
    CASE("CASE"),
    UNIQUE("UNIQUE"),
    SECONDARY("SECONDARY"),
    LOOKUP_ONLY("LOOKUP_ONLY"),
    NEW_ONLY("NEW_ONLY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StandardIdentifier> VALUE_MAP;
    private final String value;

    private StandardIdentifier(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StandardIdentifier fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StandardIdentifier> knownValues() {
        EnumSet<StandardIdentifier> knownValues = EnumSet.allOf(StandardIdentifier.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StandardIdentifier.class, StandardIdentifier::toString);
    }
}

