/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutIntegrationResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<PutIntegrationResponse.Builder, PutIntegrationResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(PutIntegrationResponse::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Uri")
            .getter(getter(PutIntegrationResponse::uri)).setter(setter(Builder::uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Uri").build()).build();

    private static final SdkField<String> OBJECT_TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectTypeName").getter(getter(PutIntegrationResponse::objectTypeName))
            .setter(setter(Builder::objectTypeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeName").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PutIntegrationResponse::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(PutIntegrationResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(PutIntegrationResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> OBJECT_TYPE_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ObjectTypeNames")
            .getter(getter(PutIntegrationResponse::objectTypeNames))
            .setter(setter(Builder::objectTypeNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectTypeNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkflowId").getter(getter(PutIntegrationResponse::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkflowId").build()).build();

    private static final SdkField<Boolean> IS_UNSTRUCTURED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsUnstructured").getter(getter(PutIntegrationResponse::isUnstructured))
            .setter(setter(Builder::isUnstructured))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUnstructured").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD, URI_FIELD,
            OBJECT_TYPE_NAME_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, TAGS_FIELD, OBJECT_TYPE_NAMES_FIELD,
            WORKFLOW_ID_FIELD, IS_UNSTRUCTURED_FIELD));

    private final String domainName;

    private final String uri;

    private final String objectTypeName;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final Map<String, String> tags;

    private final Map<String, String> objectTypeNames;

    private final String workflowId;

    private final Boolean isUnstructured;

    private PutIntegrationResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.uri = builder.uri;
        this.objectTypeName = builder.objectTypeName;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.tags = builder.tags;
        this.objectTypeNames = builder.objectTypeNames;
        this.workflowId = builder.workflowId;
        this.isUnstructured = builder.isUnstructured;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The URI of the S3 bucket or any other type of data source.
     * </p>
     * 
     * @return The URI of the S3 bucket or any other type of data source.
     */
    public final String uri() {
        return uri;
    }

    /**
     * <p>
     * The name of the profile object type.
     * </p>
     * 
     * @return The name of the profile object type.
     */
    public final String objectTypeName() {
        return objectTypeName;
    }

    /**
     * <p>
     * The timestamp of when the domain was created.
     * </p>
     * 
     * @return The timestamp of when the domain was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timestamp of when the domain was most recently edited.
     * </p>
     * 
     * @return The timestamp of when the domain was most recently edited.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags used to organize, track, or control access for this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags used to organize, track, or control access for this resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the ObjectTypeNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasObjectTypeNames() {
        return objectTypeNames != null && !(objectTypeNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A map in which each key is an event type from an external application such as Segment or Shopify, and each value
     * is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event types:
     * <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>,
     * <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>,
     * and <code>ShopifyUpdatedOrders</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjectTypeNames} method.
     * </p>
     * 
     * @return A map in which each key is an event type from an external application such as Segment or Shopify, and
     *         each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the
     *         following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>,
     *         <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>,
     *         <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and
     *         <code>ShopifyUpdatedOrders</code>.
     */
    public final Map<String, String> objectTypeNames() {
        return objectTypeNames;
    }

    /**
     * <p>
     * Unique identifier for the workflow.
     * </p>
     * 
     * @return Unique identifier for the workflow.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * Boolean to indicate if the Flow associated with the Integration is created via Appflow console or with
     * ObjectTypeName equals _unstructured via API/CLI in flowDefinition
     * </p>
     * 
     * @return Boolean to indicate if the Flow associated with the Integration is created via Appflow console or with
     *         ObjectTypeName equals _unstructured via API/CLI in flowDefinition
     */
    public final Boolean isUnstructured() {
        return isUnstructured;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(uri());
        hashCode = 31 * hashCode + Objects.hashCode(objectTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasObjectTypeNames() ? objectTypeNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(isUnstructured());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutIntegrationResponse)) {
            return false;
        }
        PutIntegrationResponse other = (PutIntegrationResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(uri(), other.uri())
                && Objects.equals(objectTypeName(), other.objectTypeName()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && hasObjectTypeNames() == other.hasObjectTypeNames()
                && Objects.equals(objectTypeNames(), other.objectTypeNames()) && Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(isUnstructured(), other.isUnstructured());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutIntegrationResponse").add("DomainName", domainName()).add("Uri", uri())
                .add("ObjectTypeName", objectTypeName()).add("CreatedAt", createdAt()).add("LastUpdatedAt", lastUpdatedAt())
                .add("Tags", hasTags() ? tags() : null).add("ObjectTypeNames", hasObjectTypeNames() ? objectTypeNames() : null)
                .add("WorkflowId", workflowId()).add("IsUnstructured", isUnstructured()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Uri":
            return Optional.ofNullable(clazz.cast(uri()));
        case "ObjectTypeName":
            return Optional.ofNullable(clazz.cast(objectTypeName()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ObjectTypeNames":
            return Optional.ofNullable(clazz.cast(objectTypeNames()));
        case "WorkflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "IsUnstructured":
            return Optional.ofNullable(clazz.cast(isUnstructured()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutIntegrationResponse, T> g) {
        return obj -> g.apply((PutIntegrationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo, CopyableBuilder<Builder, PutIntegrationResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The URI of the S3 bucket or any other type of data source.
         * </p>
         * 
         * @param uri
         *        The URI of the S3 bucket or any other type of data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uri(String uri);

        /**
         * <p>
         * The name of the profile object type.
         * </p>
         * 
         * @param objectTypeName
         *        The name of the profile object type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeName(String objectTypeName);

        /**
         * <p>
         * The timestamp of when the domain was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp of when the domain was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timestamp of when the domain was most recently edited.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the domain was most recently edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The tags used to organize, track, or control access for this resource.
         * </p>
         * 
         * @param tags
         *        The tags used to organize, track, or control access for this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A map in which each key is an event type from an external application such as Segment or Shopify, and each
         * value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the following event
         * types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>, <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>, <code>ShopifyUpdateDraftOrders</code>,
         * <code>ShopifyCreateOrders</code>, and <code>ShopifyUpdatedOrders</code>.
         * </p>
         * 
         * @param objectTypeNames
         *        A map in which each key is an event type from an external application such as Segment or Shopify, and
         *        each value is an <code>ObjectTypeName</code> (template) used to ingest the event. It supports the
         *        following event types: <code>SegmentIdentify</code>, <code>ShopifyCreateCustomers</code>,
         *        <code>ShopifyUpdateCustomers</code>, <code>ShopifyCreateDraftOrders</code>,
         *        <code>ShopifyUpdateDraftOrders</code>, <code>ShopifyCreateOrders</code>, and
         *        <code>ShopifyUpdatedOrders</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectTypeNames(Map<String, String> objectTypeNames);

        /**
         * <p>
         * Unique identifier for the workflow.
         * </p>
         * 
         * @param workflowId
         *        Unique identifier for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * Boolean to indicate if the Flow associated with the Integration is created via Appflow console or with
         * ObjectTypeName equals _unstructured via API/CLI in flowDefinition
         * </p>
         * 
         * @param isUnstructured
         *        Boolean to indicate if the Flow associated with the Integration is created via Appflow console or with
         *        ObjectTypeName equals _unstructured via API/CLI in flowDefinition
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUnstructured(Boolean isUnstructured);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private String uri;

        private String objectTypeName;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> objectTypeNames = DefaultSdkAutoConstructMap.getInstance();

        private String workflowId;

        private Boolean isUnstructured;

        private BuilderImpl() {
        }

        private BuilderImpl(PutIntegrationResponse model) {
            super(model);
            domainName(model.domainName);
            uri(model.uri);
            objectTypeName(model.objectTypeName);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            tags(model.tags);
            objectTypeNames(model.objectTypeNames);
            workflowId(model.workflowId);
            isUnstructured(model.isUnstructured);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getUri() {
            return uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getObjectTypeName() {
            return objectTypeName;
        }

        public final void setObjectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
        }

        @Override
        public final Builder objectTypeName(String objectTypeName) {
            this.objectTypeName = objectTypeName;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getObjectTypeNames() {
            if (objectTypeNames instanceof SdkAutoConstructMap) {
                return null;
            }
            return objectTypeNames;
        }

        public final void setObjectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesCopier.copy(objectTypeNames);
        }

        @Override
        public final Builder objectTypeNames(Map<String, String> objectTypeNames) {
            this.objectTypeNames = ObjectTypeNamesCopier.copy(objectTypeNames);
            return this;
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final Boolean getIsUnstructured() {
            return isUnstructured;
        }

        public final void setIsUnstructured(Boolean isUnstructured) {
            this.isUnstructured = isUnstructured;
        }

        @Override
        public final Builder isUnstructured(Boolean isUnstructured) {
            this.isUnstructured = isUnstructured;
            return this;
        }

        @Override
        public PutIntegrationResponse build() {
            return new PutIntegrationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
