/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.customerprofiles.model.AccessDeniedException;
import software.amazon.awssdk.services.customerprofiles.model.AddProfileKeyRequest;
import software.amazon.awssdk.services.customerprofiles.model.AddProfileKeyResponse;
import software.amazon.awssdk.services.customerprofiles.model.BadRequestException;
import software.amazon.awssdk.services.customerprofiles.model.CreateCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateIntegrationWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateIntegrationWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.CreateProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.CreateProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.CustomerProfilesException;
import software.amazon.awssdk.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileKeyRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileKeyResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetAutoMergingPreviewRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetAutoMergingPreviewResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeForProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetCalculatedAttributeForProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetEventStreamRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetEventStreamResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetIdentityResolutionJobRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetIdentityResolutionJobResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetMatchesRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetMatchesResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeTemplateRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetProfileObjectTypeTemplateResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowResponse;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowStepsRequest;
import software.amazon.awssdk.services.customerprofiles.model.GetWorkflowStepsResponse;
import software.amazon.awssdk.services.customerprofiles.model.InternalServerException;
import software.amazon.awssdk.services.customerprofiles.model.ListAccountIntegrationsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListAccountIntegrationsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributeDefinitionsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributeDefinitionsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributesForProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListCalculatedAttributesForProfileResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListDomainsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListIdentityResolutionJobsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListIdentityResolutionJobsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListIntegrationsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListIntegrationsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypeTemplatesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypeTemplatesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypesRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectTypesResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListProfileObjectsResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.customerprofiles.model.MergeProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.MergeProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutIntegrationRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutIntegrationResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectResponse;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectTypeRequest;
import software.amazon.awssdk.services.customerprofiles.model.PutProfileObjectTypeResponse;
import software.amazon.awssdk.services.customerprofiles.model.ResourceNotFoundException;
import software.amazon.awssdk.services.customerprofiles.model.SearchProfilesRequest;
import software.amazon.awssdk.services.customerprofiles.model.SearchProfilesResponse;
import software.amazon.awssdk.services.customerprofiles.model.TagResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.TagResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.ThrottlingException;
import software.amazon.awssdk.services.customerprofiles.model.UntagResourceRequest;
import software.amazon.awssdk.services.customerprofiles.model.UntagResourceResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateCalculatedAttributeDefinitionResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateDomainResponse;
import software.amazon.awssdk.services.customerprofiles.model.UpdateProfileRequest;
import software.amazon.awssdk.services.customerprofiles.model.UpdateProfileResponse;
import software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable;

/**
 * Service client for accessing Customer Profiles. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon Connect Customer Profiles</fullname>
 * <p>
 * Amazon Connect Customer Profiles is a unified customer profile for your contact center that has pre-built connectors
 * powered by AppFlow that make it easy to combine customer information from third party applications, such as
 * Salesforce (CRM), ServiceNow (ITSM), and your enterprise resource planning (ERP), with contact history from your
 * Amazon Connect contact center. If you're new to Amazon Connect, you might find it helpful to review the <a
 * href="https://docs.aws.amazon.com/connect/latest/adminguide/">Amazon Connect Administrator Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface CustomerProfilesClient extends AwsClient {
    String SERVICE_NAME = "profile";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "profile";

    /**
     * <p>
     * Associates a new key value with a specific profile, such as a Contact Record ContactId.
     * </p>
     * <p>
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the
     * profile that it belongs to.
     * </p>
     *
     * @param addProfileKeyRequest
     * @return Result of the AddProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.AddProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AddProfileKeyResponse addProfileKey(AddProfileKeyRequest addProfileKeyRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a new key value with a specific profile, such as a Contact Record ContactId.
     * </p>
     * <p>
     * A profile object can have a single unique key and any number of additional keys that can be used to identify the
     * profile that it belongs to.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddProfileKeyRequest.Builder} avoiding the need to
     * create one manually via {@link AddProfileKeyRequest#builder()}
     * </p>
     *
     * @param addProfileKeyRequest
     *        A {@link Consumer} that will call methods on {@link AddProfileKeyRequest.Builder} to create a request.
     * @return Result of the AddProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.AddProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/AddProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default AddProfileKeyResponse addProfileKey(Consumer<AddProfileKeyRequest.Builder> addProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return addProfileKey(AddProfileKeyRequest.builder().applyMutation(addProfileKeyRequest).build());
    }

    /**
     * <p>
     * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles
     * will be included in the calculated attribute, which can be retrieved for a profile using the <a href=
     * "https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html"
     * >GetCalculatedAttributeForProfile</a> API. Defining a calculated attribute makes it available for all profiles
     * within a domain. Each calculated attribute can only reference one <code>ObjectType</code> and at most, two fields
     * from that <code>ObjectType</code>.
     * </p>
     *
     * @param createCalculatedAttributeDefinitionRequest
     * @return Result of the CreateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCalculatedAttributeDefinitionResponse createCalculatedAttributeDefinition(
            CreateCalculatedAttributeDefinitionRequest createCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new calculated attribute definition. After creation, new object data ingested into Customer Profiles
     * will be included in the calculated attribute, which can be retrieved for a profile using the <a href=
     * "https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetCalculatedAttributeForProfile.html"
     * >GetCalculatedAttributeForProfile</a> API. Defining a calculated attribute makes it available for all profiles
     * within a domain. Each calculated attribute can only reference one <code>ObjectType</code> and at most, two fields
     * from that <code>ObjectType</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param createCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link CreateCalculatedAttributeDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCalculatedAttributeDefinitionResponse createCalculatedAttributeDefinition(
            Consumer<CreateCalculatedAttributeDefinitionRequest.Builder> createCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createCalculatedAttributeDefinition(CreateCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(createCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types,
     * profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party
     * integrations.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     *
     * @param createDomainRequest
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a domain, which is a container for all customer data, such as customer profile attributes, object types,
     * profile keys, and encryption keys. You can create multiple domains, and each domain can have multiple third-party
     * integrations.
     * </p>
     * <p>
     * Each Amazon Connect instance can be associated with only one domain. Multiple Amazon Connect instances can be
     * associated with one domain.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDomainRequest#builder()}
     * </p>
     *
     * @param createDomainRequest
     *        A {@link Consumer} that will call methods on {@link CreateDomainRequest.Builder} to create a request.
     * @return Result of the CreateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDomainResponse createDomain(Consumer<CreateDomainRequest.Builder> createDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createDomain(CreateDomainRequest.builder().applyMutation(createDomainRequest).build());
    }

    /**
     * <p>
     * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and
     * updated through Amazon Connect Customer Profiles.
     * </p>
     * <p>
     * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon
     * Web Services account as the customer profiles domain
     * </p>
     *
     * @param createEventStreamRequest
     * @return Result of the CreateEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventStreamResponse createEventStream(CreateEventStreamRequest createEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an event stream, which is a subscription to real-time events, such as when profiles are created and
     * updated through Amazon Connect Customer Profiles.
     * </p>
     * <p>
     * Each event stream can be associated with only one Kinesis Data Stream destination in the same region and Amazon
     * Web Services account as the customer profiles domain
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEventStreamRequest#builder()}
     * </p>
     *
     * @param createEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link CreateEventStreamRequest.Builder} to create a request.
     * @return Result of the CreateEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEventStreamResponse createEventStream(Consumer<CreateEventStreamRequest.Builder> createEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createEventStream(CreateEventStreamRequest.builder().applyMutation(createEventStreamRequest).build());
    }

    /**
     * <p>
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets
     * up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and
     * Marketo.
     * </p>
     *
     * @param createIntegrationWorkflowRequest
     * @return Result of the CreateIntegrationWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateIntegrationWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationWorkflowResponse createIntegrationWorkflow(
            CreateIntegrationWorkflowRequest createIntegrationWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an integration workflow. An integration workflow is an async process which ingests historic data and sets
     * up an integration for ongoing updates. The supported Amazon AppFlow sources are Salesforce, ServiceNow, and
     * Marketo.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIntegrationWorkflowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateIntegrationWorkflowRequest#builder()}
     * </p>
     *
     * @param createIntegrationWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link CreateIntegrationWorkflowRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIntegrationWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateIntegrationWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateIntegrationWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIntegrationWorkflowResponse createIntegrationWorkflow(
            Consumer<CreateIntegrationWorkflowRequest.Builder> createIntegrationWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return createIntegrationWorkflow(CreateIntegrationWorkflowRequest.builder()
                .applyMutation(createIntegrationWorkflowRequest).build());
    }

    /**
     * <p>
     * Creates a standard profile.
     * </p>
     * <p>
     * A standard profile represents the following attributes for a customer profile in a domain.
     * </p>
     *
     * @param createProfileRequest
     * @return Result of the CreateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(CreateProfileRequest createProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a standard profile.
     * </p>
     * <p>
     * A standard profile represents the following attributes for a customer profile in a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link CreateProfileRequest#builder()}
     * </p>
     *
     * @param createProfileRequest
     *        A {@link Consumer} that will call methods on {@link CreateProfileRequest.Builder} to create a request.
     * @return Result of the CreateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.CreateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/CreateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateProfileResponse createProfile(Consumer<CreateProfileRequest.Builder> createProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return createProfile(CreateProfileRequest.builder().applyMutation(createProfileRequest).build());
    }

    /**
     * <p>
     * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is
     * possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own
     * using the CreateCalculatedAttributeDefinition API if you want it back.
     * </p>
     *
     * @param deleteCalculatedAttributeDefinitionRequest
     * @return Result of the DeleteCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCalculatedAttributeDefinitionResponse deleteCalculatedAttributeDefinition(
            DeleteCalculatedAttributeDefinitionRequest deleteCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an existing calculated attribute definition. Note that deleting a default calculated attribute is
     * possible, however once deleted, you will be unable to undo that action and will need to recreate it on your own
     * using the CreateCalculatedAttributeDefinition API if you want it back.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param deleteCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteCalculatedAttributeDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCalculatedAttributeDefinitionResponse deleteCalculatedAttributeDefinition(
            Consumer<DeleteCalculatedAttributeDefinitionRequest.Builder> deleteCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteCalculatedAttributeDefinition(DeleteCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(deleteCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related
     * objects.
     * </p>
     *
     * @param deleteDomainRequest
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specific domain and all of its customer data, such as customer profile attributes and their related
     * objects.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDomainRequest#builder()}
     * </p>
     *
     * @param deleteDomainRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDomainRequest.Builder} to create a request.
     * @return Result of the DeleteDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDomainResponse deleteDomain(Consumer<DeleteDomainRequest.Builder> deleteDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteDomain(DeleteDomainRequest.builder().applyMutation(deleteDomainRequest).build());
    }

    /**
     * <p>
     * Disables and deletes the specified event stream.
     * </p>
     *
     * @param deleteEventStreamRequest
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(DeleteEventStreamRequest deleteEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables and deletes the specified event stream.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEventStreamRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEventStreamRequest#builder()}
     * </p>
     *
     * @param deleteEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEventStreamRequest.Builder} to create a request.
     * @return Result of the DeleteEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteEventStreamResponse deleteEventStream(Consumer<DeleteEventStreamRequest.Builder> deleteEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteEventStream(DeleteEventStreamRequest.builder().applyMutation(deleteEventStreamRequest).build());
    }

    /**
     * <p>
     * Removes an integration from a specific domain.
     * </p>
     *
     * @param deleteIntegrationRequest
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationResponse deleteIntegration(DeleteIntegrationRequest deleteIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an integration from a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIntegrationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteIntegrationRequest#builder()}
     * </p>
     *
     * @param deleteIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteIntegrationRequest.Builder} to create a request.
     * @return Result of the DeleteIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIntegrationResponse deleteIntegration(Consumer<DeleteIntegrationRequest.Builder> deleteIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteIntegration(DeleteIntegrationRequest.builder().applyMutation(deleteIntegrationRequest).build());
    }

    /**
     * <p>
     * Deletes the standard customer profile and all data pertaining to the profile.
     * </p>
     *
     * @param deleteProfileRequest
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(DeleteProfileRequest deleteProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the standard customer profile and all data pertaining to the profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteProfileRequest#builder()}
     * </p>
     *
     * @param deleteProfileRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileRequest.Builder} to create a request.
     * @return Result of the DeleteProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileResponse deleteProfile(Consumer<DeleteProfileRequest.Builder> deleteProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteProfile(DeleteProfileRequest.builder().applyMutation(deleteProfileRequest).build());
    }

    /**
     * <p>
     * Removes a searchable key from a customer profile.
     * </p>
     *
     * @param deleteProfileKeyRequest
     * @return Result of the DeleteProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileKeyResponse deleteProfileKey(DeleteProfileKeyRequest deleteProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a searchable key from a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileKeyRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteProfileKeyRequest#builder()}
     * </p>
     *
     * @param deleteProfileKeyRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileKeyRequest.Builder} to create a request.
     * @return Result of the DeleteProfileKey operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileKey"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileKeyResponse deleteProfileKey(Consumer<DeleteProfileKeyRequest.Builder> deleteProfileKeyRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteProfileKey(DeleteProfileKeyRequest.builder().applyMutation(deleteProfileKeyRequest).build());
    }

    /**
     * <p>
     * Removes an object associated with a profile of a given ProfileObjectType.
     * </p>
     *
     * @param deleteProfileObjectRequest
     * @return Result of the DeleteProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectResponse deleteProfileObject(DeleteProfileObjectRequest deleteProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an object associated with a profile of a given ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileObjectRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteProfileObjectRequest#builder()}
     * </p>
     *
     * @param deleteProfileObjectRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileObjectRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectResponse deleteProfileObject(
            Consumer<DeleteProfileObjectRequest.Builder> deleteProfileObjectRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return deleteProfileObject(DeleteProfileObjectRequest.builder().applyMutation(deleteProfileObjectRequest).build());
    }

    /**
     * <p>
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It
     * also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the
     * standard profile that were populated from this ProfileObjectType.
     * </p>
     *
     * @param deleteProfileObjectTypeRequest
     * @return Result of the DeleteProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectTypeResponse deleteProfileObjectType(DeleteProfileObjectTypeRequest deleteProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a ProfileObjectType from a specific domain as well as removes all the ProfileObjects of that type. It
     * also disables integrations from this specific ProfileObjectType. In addition, it scrubs all of the fields of the
     * standard profile that were populated from this ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteProfileObjectTypeRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param deleteProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on {@link DeleteProfileObjectTypeRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteProfileObjectTypeResponse deleteProfileObjectType(
            Consumer<DeleteProfileObjectTypeRequest.Builder> deleteProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return deleteProfileObjectType(DeleteProfileObjectTypeRequest.builder().applyMutation(deleteProfileObjectTypeRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     * </p>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified workflow and all its corresponding resources. This is an async process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWorkflowRequest.Builder} to create a request.
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/DeleteWorkflow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteWorkflowResponse deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a
     * sample of matching groups from the existing matching results, and applies the automerging settings that you
     * provided. You can then view the number of profiles in the sample, the number of matches, and the number of
     * profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching
     * list.
     * </p>
     * <p>
     * You can't view which profiles are matched and would be merged.
     * </p>
     * <important>
     * <p>
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity
     * Resolution Job. Include <b>at least</b> two matching attributes. If your matching list includes too few
     * attributes (such as only <code>FirstName</code> or only <code>LastName</code>), there may be a large number of
     * matches. This increases the chances of erroneous merges.
     * </p>
     * </important>
     *
     * @param getAutoMergingPreviewRequest
     * @return Result of the GetAutoMergingPreview operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetAutoMergingPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutoMergingPreviewResponse getAutoMergingPreview(GetAutoMergingPreviewRequest getAutoMergingPreviewRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tests the auto-merging settings of your Identity Resolution Job without merging your data. It randomly selects a
     * sample of matching groups from the existing matching results, and applies the automerging settings that you
     * provided. You can then view the number of profiles in the sample, the number of matches, and the number of
     * profiles identified to be merged. This enables you to evaluate the accuracy of the attributes in your matching
     * list.
     * </p>
     * <p>
     * You can't view which profiles are matched and would be merged.
     * </p>
     * <important>
     * <p>
     * We strongly recommend you use this API to do a dry run of the automerging process before running the Identity
     * Resolution Job. Include <b>at least</b> two matching attributes. If your matching list includes too few
     * attributes (such as only <code>FirstName</code> or only <code>LastName</code>), there may be a large number of
     * matches. This increases the chances of erroneous merges.
     * </p>
     * </important><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutoMergingPreviewRequest.Builder} avoiding the
     * need to create one manually via {@link GetAutoMergingPreviewRequest#builder()}
     * </p>
     *
     * @param getAutoMergingPreviewRequest
     *        A {@link Consumer} that will call methods on {@link GetAutoMergingPreviewRequest.Builder} to create a
     *        request.
     * @return Result of the GetAutoMergingPreview operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetAutoMergingPreview
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetAutoMergingPreview"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAutoMergingPreviewResponse getAutoMergingPreview(
            Consumer<GetAutoMergingPreviewRequest.Builder> getAutoMergingPreviewRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getAutoMergingPreview(GetAutoMergingPreviewRequest.builder().applyMutation(getAutoMergingPreviewRequest).build());
    }

    /**
     * <p>
     * Provides more information on a calculated attribute definition for Customer Profiles.
     * </p>
     *
     * @param getCalculatedAttributeDefinitionRequest
     * @return Result of the GetCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeDefinitionResponse getCalculatedAttributeDefinition(
            GetCalculatedAttributeDefinitionRequest getCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides more information on a calculated attribute definition for Customer Profiles.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param getCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link GetCalculatedAttributeDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the GetCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeDefinitionResponse getCalculatedAttributeDefinition(
            Consumer<GetCalculatedAttributeDefinitionRequest.Builder> getCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getCalculatedAttributeDefinition(GetCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(getCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Retrieve a calculated attribute for a customer profile.
     * </p>
     *
     * @param getCalculatedAttributeForProfileRequest
     * @return Result of the GetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeForProfileResponse getCalculatedAttributeForProfile(
            GetCalculatedAttributeForProfileRequest getCalculatedAttributeForProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a calculated attribute for a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalculatedAttributeForProfileRequest.Builder}
     * avoiding the need to create one manually via {@link GetCalculatedAttributeForProfileRequest#builder()}
     * </p>
     *
     * @param getCalculatedAttributeForProfileRequest
     *        A {@link Consumer} that will call methods on {@link GetCalculatedAttributeForProfileRequest.Builder} to
     *        create a request.
     * @return Result of the GetCalculatedAttributeForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetCalculatedAttributeForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetCalculatedAttributeForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default GetCalculatedAttributeForProfileResponse getCalculatedAttributeForProfile(
            Consumer<GetCalculatedAttributeForProfileRequest.Builder> getCalculatedAttributeForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getCalculatedAttributeForProfile(GetCalculatedAttributeForProfileRequest.builder()
                .applyMutation(getCalculatedAttributeForProfileRequest).build());
    }

    /**
     * <p>
     * Returns information about a specific domain.
     * </p>
     *
     * @param getDomainRequest
     * @return Result of the GetDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainResponse getDomain(GetDomainRequest getDomainRequest) throws BadRequestException, ResourceNotFoundException,
            AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainRequest#builder()}
     * </p>
     *
     * @param getDomainRequest
     *        A {@link Consumer} that will call methods on {@link GetDomainRequest.Builder} to create a request.
     * @return Result of the GetDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetDomain" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDomainResponse getDomain(Consumer<GetDomainRequest.Builder> getDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getDomain(GetDomainRequest.builder().applyMutation(getDomainRequest).build());
    }

    /**
     * <p>
     * Returns information about the specified event stream in a specific domain.
     * </p>
     *
     * @param getEventStreamRequest
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventStreamResponse getEventStream(GetEventStreamRequest getEventStreamRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about the specified event stream in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEventStreamRequest.Builder} avoiding the need to
     * create one manually via {@link GetEventStreamRequest#builder()}
     * </p>
     *
     * @param getEventStreamRequest
     *        A {@link Consumer} that will call methods on {@link GetEventStreamRequest.Builder} to create a request.
     * @return Result of the GetEventStream operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetEventStream
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetEventStream"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEventStreamResponse getEventStream(Consumer<GetEventStreamRequest.Builder> getEventStreamRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getEventStream(GetEventStreamRequest.builder().applyMutation(getEventStreamRequest).build());
    }

    /**
     * <p>
     * Returns information about an Identity Resolution Job in a specific domain.
     * </p>
     * <p>
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html">Use Identity Resolution
     * to consolidate similar profiles</a>.
     * </p>
     *
     * @param getIdentityResolutionJobRequest
     * @return Result of the GetIdentityResolutionJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIdentityResolutionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityResolutionJobResponse getIdentityResolutionJob(
            GetIdentityResolutionJobRequest getIdentityResolutionJobRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an Identity Resolution Job in a specific domain.
     * </p>
     * <p>
     * Identity Resolution Jobs are set up using the Amazon Connect admin console. For more information, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/use-identity-resolution.html">Use Identity Resolution
     * to consolidate similar profiles</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIdentityResolutionJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetIdentityResolutionJobRequest#builder()}
     * </p>
     *
     * @param getIdentityResolutionJobRequest
     *        A {@link Consumer} that will call methods on {@link GetIdentityResolutionJobRequest.Builder} to create a
     *        request.
     * @return Result of the GetIdentityResolutionJob operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIdentityResolutionJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIdentityResolutionJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIdentityResolutionJobResponse getIdentityResolutionJob(
            Consumer<GetIdentityResolutionJobRequest.Builder> getIdentityResolutionJobRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getIdentityResolutionJob(GetIdentityResolutionJobRequest.builder().applyMutation(getIdentityResolutionJobRequest)
                .build());
    }

    /**
     * <p>
     * Returns an integration for a domain.
     * </p>
     *
     * @param getIntegrationRequest
     * @return Result of the GetIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntegrationResponse getIntegration(GetIntegrationRequest getIntegrationRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an integration for a domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link GetIntegrationRequest#builder()}
     * </p>
     *
     * @param getIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link GetIntegrationRequest.Builder} to create a request.
     * @return Result of the GetIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntegrationResponse getIntegration(Consumer<GetIntegrationRequest.Builder> getIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getIntegration(GetIntegrationRequest.builder().applyMutation(getIntegrationRequest).build());
    }

    /**
     * <p>
     * Before calling this API, use <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or
     * <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a>
     * to enable identity resolution: set <code>Matching</code> to true.
     * </p>
     * <p>
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning
     * process.
     * </p>
     * <important>
     * <p>
     * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer
     * Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for
     * Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in
     * your domains.
     * </p>
     * <p>
     * After the Identity Resolution Job completes, use the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to
     * return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
     * <code>MatchingRequest</code>, you can download the results from S3.
     * </p>
     * </important>
     * <p>
     * Amazon Connect uses the following profile attributes to identify matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * HomePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessPhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * MobilePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * EmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * PersonalEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * FullName
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different
     * casing email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and <b>johndoe@anycompany.com</b>, or different
     * phone number formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the
     * same customer <b>John Doe</b> and merged into a unified profile.
     * </p>
     *
     * @param getMatchesRequest
     * @return Result of the GetMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMatchesResponse getMatches(GetMatchesRequest getMatchesRequest) throws BadRequestException, AccessDeniedException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Before calling this API, use <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> or
     * <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UpdateDomain.html">UpdateDomain</a>
     * to enable identity resolution: set <code>Matching</code> to true.
     * </p>
     * <p>
     * GetMatches returns potentially matching profiles, based on the results of the latest run of a machine learning
     * process.
     * </p>
     * <important>
     * <p>
     * The process of matching duplicate profiles. If <code>Matching</code> = <code>true</code>, Amazon Connect Customer
     * Profiles starts a weekly batch process called Identity Resolution Job. If you do not specify a date and time for
     * Identity Resolution Job to run, by default it runs every Saturday at 12AM UTC to detect duplicate profiles in
     * your domains.
     * </p>
     * <p>
     * After the Identity Resolution Job completes, use the <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a> API to
     * return and review the results. Or, if you have configured <code>ExportingConfig</code> in the
     * <code>MatchingRequest</code>, you can download the results from S3.
     * </p>
     * </important>
     * <p>
     * Amazon Connect uses the following profile attributes to identify matches:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * HomePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessPhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * MobilePhoneNumber
     * </p>
     * </li>
     * <li>
     * <p>
     * EmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * PersonalEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * BusinessEmailAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * FullName
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, two or more profiles—with spelling mistakes such as <b>John Doe</b> and <b>Jhn Doe</b>, or different
     * casing email addresses such as <b>JOHN_DOE@ANYCOMPANY.COM</b> and <b>johndoe@anycompany.com</b>, or different
     * phone number formats such as <b>555-010-0000</b> and <b>+1-555-010-0000</b>—can be detected as belonging to the
     * same customer <b>John Doe</b> and merged into a unified profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMatchesRequest.Builder} avoiding the need to
     * create one manually via {@link GetMatchesRequest#builder()}
     * </p>
     *
     * @param getMatchesRequest
     *        A {@link Consumer} that will call methods on {@link GetMatchesRequest.Builder} to create a request.
     * @return Result of the GetMatches operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetMatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetMatches" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMatchesResponse getMatches(Consumer<GetMatchesRequest.Builder> getMatchesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getMatches(GetMatchesRequest.builder().applyMutation(getMatchesRequest).build());
    }

    /**
     * <p>
     * Returns the object types for a specific domain.
     * </p>
     *
     * @param getProfileObjectTypeRequest
     * @return Result of the GetProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeResponse getProfileObjectType(GetProfileObjectTypeRequest getProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the object types for a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileObjectTypeRequest.Builder} avoiding the
     * need to create one manually via {@link GetProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param getProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileObjectTypeRequest.Builder} to create a
     *        request.
     * @return Result of the GetProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeResponse getProfileObjectType(
            Consumer<GetProfileObjectTypeRequest.Builder> getProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getProfileObjectType(GetProfileObjectTypeRequest.builder().applyMutation(getProfileObjectTypeRequest).build());
    }

    /**
     * <p>
     * Returns the template information for a specific object type.
     * </p>
     * <p>
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user
     * sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the
     * TemplateIds, it uses the mappings from the template.
     * </p>
     *
     * @param getProfileObjectTypeTemplateRequest
     * @return Result of the GetProfileObjectTypeTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectTypeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeTemplateResponse getProfileObjectTypeTemplate(
            GetProfileObjectTypeTemplateRequest getProfileObjectTypeTemplateRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the template information for a specific object type.
     * </p>
     * <p>
     * A template is a predefined ProfileObjectType, such as “Salesforce-Account” or “Salesforce-Contact.” When a user
     * sends a ProfileObject, using the PutProfileObject API, with an ObjectTypeName that matches one of the
     * TemplateIds, it uses the mappings from the template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetProfileObjectTypeTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link GetProfileObjectTypeTemplateRequest#builder()}
     * </p>
     *
     * @param getProfileObjectTypeTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetProfileObjectTypeTemplateRequest.Builder} to create
     *        a request.
     * @return Result of the GetProfileObjectTypeTemplate operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetProfileObjectTypeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetProfileObjectTypeTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetProfileObjectTypeTemplateResponse getProfileObjectTypeTemplate(
            Consumer<GetProfileObjectTypeTemplateRequest.Builder> getProfileObjectTypeTemplateRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getProfileObjectTypeTemplate(GetProfileObjectTypeTemplateRequest.builder()
                .applyMutation(getProfileObjectTypeTemplateRequest).build());
    }

    /**
     * <p>
     * Get details of specified workflow.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowRequest.Builder} to create a request.
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflow" target="_top">AWS
     *      API Documentation</a>
     */
    default GetWorkflowResponse getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Get granular list of steps in workflow.
     * </p>
     *
     * @param getWorkflowStepsRequest
     * @return Result of the GetWorkflowSteps operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepsResponse getWorkflowSteps(GetWorkflowStepsRequest getWorkflowStepsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get granular list of steps in workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowStepsRequest.Builder} avoiding the need
     * to create one manually via {@link GetWorkflowStepsRequest#builder()}
     * </p>
     *
     * @param getWorkflowStepsRequest
     *        A {@link Consumer} that will call methods on {@link GetWorkflowStepsRequest.Builder} to create a request.
     * @return Result of the GetWorkflowSteps operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.GetWorkflowSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/GetWorkflowSteps"
     *      target="_top">AWS API Documentation</a>
     */
    default GetWorkflowStepsResponse getWorkflowSteps(Consumer<GetWorkflowStepsRequest.Builder> getWorkflowStepsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return getWorkflowSteps(GetWorkflowStepsRequest.builder().applyMutation(getWorkflowStepsRequest).build());
    }

    /**
     * <p>
     * Lists all of the integrations associated to a specific URI in the AWS account.
     * </p>
     *
     * @param listAccountIntegrationsRequest
     * @return Result of the ListAccountIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListAccountIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountIntegrationsResponse listAccountIntegrations(ListAccountIntegrationsRequest listAccountIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the integrations associated to a specific URI in the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccountIntegrationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAccountIntegrationsRequest#builder()}
     * </p>
     *
     * @param listAccountIntegrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAccountIntegrationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAccountIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListAccountIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListAccountIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccountIntegrationsResponse listAccountIntegrations(
            Consumer<ListAccountIntegrationsRequest.Builder> listAccountIntegrationsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listAccountIntegrations(ListAccountIntegrationsRequest.builder().applyMutation(listAccountIntegrationsRequest)
                .build());
    }

    /**
     * <p>
     * Lists calculated attribute definitions for Customer Profiles
     * </p>
     *
     * @param listCalculatedAttributeDefinitionsRequest
     * @return Result of the ListCalculatedAttributeDefinitions operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributeDefinitionsResponse listCalculatedAttributeDefinitions(
            ListCalculatedAttributeDefinitionsRequest listCalculatedAttributeDefinitionsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists calculated attribute definitions for Customer Profiles
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculatedAttributeDefinitionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListCalculatedAttributeDefinitionsRequest#builder()}
     * </p>
     *
     * @param listCalculatedAttributeDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link ListCalculatedAttributeDefinitionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCalculatedAttributeDefinitions operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributeDefinitions
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributeDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributeDefinitionsResponse listCalculatedAttributeDefinitions(
            Consumer<ListCalculatedAttributeDefinitionsRequest.Builder> listCalculatedAttributeDefinitionsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listCalculatedAttributeDefinitions(ListCalculatedAttributeDefinitionsRequest.builder()
                .applyMutation(listCalculatedAttributeDefinitionsRequest).build());
    }

    /**
     * <p>
     * Retrieve a list of calculated attributes for a customer profile.
     * </p>
     *
     * @param listCalculatedAttributesForProfileRequest
     * @return Result of the ListCalculatedAttributesForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributesForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributesForProfileResponse listCalculatedAttributesForProfile(
            ListCalculatedAttributesForProfileRequest listCalculatedAttributesForProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve a list of calculated attributes for a customer profile.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCalculatedAttributesForProfileRequest.Builder}
     * avoiding the need to create one manually via {@link ListCalculatedAttributesForProfileRequest#builder()}
     * </p>
     *
     * @param listCalculatedAttributesForProfileRequest
     *        A {@link Consumer} that will call methods on {@link ListCalculatedAttributesForProfileRequest.Builder} to
     *        create a request.
     * @return Result of the ListCalculatedAttributesForProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListCalculatedAttributesForProfile
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListCalculatedAttributesForProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCalculatedAttributesForProfileResponse listCalculatedAttributesForProfile(
            Consumer<ListCalculatedAttributesForProfileRequest.Builder> listCalculatedAttributesForProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listCalculatedAttributesForProfile(ListCalculatedAttributesForProfileRequest.builder()
                .applyMutation(listCalculatedAttributesForProfileRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the domains for an AWS account that have been created.
     * </p>
     *
     * @param listDomainsRequest
     * @return Result of the ListDomains operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(ListDomainsRequest listDomainsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the domains for an AWS account that have been created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDomainsRequest#builder()}
     * </p>
     *
     * @param listDomainsRequest
     *        A {@link Consumer} that will call methods on {@link ListDomainsRequest.Builder} to create a request.
     * @return Result of the ListDomains operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListDomains
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListDomains" target="_top">AWS
     *      API Documentation</a>
     */
    default ListDomainsResponse listDomains(Consumer<ListDomainsRequest.Builder> listDomainsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listDomains(ListDomainsRequest.builder().applyMutation(listDomainsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     *
     * @param listEventStreamsRequest
     * @return Result of the ListEventStreams operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsResponse listEventStreams(ListEventStreamsRequest listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventStreamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventStreamsRequest#builder()}
     * </p>
     *
     * @param listEventStreamsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventStreamsRequest.Builder} to create a request.
     * @return Result of the ListEventStreams operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsResponse listEventStreams(Consumer<ListEventStreamsRequest.Builder> listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listEventStreams(ListEventStreamsRequest.builder().applyMutation(listEventStreamsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client
     *             .listEventStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEventStreamsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsIterable listEventStreamsPaginator(ListEventStreamsRequest listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return new ListEventStreamsIterable(this, listEventStreamsRequest);
    }

    /**
     * <p>
     * Returns a list of all the event streams in a specific domain.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client
     *             .listEventStreamsPaginator(request);
     *     for (software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.customerprofiles.paginators.ListEventStreamsIterable responses = client.listEventStreamsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEventStreams(software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEventStreamsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEventStreamsRequest#builder()}
     * </p>
     *
     * @param listEventStreamsRequest
     *        A {@link Consumer} that will call methods on {@link ListEventStreamsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListEventStreams
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListEventStreams"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEventStreamsIterable listEventStreamsPaginator(Consumer<ListEventStreamsRequest.Builder> listEventStreamsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listEventStreamsPaginator(ListEventStreamsRequest.builder().applyMutation(listEventStreamsRequest).build());
    }

    /**
     * <p>
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by
     * <code>JobStartTime</code>.
     * </p>
     *
     * @param listIdentityResolutionJobsRequest
     * @return Result of the ListIdentityResolutionJobs operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIdentityResolutionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityResolutionJobsResponse listIdentityResolutionJobs(
            ListIdentityResolutionJobsRequest listIdentityResolutionJobsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the Identity Resolution Jobs in your domain. The response sorts the list by
     * <code>JobStartTime</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIdentityResolutionJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListIdentityResolutionJobsRequest#builder()}
     * </p>
     *
     * @param listIdentityResolutionJobsRequest
     *        A {@link Consumer} that will call methods on {@link ListIdentityResolutionJobsRequest.Builder} to create a
     *        request.
     * @return Result of the ListIdentityResolutionJobs operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIdentityResolutionJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIdentityResolutionJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIdentityResolutionJobsResponse listIdentityResolutionJobs(
            Consumer<ListIdentityResolutionJobsRequest.Builder> listIdentityResolutionJobsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listIdentityResolutionJobs(ListIdentityResolutionJobsRequest.builder()
                .applyMutation(listIdentityResolutionJobsRequest).build());
    }

    /**
     * <p>
     * Lists all of the integrations in your domain.
     * </p>
     *
     * @param listIntegrationsRequest
     * @return Result of the ListIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationsResponse listIntegrations(ListIntegrationsRequest listIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the integrations in your domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListIntegrationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListIntegrationsRequest#builder()}
     * </p>
     *
     * @param listIntegrationsRequest
     *        A {@link Consumer} that will call methods on {@link ListIntegrationsRequest.Builder} to create a request.
     * @return Result of the ListIntegrations operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListIntegrations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListIntegrations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListIntegrationsResponse listIntegrations(Consumer<ListIntegrationsRequest.Builder> listIntegrationsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listIntegrations(ListIntegrationsRequest.builder().applyMutation(listIntegrationsRequest).build());
    }

    /**
     * <p>
     * Lists all of the template information for object types.
     * </p>
     *
     * @param listProfileObjectTypeTemplatesRequest
     * @return Result of the ListProfileObjectTypeTemplates operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypeTemplates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypeTemplatesResponse listProfileObjectTypeTemplates(
            ListProfileObjectTypeTemplatesRequest listProfileObjectTypeTemplatesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the template information for object types.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectTypeTemplatesRequest.Builder}
     * avoiding the need to create one manually via {@link ListProfileObjectTypeTemplatesRequest#builder()}
     * </p>
     *
     * @param listProfileObjectTypeTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileObjectTypeTemplatesRequest.Builder} to
     *        create a request.
     * @return Result of the ListProfileObjectTypeTemplates operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypeTemplates
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypeTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypeTemplatesResponse listProfileObjectTypeTemplates(
            Consumer<ListProfileObjectTypeTemplatesRequest.Builder> listProfileObjectTypeTemplatesRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listProfileObjectTypeTemplates(ListProfileObjectTypeTemplatesRequest.builder()
                .applyMutation(listProfileObjectTypeTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all of the templates available within the service.
     * </p>
     *
     * @param listProfileObjectTypesRequest
     * @return Result of the ListProfileObjectTypes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypesResponse listProfileObjectTypes(ListProfileObjectTypesRequest listProfileObjectTypesRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the templates available within the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectTypesRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfileObjectTypesRequest#builder()}
     * </p>
     *
     * @param listProfileObjectTypesRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileObjectTypesRequest.Builder} to create a
     *        request.
     * @return Result of the ListProfileObjectTypes operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjectTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjectTypes"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectTypesResponse listProfileObjectTypes(
            Consumer<ListProfileObjectTypesRequest.Builder> listProfileObjectTypesRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return listProfileObjectTypes(ListProfileObjectTypesRequest.builder().applyMutation(listProfileObjectTypesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     * </p>
     *
     * @param listProfileObjectsRequest
     * @return Result of the ListProfileObjects operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectsResponse listProfileObjects(ListProfileObjectsRequest listProfileObjectsRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of objects associated with a profile of a given ProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListProfileObjectsRequest.Builder} avoiding the
     * need to create one manually via {@link ListProfileObjectsRequest#builder()}
     * </p>
     *
     * @param listProfileObjectsRequest
     *        A {@link Consumer} that will call methods on {@link ListProfileObjectsRequest.Builder} to create a
     *        request.
     * @return Result of the ListProfileObjects operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListProfileObjects
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListProfileObjects"
     *      target="_top">AWS API Documentation</a>
     */
    default ListProfileObjectsResponse listProfileObjects(Consumer<ListProfileObjectsRequest.Builder> listProfileObjectsRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listProfileObjects(ListProfileObjectsRequest.builder().applyMutation(listProfileObjectsRequest).build());
    }

    /**
     * <p>
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Displays the tags associated with an Amazon Connect Customer Profiles resource. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Query to list all workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query to list all workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on {@link ListWorkflowsRequest.Builder} to create a request.
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/ListWorkflows"
     *      target="_top">AWS API Documentation</a>
     */
    default ListWorkflowsResponse listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Runs an AWS Lambda job that does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the objects in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the <code>ProfileToBeMerged</code> will be deleted at the end.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard fields are merged as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     * </p>
     * </li>
     * <li>
     * <p>
     * When there are conflicting fields:
     * </p>
     * <ol>
     * <li>
     * <p>
     * If no <code>SourceProfileIds</code> entry is specified, the main Profile value is always taken.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a <code>SourceProfileIds</code> entry is specified, the specified profileId is always taken, even if it is a
     * NULL value.
     * </p>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * <p>
     * You can use MergeProfiles together with <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which
     * returns potentially matching profiles, or use it with the results of another matching system. After profiles have
     * been merged, they cannot be separated (unmerged).
     * </p>
     *
     * @param mergeProfilesRequest
     * @return Result of the MergeProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.MergeProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default MergeProfilesResponse mergeProfiles(MergeProfilesRequest mergeProfilesRequest) throws BadRequestException,
            ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException, SdkClientException,
            CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Runs an AWS Lambda job that does the following:
     * </p>
     * <ol>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the objects in the <code>ProfileToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the <code>ProfileToBeMerged</code> will be deleted at the end.
     * </p>
     * </li>
     * <li>
     * <p>
     * All the profileKeys in the <code>ProfileIdsToBeMerged</code> will be moved to the main profile.
     * </p>
     * </li>
     * <li>
     * <p>
     * Standard fields are merged as follows:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Fields are always "union"-ed if there are no conflicts in standard fields or attributeKeys.
     * </p>
     * </li>
     * <li>
     * <p>
     * When there are conflicting fields:
     * </p>
     * <ol>
     * <li>
     * <p>
     * If no <code>SourceProfileIds</code> entry is specified, the main Profile value is always taken.
     * </p>
     * </li>
     * <li>
     * <p>
     * If a <code>SourceProfileIds</code> entry is specified, the specified profileId is always taken, even if it is a
     * NULL value.
     * </p>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * </li>
     * </ol>
     * <p>
     * You can use MergeProfiles together with <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">GetMatches</a>, which
     * returns potentially matching profiles, or use it with the results of another matching system. After profiles have
     * been merged, they cannot be separated (unmerged).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MergeProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link MergeProfilesRequest#builder()}
     * </p>
     *
     * @param mergeProfilesRequest
     *        A {@link Consumer} that will call methods on {@link MergeProfilesRequest.Builder} to create a request.
     * @return Result of the MergeProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.MergeProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/MergeProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default MergeProfilesResponse mergeProfiles(Consumer<MergeProfilesRequest.Builder> mergeProfilesRequest)
            throws BadRequestException, ResourceNotFoundException, ThrottlingException, InternalServerException,
            AwsServiceException, SdkClientException, CustomerProfilesException {
        return mergeProfiles(MergeProfilesRequest.builder().applyMutation(mergeProfilesRequest).build());
    }

    /**
     * <p>
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon
     * Connect.
     * </p>
     * <p>
     * An integration can belong to only one domain.
     * </p>
     * <p>
     * To add or remove tags on an existing Integration, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource </a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">
     * UntagResource</a>.
     * </p>
     *
     * @param putIntegrationRequest
     * @return Result of the PutIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutIntegrationResponse putIntegration(PutIntegrationRequest putIntegrationRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an integration between the service and a third-party service, which includes Amazon AppFlow and Amazon
     * Connect.
     * </p>
     * <p>
     * An integration can belong to only one domain.
     * </p>
     * <p>
     * To add or remove tags on an existing Integration, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource </a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">
     * UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutIntegrationRequest.Builder} avoiding the need to
     * create one manually via {@link PutIntegrationRequest#builder()}
     * </p>
     *
     * @param putIntegrationRequest
     *        A {@link Consumer} that will call methods on {@link PutIntegrationRequest.Builder} to create a request.
     * @return Result of the PutIntegration operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutIntegration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutIntegration"
     *      target="_top">AWS API Documentation</a>
     */
    default PutIntegrationResponse putIntegration(Consumer<PutIntegrationRequest.Builder> putIntegrationRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return putIntegration(PutIntegrationRequest.builder().applyMutation(putIntegrationRequest).build());
    }

    /**
     * <p>
     * Adds additional objects to customer profiles of a given ObjectType.
     * </p>
     * <p>
     * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not
     * mapped to an existing profile. The resulting profile will only have a phone number populated in the standard
     * ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred
     * profile.
     * </p>
     * <p>
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide
     * data to a standard profile depending on the ProfileObjectType definition.
     * </p>
     * <p>
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     * </p>
     *
     * @param putProfileObjectRequest
     * @return Result of the PutProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectResponse putProfileObject(PutProfileObjectRequest putProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds additional objects to customer profiles of a given ObjectType.
     * </p>
     * <p>
     * When adding a specific profile object, like a Contact Record, an inferred profile can get created if it is not
     * mapped to an existing profile. The resulting profile will only have a phone number populated in the standard
     * ProfileObject. Any additional Contact Records with the same phone number will be mapped to the same inferred
     * profile.
     * </p>
     * <p>
     * When a ProfileObject is created and if a ProfileObjectType already exists for the ProfileObject, it will provide
     * data to a standard profile depending on the ProfileObjectType definition.
     * </p>
     * <p>
     * PutProfileObject needs an ObjectType, which can be created using PutProfileObjectType.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileObjectRequest.Builder} avoiding the need
     * to create one manually via {@link PutProfileObjectRequest#builder()}
     * </p>
     *
     * @param putProfileObjectRequest
     *        A {@link Consumer} that will call methods on {@link PutProfileObjectRequest.Builder} to create a request.
     * @return Result of the PutProfileObject operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObject
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObject"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectResponse putProfileObject(Consumer<PutProfileObjectRequest.Builder> putProfileObjectRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return putProfileObject(PutProfileObjectRequest.builder().applyMutation(putProfileObjectRequest).build());
    }

    /**
     * <p>
     * Defines a ProfileObjectType.
     * </p>
     * <p>
     * To add or remove tags on an existing ObjectType, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     *
     * @param putProfileObjectTypeRequest
     * @return Result of the PutProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectTypeResponse putProfileObjectType(PutProfileObjectTypeRequest putProfileObjectTypeRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Defines a ProfileObjectType.
     * </p>
     * <p>
     * To add or remove tags on an existing ObjectType, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html"> TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutProfileObjectTypeRequest.Builder} avoiding the
     * need to create one manually via {@link PutProfileObjectTypeRequest#builder()}
     * </p>
     *
     * @param putProfileObjectTypeRequest
     *        A {@link Consumer} that will call methods on {@link PutProfileObjectTypeRequest.Builder} to create a
     *        request.
     * @return Result of the PutProfileObjectType operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.PutProfileObjectType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/PutProfileObjectType"
     *      target="_top">AWS API Documentation</a>
     */
    default PutProfileObjectTypeResponse putProfileObjectType(
            Consumer<PutProfileObjectTypeRequest.Builder> putProfileObjectTypeRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return putProfileObjectType(PutProfileObjectTypeRequest.builder().applyMutation(putProfileObjectTypeRequest).build());
    }

    /**
     * <p>
     * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone,
     * _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a
     * <code>KeyName</code> and <code>Values</code> list.
     * </p>
     * <p>
     * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s)
     * pairs using either <code>AND</code> or <code>OR</code> logic.
     * </p>
     *
     * @param searchProfilesRequest
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(SearchProfilesRequest searchProfilesRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for profiles within a specific domain using one or more predefined search keys (e.g., _fullName, _phone,
     * _email, _account, etc.) and/or custom-defined search keys. A search key is a data type pair that consists of a
     * <code>KeyName</code> and <code>Values</code> list.
     * </p>
     * <p>
     * This operation supports searching for profiles with a minimum of 1 key-value(s) pair and up to 5 key-value(s)
     * pairs using either <code>AND</code> or <code>OR</code> logic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchProfilesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchProfilesRequest#builder()}
     * </p>
     *
     * @param searchProfilesRequest
     *        A {@link Consumer} that will call methods on {@link SearchProfilesRequest.Builder} to create a request.
     * @return Result of the SearchProfiles operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.SearchProfiles
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/SearchProfiles"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchProfilesResponse searchProfiles(Consumer<SearchProfilesRequest.Builder> searchProfilesRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return searchProfiles(SearchProfilesRequest.builder().applyMutation(searchProfilesRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user permissions by granting a
     * user permission to access or change only resources with certain tag values. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag
     * is appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon Connect Customer Profiles resource. Tags can
     * help you organize and categorize your resources. You can also use them to scope user permissions by granting a
     * user permission to access or change only resources with certain tag values. In Connect Customer Profiles,
     * domains, profile object types, and integrations can be tagged.
     * </p>
     * <p>
     * Tags don't have any semantic meaning to AWS and are interpreted strictly as strings of characters.
     * </p>
     * <p>
     * You can use the TagResource action with a resource that already has tags. If you specify a new tag key, this tag
     * is appended to the list of tags associated with the resource. If you specify a tag key that is already associated
     * with the resource, the new tag value that you specify replaces the previous value for that tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer
     * Profiles, domains, profile object types, and integrations can be tagged.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            BadRequestException, ResourceNotFoundException, AwsServiceException, SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes one or more tags from the specified Amazon Connect Customer Profiles resource. In Connect Customer
     * Profiles, domains, profile object types, and integrations can be tagged.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, BadRequestException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date
     * range of a calculated attribute will not trigger inclusion of historical data greater than the current date
     * range.
     * </p>
     *
     * @param updateCalculatedAttributeDefinitionRequest
     * @return Result of the UpdateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCalculatedAttributeDefinitionResponse updateCalculatedAttributeDefinition(
            UpdateCalculatedAttributeDefinitionRequest updateCalculatedAttributeDefinitionRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing calculated attribute definition. When updating the Conditions, note that increasing the date
     * range of a calculated attribute will not trigger inclusion of historical data greater than the current date
     * range.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCalculatedAttributeDefinitionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateCalculatedAttributeDefinitionRequest#builder()}
     * </p>
     *
     * @param updateCalculatedAttributeDefinitionRequest
     *        A {@link Consumer} that will call methods on {@link UpdateCalculatedAttributeDefinitionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCalculatedAttributeDefinition operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateCalculatedAttributeDefinition
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateCalculatedAttributeDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCalculatedAttributeDefinitionResponse updateCalculatedAttributeDefinition(
            Consumer<UpdateCalculatedAttributeDefinitionRequest.Builder> updateCalculatedAttributeDefinitionRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateCalculatedAttributeDefinition(UpdateCalculatedAttributeDefinitionRequest.builder()
                .applyMutation(updateCalculatedAttributeDefinitionRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     * </p>
     * <p>
     * After a domain is created, the name can’t be changed.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <p>
     * To add or remove tags on an existing Domain, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html">TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     *
     * @param updateDomainRequest
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainResponse updateDomain(UpdateDomainRequest updateDomainRequest) throws BadRequestException,
            ResourceNotFoundException, AccessDeniedException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a domain, including creating or selecting a dead letter queue or an encryption key.
     * </p>
     * <p>
     * After a domain is created, the name can’t be changed.
     * </p>
     * <p>
     * Use this API or <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_CreateDomain.html">CreateDomain</a> to
     * enable <a href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_GetMatches.html">identity
     * resolution</a>: set <code>Matching</code> to true.
     * </p>
     * <p>
     * To prevent cross-service impersonation when you call this API, see <a
     * href="https://docs.aws.amazon.com/connect/latest/adminguide/cross-service-confused-deputy-prevention.html"
     * >Cross-service confused deputy prevention</a> for sample policies that you should apply.
     * </p>
     * <p>
     * To add or remove tags on an existing Domain, see <a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_TagResource.html">TagResource</a>/<a
     * href="https://docs.aws.amazon.com/customerprofiles/latest/APIReference/API_UntagResource.html">UntagResource</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateDomainRequest#builder()}
     * </p>
     *
     * @param updateDomainRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDomainRequest.Builder} to create a request.
     * @return Result of the UpdateDomain operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateDomain
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateDomain"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDomainResponse updateDomain(Consumer<UpdateDomainRequest.Builder> updateDomainRequest)
            throws BadRequestException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateDomain(UpdateDomainRequest.builder().applyMutation(updateDomainRequest).build());
    }

    /**
     * <p>
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     * </p>
     * <p>
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be
     * removed. Not specifying a string value means that any value already there will be kept.
     * </p>
     *
     * @param updateProfileRequest
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(UpdateProfileRequest updateProfileRequest) throws BadRequestException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InternalServerException, AwsServiceException,
            SdkClientException, CustomerProfilesException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the properties of a profile. The ProfileId is required for updating a customer profile.
     * </p>
     * <p>
     * When calling the UpdateProfile API, specifying an empty string value means that any existing value will be
     * removed. Not specifying a string value means that any value already there will be kept.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateProfileRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateProfileRequest#builder()}
     * </p>
     *
     * @param updateProfileRequest
     *        A {@link Consumer} that will call methods on {@link UpdateProfileRequest.Builder} to create a request.
     * @return Result of the UpdateProfile operation returned by the service.
     * @throws BadRequestException
     *         The input you provided is invalid.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws ResourceNotFoundException
     *         The requested resource does not exist, or access was denied.
     * @throws ThrottlingException
     *         You exceeded the maximum number of requests.
     * @throws InternalServerException
     *         An internal service error occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws CustomerProfilesException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample CustomerProfilesClient.UpdateProfile
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/customer-profiles-2020-08-15/UpdateProfile"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateProfileResponse updateProfile(Consumer<UpdateProfileRequest.Builder> updateProfileRequest)
            throws BadRequestException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InternalServerException, AwsServiceException, SdkClientException, CustomerProfilesException {
        return updateProfile(UpdateProfileRequest.builder().applyMutation(updateProfileRequest).build());
    }

    /**
     * Create a {@link CustomerProfilesClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static CustomerProfilesClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link CustomerProfilesClient}.
     */
    static CustomerProfilesClientBuilder builder() {
        return new DefaultCustomerProfilesClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default CustomerProfilesServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
