/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The day and time when do you want to start the Identity Resolution Job every week.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobSchedule implements SdkPojo, Serializable, ToCopyableBuilder<JobSchedule.Builder, JobSchedule> {
    private static final SdkField<String> DAY_OF_THE_WEEK_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DayOfTheWeek").getter(getter(JobSchedule::dayOfTheWeekAsString)).setter(setter(Builder::dayOfTheWeek))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DayOfTheWeek").build()).build();

    private static final SdkField<String> TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Time")
            .getter(getter(JobSchedule::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAY_OF_THE_WEEK_FIELD,
            TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dayOfTheWeek;

    private final String time;

    private JobSchedule(BuilderImpl builder) {
        this.dayOfTheWeek = builder.dayOfTheWeek;
        this.time = builder.time;
    }

    /**
     * <p>
     * The day when the Identity Resolution Job should run every week.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfTheWeek} will
     * return {@link JobScheduleDayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dayOfTheWeekAsString}.
     * </p>
     * 
     * @return The day when the Identity Resolution Job should run every week.
     * @see JobScheduleDayOfTheWeek
     */
    public final JobScheduleDayOfTheWeek dayOfTheWeek() {
        return JobScheduleDayOfTheWeek.fromValue(dayOfTheWeek);
    }

    /**
     * <p>
     * The day when the Identity Resolution Job should run every week.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #dayOfTheWeek} will
     * return {@link JobScheduleDayOfTheWeek#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #dayOfTheWeekAsString}.
     * </p>
     * 
     * @return The day when the Identity Resolution Job should run every week.
     * @see JobScheduleDayOfTheWeek
     */
    public final String dayOfTheWeekAsString() {
        return dayOfTheWeek;
    }

    /**
     * <p>
     * The time when the Identity Resolution Job should run every week.
     * </p>
     * 
     * @return The time when the Identity Resolution Job should run every week.
     */
    public final String time() {
        return time;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dayOfTheWeekAsString());
        hashCode = 31 * hashCode + Objects.hashCode(time());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobSchedule)) {
            return false;
        }
        JobSchedule other = (JobSchedule) obj;
        return Objects.equals(dayOfTheWeekAsString(), other.dayOfTheWeekAsString()) && Objects.equals(time(), other.time());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobSchedule").add("DayOfTheWeek", dayOfTheWeekAsString()).add("Time", time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DayOfTheWeek":
            return Optional.ofNullable(clazz.cast(dayOfTheWeekAsString()));
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobSchedule, T> g) {
        return obj -> g.apply((JobSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobSchedule> {
        /**
         * <p>
         * The day when the Identity Resolution Job should run every week.
         * </p>
         * 
         * @param dayOfTheWeek
         *        The day when the Identity Resolution Job should run every week.
         * @see JobScheduleDayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobScheduleDayOfTheWeek
         */
        Builder dayOfTheWeek(String dayOfTheWeek);

        /**
         * <p>
         * The day when the Identity Resolution Job should run every week.
         * </p>
         * 
         * @param dayOfTheWeek
         *        The day when the Identity Resolution Job should run every week.
         * @see JobScheduleDayOfTheWeek
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobScheduleDayOfTheWeek
         */
        Builder dayOfTheWeek(JobScheduleDayOfTheWeek dayOfTheWeek);

        /**
         * <p>
         * The time when the Identity Resolution Job should run every week.
         * </p>
         * 
         * @param time
         *        The time when the Identity Resolution Job should run every week.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(String time);
    }

    static final class BuilderImpl implements Builder {
        private String dayOfTheWeek;

        private String time;

        private BuilderImpl() {
        }

        private BuilderImpl(JobSchedule model) {
            dayOfTheWeek(model.dayOfTheWeek);
            time(model.time);
        }

        public final String getDayOfTheWeek() {
            return dayOfTheWeek;
        }

        public final void setDayOfTheWeek(String dayOfTheWeek) {
            this.dayOfTheWeek = dayOfTheWeek;
        }

        @Override
        public final Builder dayOfTheWeek(String dayOfTheWeek) {
            this.dayOfTheWeek = dayOfTheWeek;
            return this;
        }

        @Override
        public final Builder dayOfTheWeek(JobScheduleDayOfTheWeek dayOfTheWeek) {
            this.dayOfTheWeek(dayOfTheWeek == null ? null : dayOfTheWeek.toString());
            return this;
        }

        public final String getTime() {
            return time;
        }

        public final void setTime(String time) {
            this.time = time;
        }

        @Override
        public final Builder time(String time) {
            this.time = time;
            return this;
        }

        @Override
        public JobSchedule build() {
            return new JobSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
