/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutoMergingPreviewResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetAutoMergingPreviewResponse.Builder, GetAutoMergingPreviewResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetAutoMergingPreviewResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<Long> NUMBER_OF_MATCHES_IN_SAMPLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfMatchesInSample").getter(getter(GetAutoMergingPreviewResponse::numberOfMatchesInSample))
            .setter(setter(Builder::numberOfMatchesInSample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfMatchesInSample").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_PROFILES_IN_SAMPLE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfProfilesInSample").getter(getter(GetAutoMergingPreviewResponse::numberOfProfilesInSample))
            .setter(setter(Builder::numberOfProfilesInSample))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfProfilesInSample").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_PROFILES_WILL_BE_MERGED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfProfilesWillBeMerged")
            .getter(getter(GetAutoMergingPreviewResponse::numberOfProfilesWillBeMerged))
            .setter(setter(Builder::numberOfProfilesWillBeMerged))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfProfilesWillBeMerged")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            NUMBER_OF_MATCHES_IN_SAMPLE_FIELD, NUMBER_OF_PROFILES_IN_SAMPLE_FIELD, NUMBER_OF_PROFILES_WILL_BE_MERGED_FIELD));

    private final String domainName;

    private final Long numberOfMatchesInSample;

    private final Long numberOfProfilesInSample;

    private final Long numberOfProfilesWillBeMerged;

    private GetAutoMergingPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.numberOfMatchesInSample = builder.numberOfMatchesInSample;
        this.numberOfProfilesInSample = builder.numberOfProfilesInSample;
        this.numberOfProfilesWillBeMerged = builder.numberOfProfilesWillBeMerged;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The number of match groups in the domain that have been reviewed in this preview dry run.
     * </p>
     * 
     * @return The number of match groups in the domain that have been reviewed in this preview dry run.
     */
    public final Long numberOfMatchesInSample() {
        return numberOfMatchesInSample;
    }

    /**
     * <p>
     * The number of profiles found in this preview dry run.
     * </p>
     * 
     * @return The number of profiles found in this preview dry run.
     */
    public final Long numberOfProfilesInSample() {
        return numberOfProfilesInSample;
    }

    /**
     * <p>
     * The number of profiles that would be merged if this wasn't a preview dry run.
     * </p>
     * 
     * @return The number of profiles that would be merged if this wasn't a preview dry run.
     */
    public final Long numberOfProfilesWillBeMerged() {
        return numberOfProfilesWillBeMerged;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfMatchesInSample());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfProfilesInSample());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfProfilesWillBeMerged());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutoMergingPreviewResponse)) {
            return false;
        }
        GetAutoMergingPreviewResponse other = (GetAutoMergingPreviewResponse) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(numberOfMatchesInSample(), other.numberOfMatchesInSample())
                && Objects.equals(numberOfProfilesInSample(), other.numberOfProfilesInSample())
                && Objects.equals(numberOfProfilesWillBeMerged(), other.numberOfProfilesWillBeMerged());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutoMergingPreviewResponse").add("DomainName", domainName())
                .add("NumberOfMatchesInSample", numberOfMatchesInSample())
                .add("NumberOfProfilesInSample", numberOfProfilesInSample())
                .add("NumberOfProfilesWillBeMerged", numberOfProfilesWillBeMerged()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "NumberOfMatchesInSample":
            return Optional.ofNullable(clazz.cast(numberOfMatchesInSample()));
        case "NumberOfProfilesInSample":
            return Optional.ofNullable(clazz.cast(numberOfProfilesInSample()));
        case "NumberOfProfilesWillBeMerged":
            return Optional.ofNullable(clazz.cast(numberOfProfilesWillBeMerged()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutoMergingPreviewResponse, T> g) {
        return obj -> g.apply((GetAutoMergingPreviewResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutoMergingPreviewResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The number of match groups in the domain that have been reviewed in this preview dry run.
         * </p>
         * 
         * @param numberOfMatchesInSample
         *        The number of match groups in the domain that have been reviewed in this preview dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfMatchesInSample(Long numberOfMatchesInSample);

        /**
         * <p>
         * The number of profiles found in this preview dry run.
         * </p>
         * 
         * @param numberOfProfilesInSample
         *        The number of profiles found in this preview dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfProfilesInSample(Long numberOfProfilesInSample);

        /**
         * <p>
         * The number of profiles that would be merged if this wasn't a preview dry run.
         * </p>
         * 
         * @param numberOfProfilesWillBeMerged
         *        The number of profiles that would be merged if this wasn't a preview dry run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfProfilesWillBeMerged(Long numberOfProfilesWillBeMerged);
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private Long numberOfMatchesInSample;

        private Long numberOfProfilesInSample;

        private Long numberOfProfilesWillBeMerged;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutoMergingPreviewResponse model) {
            super(model);
            domainName(model.domainName);
            numberOfMatchesInSample(model.numberOfMatchesInSample);
            numberOfProfilesInSample(model.numberOfProfilesInSample);
            numberOfProfilesWillBeMerged(model.numberOfProfilesWillBeMerged);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final Long getNumberOfMatchesInSample() {
            return numberOfMatchesInSample;
        }

        public final void setNumberOfMatchesInSample(Long numberOfMatchesInSample) {
            this.numberOfMatchesInSample = numberOfMatchesInSample;
        }

        @Override
        public final Builder numberOfMatchesInSample(Long numberOfMatchesInSample) {
            this.numberOfMatchesInSample = numberOfMatchesInSample;
            return this;
        }

        public final Long getNumberOfProfilesInSample() {
            return numberOfProfilesInSample;
        }

        public final void setNumberOfProfilesInSample(Long numberOfProfilesInSample) {
            this.numberOfProfilesInSample = numberOfProfilesInSample;
        }

        @Override
        public final Builder numberOfProfilesInSample(Long numberOfProfilesInSample) {
            this.numberOfProfilesInSample = numberOfProfilesInSample;
            return this;
        }

        public final Long getNumberOfProfilesWillBeMerged() {
            return numberOfProfilesWillBeMerged;
        }

        public final void setNumberOfProfilesWillBeMerged(Long numberOfProfilesWillBeMerged) {
            this.numberOfProfilesWillBeMerged = numberOfProfilesWillBeMerged;
        }

        @Override
        public final Builder numberOfProfilesWillBeMerged(Long numberOfProfilesWillBeMerged) {
            this.numberOfProfilesWillBeMerged = numberOfProfilesWillBeMerged;
            return this;
        }

        @Override
        public GetAutoMergingPreviewResponse build() {
            return new GetAutoMergingPreviewResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
