/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetIdentityResolutionJobResponse extends CustomerProfilesResponse implements
        ToCopyableBuilder<GetIdentityResolutionJobResponse.Builder, GetIdentityResolutionJobResponse> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetIdentityResolutionJobResponse::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("JobId")
            .getter(getter(GetIdentityResolutionJobResponse::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetIdentityResolutionJobResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(GetIdentityResolutionJobResponse::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Instant> JOB_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobStartTime").getter(getter(GetIdentityResolutionJobResponse::jobStartTime))
            .setter(setter(Builder::jobStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStartTime").build()).build();

    private static final SdkField<Instant> JOB_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobEndTime").getter(getter(GetIdentityResolutionJobResponse::jobEndTime))
            .setter(setter(Builder::jobEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobEndTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(GetIdentityResolutionJobResponse::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<Instant> JOB_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("JobExpirationTime").getter(getter(GetIdentityResolutionJobResponse::jobExpirationTime))
            .setter(setter(Builder::jobExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobExpirationTime").build()).build();

    private static final SdkField<AutoMerging> AUTO_MERGING_FIELD = SdkField.<AutoMerging> builder(MarshallingType.SDK_POJO)
            .memberName("AutoMerging").getter(getter(GetIdentityResolutionJobResponse::autoMerging))
            .setter(setter(Builder::autoMerging)).constructor(AutoMerging::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMerging").build()).build();

    private static final SdkField<ExportingLocation> EXPORTING_LOCATION_FIELD = SdkField
            .<ExportingLocation> builder(MarshallingType.SDK_POJO).memberName("ExportingLocation")
            .getter(getter(GetIdentityResolutionJobResponse::exportingLocation)).setter(setter(Builder::exportingLocation))
            .constructor(ExportingLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportingLocation").build()).build();

    private static final SdkField<JobStats> JOB_STATS_FIELD = SdkField.<JobStats> builder(MarshallingType.SDK_POJO)
            .memberName("JobStats").getter(getter(GetIdentityResolutionJobResponse::jobStats)).setter(setter(Builder::jobStats))
            .constructor(JobStats::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobStats").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            JOB_ID_FIELD, STATUS_FIELD, MESSAGE_FIELD, JOB_START_TIME_FIELD, JOB_END_TIME_FIELD, LAST_UPDATED_AT_FIELD,
            JOB_EXPIRATION_TIME_FIELD, AUTO_MERGING_FIELD, EXPORTING_LOCATION_FIELD, JOB_STATS_FIELD));

    private final String domainName;

    private final String jobId;

    private final String status;

    private final String message;

    private final Instant jobStartTime;

    private final Instant jobEndTime;

    private final Instant lastUpdatedAt;

    private final Instant jobExpirationTime;

    private final AutoMerging autoMerging;

    private final ExportingLocation exportingLocation;

    private final JobStats jobStats;

    private GetIdentityResolutionJobResponse(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.jobId = builder.jobId;
        this.status = builder.status;
        this.message = builder.message;
        this.jobStartTime = builder.jobStartTime;
        this.jobEndTime = builder.jobEndTime;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.jobExpirationTime = builder.jobExpirationTime;
        this.autoMerging = builder.autoMerging;
        this.exportingLocation = builder.exportingLocation;
        this.jobStats = builder.jobStats;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The unique identifier of the Identity Resolution Job.
     * </p>
     * 
     * @return The unique identifier of the Identity Resolution Job.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The status of the Identity Resolution Job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
     * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify profiles
     * that belong to the same matching group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity Resolution
     * Job writes a message indicating the source of the problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
     * source of the problem.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentityResolutionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Identity Resolution Job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off
     *         the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
     *         profiles that belong to the same matching group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
     *         Resolution Job writes a message indicating the source of the problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating
     *         the source of the problem.
     *         </p>
     *         </li>
     * @see IdentityResolutionJobStatus
     */
    public final IdentityResolutionJobStatus status() {
        return IdentityResolutionJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Identity Resolution Job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
     * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify profiles
     * that belong to the same matching group.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity Resolution
     * Job writes a message indicating the source of the problem.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
     * source of the problem.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link IdentityResolutionJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Identity Resolution Job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off
     *         the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
     *         profiles that belong to the same matching group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
     *         Resolution Job writes a message indicating the source of the problem.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating
     *         the source of the problem.
     *         </p>
     *         </li>
     * @see IdentityResolutionJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The error messages that are generated when the Identity Resolution Job runs.
     * </p>
     * 
     * @return The error messages that are generated when the Identity Resolution Job runs.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The timestamp of when the Identity Resolution Job was started or will be started.
     * </p>
     * 
     * @return The timestamp of when the Identity Resolution Job was started or will be started.
     */
    public final Instant jobStartTime() {
        return jobStartTime;
    }

    /**
     * <p>
     * The timestamp of when the Identity Resolution Job was completed.
     * </p>
     * 
     * @return The timestamp of when the Identity Resolution Job was completed.
     */
    public final Instant jobEndTime() {
        return jobEndTime;
    }

    /**
     * <p>
     * The timestamp of when the Identity Resolution Job was most recently edited.
     * </p>
     * 
     * @return The timestamp of when the Identity Resolution Job was most recently edited.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The timestamp of when the Identity Resolution Job will expire.
     * </p>
     * 
     * @return The timestamp of when the Identity Resolution Job will expire.
     */
    public final Instant jobExpirationTime() {
        return jobExpirationTime;
    }

    /**
     * <p>
     * Configuration settings for how to perform the auto-merging of profiles.
     * </p>
     * 
     * @return Configuration settings for how to perform the auto-merging of profiles.
     */
    public final AutoMerging autoMerging() {
        return autoMerging;
    }

    /**
     * <p>
     * The S3 location where the Identity Resolution Job writes result files.
     * </p>
     * 
     * @return The S3 location where the Identity Resolution Job writes result files.
     */
    public final ExportingLocation exportingLocation() {
        return exportingLocation;
    }

    /**
     * <p>
     * Statistics about the Identity Resolution Job.
     * </p>
     * 
     * @return Statistics about the Identity Resolution Job.
     */
    public final JobStats jobStats() {
        return jobStats;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(jobStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(jobEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(jobExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(autoMerging());
        hashCode = 31 * hashCode + Objects.hashCode(exportingLocation());
        hashCode = 31 * hashCode + Objects.hashCode(jobStats());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityResolutionJobResponse)) {
            return false;
        }
        GetIdentityResolutionJobResponse other = (GetIdentityResolutionJobResponse) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(jobStartTime(), other.jobStartTime()) && Objects.equals(jobEndTime(), other.jobEndTime())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(jobExpirationTime(), other.jobExpirationTime())
                && Objects.equals(autoMerging(), other.autoMerging())
                && Objects.equals(exportingLocation(), other.exportingLocation()) && Objects.equals(jobStats(), other.jobStats());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetIdentityResolutionJobResponse").add("DomainName", domainName()).add("JobId", jobId())
                .add("Status", statusAsString()).add("Message", message()).add("JobStartTime", jobStartTime())
                .add("JobEndTime", jobEndTime()).add("LastUpdatedAt", lastUpdatedAt())
                .add("JobExpirationTime", jobExpirationTime()).add("AutoMerging", autoMerging())
                .add("ExportingLocation", exportingLocation()).add("JobStats", jobStats()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "JobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "JobStartTime":
            return Optional.ofNullable(clazz.cast(jobStartTime()));
        case "JobEndTime":
            return Optional.ofNullable(clazz.cast(jobEndTime()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "JobExpirationTime":
            return Optional.ofNullable(clazz.cast(jobExpirationTime()));
        case "AutoMerging":
            return Optional.ofNullable(clazz.cast(autoMerging()));
        case "ExportingLocation":
            return Optional.ofNullable(clazz.cast(exportingLocation()));
        case "JobStats":
            return Optional.ofNullable(clazz.cast(jobStats()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetIdentityResolutionJobResponse, T> g) {
        return obj -> g.apply((GetIdentityResolutionJobResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetIdentityResolutionJobResponse> {
        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The unique identifier of the Identity Resolution Job.
         * </p>
         * 
         * @param jobId
         *        The unique identifier of the Identity Resolution Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The status of the Identity Resolution Job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
         * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
         * profiles that belong to the same matching group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         * Resolution Job writes a message indicating the source of the problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
         * source of the problem.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Identity Resolution Job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn
         *        off the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to
         *        identify profiles that belong to the same matching group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         *        Resolution Job writes a message indicating the source of the problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message
         *        indicating the source of the problem.
         *        </p>
         *        </li>
         * @see IdentityResolutionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityResolutionJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Identity Resolution Job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn off the
         * Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are deleted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to identify
         * profiles that belong to the same matching group.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         * Resolution Job writes a message indicating the source of the problem.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message indicating the
         * source of the problem.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the Identity Resolution Job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>: The Identity Resolution Job is scheduled but has not started yet. If you turn
         *        off the Identity Resolution feature in your domain, jobs in the <code>PENDING</code> state are
         *        deleted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PREPROCESSING</code>: The Identity Resolution Job is loading your data.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FIND_MATCHING</code>: The Identity Resolution Job is using the machine learning model to
         *        identify profiles that belong to the same matching group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>MERGING</code>: The Identity Resolution Job is merging duplicate profiles.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETED</code>: The Identity Resolution Job completed successfully.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PARTIAL_SUCCESS</code>: There's a system error and not all of the data is merged. The Identity
         *        Resolution Job writes a message indicating the source of the problem.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>: The Identity Resolution Job did not merge any data. It writes a message
         *        indicating the source of the problem.
         *        </p>
         *        </li>
         * @see IdentityResolutionJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IdentityResolutionJobStatus
         */
        Builder status(IdentityResolutionJobStatus status);

        /**
         * <p>
         * The error messages that are generated when the Identity Resolution Job runs.
         * </p>
         * 
         * @param message
         *        The error messages that are generated when the Identity Resolution Job runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The timestamp of when the Identity Resolution Job was started or will be started.
         * </p>
         * 
         * @param jobStartTime
         *        The timestamp of when the Identity Resolution Job was started or will be started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStartTime(Instant jobStartTime);

        /**
         * <p>
         * The timestamp of when the Identity Resolution Job was completed.
         * </p>
         * 
         * @param jobEndTime
         *        The timestamp of when the Identity Resolution Job was completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobEndTime(Instant jobEndTime);

        /**
         * <p>
         * The timestamp of when the Identity Resolution Job was most recently edited.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp of when the Identity Resolution Job was most recently edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The timestamp of when the Identity Resolution Job will expire.
         * </p>
         * 
         * @param jobExpirationTime
         *        The timestamp of when the Identity Resolution Job will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobExpirationTime(Instant jobExpirationTime);

        /**
         * <p>
         * Configuration settings for how to perform the auto-merging of profiles.
         * </p>
         * 
         * @param autoMerging
         *        Configuration settings for how to perform the auto-merging of profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMerging(AutoMerging autoMerging);

        /**
         * <p>
         * Configuration settings for how to perform the auto-merging of profiles.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoMerging.Builder} avoiding the need to
         * create one manually via {@link AutoMerging#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoMerging.Builder#build()} is called immediately and its result
         * is passed to {@link #autoMerging(AutoMerging)}.
         * 
         * @param autoMerging
         *        a consumer that will call methods on {@link AutoMerging.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoMerging(AutoMerging)
         */
        default Builder autoMerging(Consumer<AutoMerging.Builder> autoMerging) {
            return autoMerging(AutoMerging.builder().applyMutation(autoMerging).build());
        }

        /**
         * <p>
         * The S3 location where the Identity Resolution Job writes result files.
         * </p>
         * 
         * @param exportingLocation
         *        The S3 location where the Identity Resolution Job writes result files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportingLocation(ExportingLocation exportingLocation);

        /**
         * <p>
         * The S3 location where the Identity Resolution Job writes result files.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportingLocation.Builder} avoiding the
         * need to create one manually via {@link ExportingLocation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportingLocation.Builder#build()} is called immediately and its
         * result is passed to {@link #exportingLocation(ExportingLocation)}.
         * 
         * @param exportingLocation
         *        a consumer that will call methods on {@link ExportingLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportingLocation(ExportingLocation)
         */
        default Builder exportingLocation(Consumer<ExportingLocation.Builder> exportingLocation) {
            return exportingLocation(ExportingLocation.builder().applyMutation(exportingLocation).build());
        }

        /**
         * <p>
         * Statistics about the Identity Resolution Job.
         * </p>
         * 
         * @param jobStats
         *        Statistics about the Identity Resolution Job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobStats(JobStats jobStats);

        /**
         * <p>
         * Statistics about the Identity Resolution Job.
         * </p>
         * This is a convenience method that creates an instance of the {@link JobStats.Builder} avoiding the need to
         * create one manually via {@link JobStats#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link JobStats.Builder#build()} is called immediately and its result is
         * passed to {@link #jobStats(JobStats)}.
         * 
         * @param jobStats
         *        a consumer that will call methods on {@link JobStats.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobStats(JobStats)
         */
        default Builder jobStats(Consumer<JobStats.Builder> jobStats) {
            return jobStats(JobStats.builder().applyMutation(jobStats).build());
        }
    }

    static final class BuilderImpl extends CustomerProfilesResponse.BuilderImpl implements Builder {
        private String domainName;

        private String jobId;

        private String status;

        private String message;

        private Instant jobStartTime;

        private Instant jobEndTime;

        private Instant lastUpdatedAt;

        private Instant jobExpirationTime;

        private AutoMerging autoMerging;

        private ExportingLocation exportingLocation;

        private JobStats jobStats;

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityResolutionJobResponse model) {
            super(model);
            domainName(model.domainName);
            jobId(model.jobId);
            status(model.status);
            message(model.message);
            jobStartTime(model.jobStartTime);
            jobEndTime(model.jobEndTime);
            lastUpdatedAt(model.lastUpdatedAt);
            jobExpirationTime(model.jobExpirationTime);
            autoMerging(model.autoMerging);
            exportingLocation(model.exportingLocation);
            jobStats(model.jobStats);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(IdentityResolutionJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Instant getJobStartTime() {
            return jobStartTime;
        }

        public final void setJobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
        }

        @Override
        public final Builder jobStartTime(Instant jobStartTime) {
            this.jobStartTime = jobStartTime;
            return this;
        }

        public final Instant getJobEndTime() {
            return jobEndTime;
        }

        public final void setJobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
        }

        @Override
        public final Builder jobEndTime(Instant jobEndTime) {
            this.jobEndTime = jobEndTime;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final Instant getJobExpirationTime() {
            return jobExpirationTime;
        }

        public final void setJobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
        }

        @Override
        public final Builder jobExpirationTime(Instant jobExpirationTime) {
            this.jobExpirationTime = jobExpirationTime;
            return this;
        }

        public final AutoMerging.Builder getAutoMerging() {
            return autoMerging != null ? autoMerging.toBuilder() : null;
        }

        public final void setAutoMerging(AutoMerging.BuilderImpl autoMerging) {
            this.autoMerging = autoMerging != null ? autoMerging.build() : null;
        }

        @Override
        public final Builder autoMerging(AutoMerging autoMerging) {
            this.autoMerging = autoMerging;
            return this;
        }

        public final ExportingLocation.Builder getExportingLocation() {
            return exportingLocation != null ? exportingLocation.toBuilder() : null;
        }

        public final void setExportingLocation(ExportingLocation.BuilderImpl exportingLocation) {
            this.exportingLocation = exportingLocation != null ? exportingLocation.build() : null;
        }

        @Override
        public final Builder exportingLocation(ExportingLocation exportingLocation) {
            this.exportingLocation = exportingLocation;
            return this;
        }

        public final JobStats.Builder getJobStats() {
            return jobStats != null ? jobStats.toBuilder() : null;
        }

        public final void setJobStats(JobStats.BuilderImpl jobStats) {
            this.jobStats = jobStats != null ? jobStats.build() : null;
        }

        @Override
        public final Builder jobStats(JobStats jobStats) {
            this.jobStats = jobStats;
            return this;
        }

        @Override
        public GetIdentityResolutionJobResponse build() {
            return new GetIdentityResolutionJobResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
