/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.customerprofiles.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.customerprofiles.CustomerProfilesClient;
import software.amazon.awssdk.services.customerprofiles.model.EventStreamSummary;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsRequest;
import software.amazon.awssdk.services.customerprofiles.model.ListEventStreamsResponse;

public class ListEventStreamsIterable
implements SdkIterable<ListEventStreamsResponse> {
    private final CustomerProfilesClient client;
    private final ListEventStreamsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEventStreamsIterable(CustomerProfilesClient client, ListEventStreamsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEventStreamsResponseFetcher();
    }

    public Iterator<ListEventStreamsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EventStreamSummary> items() {
        Function<ListEventStreamsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEventStreamsResponseFetcher
    implements SyncPageFetcher<ListEventStreamsResponse> {
        private ListEventStreamsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventStreamsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEventStreamsResponse nextPage(ListEventStreamsResponse previousPage) {
            if (previousPage == null) {
                return ListEventStreamsIterable.this.client.listEventStreams(ListEventStreamsIterable.this.firstRequest);
            }
            return ListEventStreamsIterable.this.client.listEventStreams((ListEventStreamsRequest)((Object)ListEventStreamsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

