/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSimilarProfilesRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<GetSimilarProfilesRequest.Builder, GetSimilarProfilesRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetSimilarProfilesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("next-token").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetSimilarProfilesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("max-results").build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(GetSimilarProfilesRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> MATCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MatchType").getter(getter(GetSimilarProfilesRequest::matchTypeAsString))
            .setter(setter(Builder::matchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchType").build()).build();

    private static final SdkField<String> SEARCH_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchKey").getter(getter(GetSimilarProfilesRequest::searchKey)).setter(setter(Builder::searchKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchKey").build()).build();

    private static final SdkField<String> SEARCH_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchValue").getter(getter(GetSimilarProfilesRequest::searchValue))
            .setter(setter(Builder::searchValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, DOMAIN_NAME_FIELD, MATCH_TYPE_FIELD, SEARCH_KEY_FIELD, SEARCH_VALUE_FIELD));

    private final String nextToken;

    private final Integer maxResults;

    private final String domainName;

    private final String matchType;

    private final String searchKey;

    private final String searchValue;

    private GetSimilarProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.domainName = builder.domainName;
        this.matchType = builder.matchType;
        this.searchKey = builder.searchKey;
        this.searchValue = builder.searchValue;
    }

    /**
     * <p>
     * The pagination token from the previous <code>GetSimilarProfiles</code> API call.
     * </p>
     * 
     * @return The pagination token from the previous <code>GetSimilarProfiles</code> API call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of objects returned per page.
     * </p>
     * 
     * @return The maximum number of objects returned per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * Specify the type of matching to get similar profiles for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specify the type of matching to get similar profiles for.
     * @see MatchType
     */
    public final MatchType matchType() {
        return MatchType.fromValue(matchType);
    }

    /**
     * <p>
     * Specify the type of matching to get similar profiles for.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #matchType} will
     * return {@link MatchType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #matchTypeAsString}.
     * </p>
     * 
     * @return Specify the type of matching to get similar profiles for.
     * @see MatchType
     */
    public final String matchTypeAsString() {
        return matchType;
    }

    /**
     * <p>
     * The string indicating the search key to be used.
     * </p>
     * 
     * @return The string indicating the search key to be used.
     */
    public final String searchKey() {
        return searchKey;
    }

    /**
     * <p>
     * The string based on <code>SearchKey</code> to be searched for similar profiles.
     * </p>
     * 
     * @return The string based on <code>SearchKey</code> to be searched for similar profiles.
     */
    public final String searchValue() {
        return searchValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(matchTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(searchKey());
        hashCode = 31 * hashCode + Objects.hashCode(searchValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSimilarProfilesRequest)) {
            return false;
        }
        GetSimilarProfilesRequest other = (GetSimilarProfilesRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(domainName(), other.domainName())
                && Objects.equals(matchTypeAsString(), other.matchTypeAsString())
                && Objects.equals(searchKey(), other.searchKey()) && Objects.equals(searchValue(), other.searchValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSimilarProfilesRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("DomainName", domainName()).add("MatchType", matchTypeAsString()).add("SearchKey", searchKey())
                .add("SearchValue", searchValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "MatchType":
            return Optional.ofNullable(clazz.cast(matchTypeAsString()));
        case "SearchKey":
            return Optional.ofNullable(clazz.cast(searchKey()));
        case "SearchValue":
            return Optional.ofNullable(clazz.cast(searchValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSimilarProfilesRequest, T> g) {
        return obj -> g.apply((GetSimilarProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetSimilarProfilesRequest> {
        /**
         * <p>
         * The pagination token from the previous <code>GetSimilarProfiles</code> API call.
         * </p>
         * 
         * @param nextToken
         *        The pagination token from the previous <code>GetSimilarProfiles</code> API call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of objects returned per page.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of objects returned per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * Specify the type of matching to get similar profiles for.
         * </p>
         * 
         * @param matchType
         *        Specify the type of matching to get similar profiles for.
         * @see MatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchType
         */
        Builder matchType(String matchType);

        /**
         * <p>
         * Specify the type of matching to get similar profiles for.
         * </p>
         * 
         * @param matchType
         *        Specify the type of matching to get similar profiles for.
         * @see MatchType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MatchType
         */
        Builder matchType(MatchType matchType);

        /**
         * <p>
         * The string indicating the search key to be used.
         * </p>
         * 
         * @param searchKey
         *        The string indicating the search key to be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchKey(String searchKey);

        /**
         * <p>
         * The string based on <code>SearchKey</code> to be searched for similar profiles.
         * </p>
         * 
         * @param searchValue
         *        The string based on <code>SearchKey</code> to be searched for similar profiles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchValue(String searchValue);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private String domainName;

        private String matchType;

        private String searchKey;

        private String searchValue;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSimilarProfilesRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            domainName(model.domainName);
            matchType(model.matchType);
            searchKey(model.searchKey);
            searchValue(model.searchValue);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getMatchType() {
            return matchType;
        }

        public final void setMatchType(String matchType) {
            this.matchType = matchType;
        }

        @Override
        public final Builder matchType(String matchType) {
            this.matchType = matchType;
            return this;
        }

        @Override
        public final Builder matchType(MatchType matchType) {
            this.matchType(matchType == null ? null : matchType.toString());
            return this;
        }

        public final String getSearchKey() {
            return searchKey;
        }

        public final void setSearchKey(String searchKey) {
            this.searchKey = searchKey;
        }

        @Override
        public final Builder searchKey(String searchKey) {
            this.searchKey = searchKey;
            return this;
        }

        public final String getSearchValue() {
            return searchValue;
        }

        public final void setSearchValue(String searchValue) {
            this.searchValue = searchValue;
        }

        @Override
        public final Builder searchValue(String searchValue) {
            this.searchValue = searchValue;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSimilarProfilesRequest build() {
            return new GetSimilarProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
