/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.customerprofiles.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DetectProfileObjectTypeRequest extends CustomerProfilesRequest implements
        ToCopyableBuilder<DetectProfileObjectTypeRequest.Builder, DetectProfileObjectTypeRequest> {
    private static final SdkField<List<String>> OBJECTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Objects")
            .getter(getter(DetectProfileObjectTypeRequest::objects))
            .setter(setter(Builder::objects))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Objects").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DetectProfileObjectTypeRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECTS_FIELD,
            DOMAIN_NAME_FIELD));

    private final List<String> objects;

    private final String domainName;

    private DetectProfileObjectTypeRequest(BuilderImpl builder) {
        super(builder);
        this.objects = builder.objects;
        this.domainName = builder.domainName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Objects property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasObjects() {
        return objects != null && !(objects instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A string that is serialized from a JSON object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasObjects} method.
     * </p>
     * 
     * @return A string that is serialized from a JSON object.
     */
    public final List<String> objects() {
        return objects;
    }

    /**
     * <p>
     * The unique name of the domain.
     * </p>
     * 
     * @return The unique name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasObjects() ? objects() : null);
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectProfileObjectTypeRequest)) {
            return false;
        }
        DetectProfileObjectTypeRequest other = (DetectProfileObjectTypeRequest) obj;
        return hasObjects() == other.hasObjects() && Objects.equals(objects(), other.objects())
                && Objects.equals(domainName(), other.domainName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DetectProfileObjectTypeRequest")
                .add("Objects", objects() == null ? null : "*** Sensitive Data Redacted ***").add("DomainName", domainName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Objects":
            return Optional.ofNullable(clazz.cast(objects()));
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DetectProfileObjectTypeRequest, T> g) {
        return obj -> g.apply((DetectProfileObjectTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CustomerProfilesRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DetectProfileObjectTypeRequest> {
        /**
         * <p>
         * A string that is serialized from a JSON object.
         * </p>
         * 
         * @param objects
         *        A string that is serialized from a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(Collection<String> objects);

        /**
         * <p>
         * A string that is serialized from a JSON object.
         * </p>
         * 
         * @param objects
         *        A string that is serialized from a JSON object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objects(String... objects);

        /**
         * <p>
         * The unique name of the domain.
         * </p>
         * 
         * @param domainName
         *        The unique name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CustomerProfilesRequest.BuilderImpl implements Builder {
        private List<String> objects = DefaultSdkAutoConstructList.getInstance();

        private String domainName;

        private BuilderImpl() {
        }

        private BuilderImpl(DetectProfileObjectTypeRequest model) {
            super(model);
            objects(model.objects);
            domainName(model.domainName);
        }

        public final Collection<String> getObjects() {
            if (objects instanceof SdkAutoConstructList) {
                return null;
            }
            return objects;
        }

        public final void setObjects(Collection<String> objects) {
            this.objects = ObjectsCopier.copy(objects);
        }

        @Override
        public final Builder objects(Collection<String> objects) {
            this.objects = ObjectsCopier.copy(objects);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objects(String... objects) {
            objects(Arrays.asList(objects));
            return this;
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DetectProfileObjectTypeRequest build() {
            return new DetectProfileObjectTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
